/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.r.cmd.ui.launching;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import org.eclipse.core.databinding.Binding;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.beans.typed.BeanProperties;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.IValueChangeListener;
import org.eclipse.core.databinding.observable.value.ValueChangeEvent;
import org.eclipse.core.databinding.observable.value.WritableValue;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.databinding.validation.ValidationStatus;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.ILaunchConfigurationDialog;
import org.eclipse.debug.ui.ILaunchConfigurationTab;
import org.eclipse.jface.databinding.swt.typed.WidgetProperties;
import org.eclipse.jface.databinding.viewers.IViewerObservableValue;
import org.eclipse.jface.databinding.viewers.typed.ViewerProperties;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.statet.ecommons.databinding.core.validation.UpdateableErrorValidator;
import org.eclipse.statet.ecommons.debug.core.util.LaunchUtils;
import org.eclipse.statet.ecommons.debug.ui.config.InputArgumentsComposite;
import org.eclipse.statet.ecommons.debug.ui.config.LaunchConfigTabWithDbc;
import org.eclipse.statet.ecommons.debug.ui.util.HelpRequestor;
import org.eclipse.statet.ecommons.models.AbstractSettingsModelObject;
import org.eclipse.statet.ecommons.ui.SharedMessages;
import org.eclipse.statet.ecommons.ui.SharedUIResources;
import org.eclipse.statet.ecommons.ui.util.LayoutUtils;
import org.eclipse.statet.ecommons.ui.util.VariableFilterUtils;
import org.eclipse.statet.ecommons.ui.workbench.ResourceInputComposite;
import org.eclipse.statet.internal.r.cmd.ui.launching.Messages;
import org.eclipse.statet.jcommons.collections.ImCollections;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.r.core.renv.IREnvConfiguration;
import org.eclipse.statet.r.launching.core.RLaunching;
import org.eclipse.statet.r.launching.ui.REnvTab;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.statushandlers.StatusManager;

public class RCmdMainTab
extends LaunchConfigTabWithDbc {
    public static final String NS = "org.eclipse.statet.r.debug/RCmd/";
    private Cmd[] commands;
    private Cmd customCommand;
    private final IObservableValue<Cmd> cmdValue;
    private final IObservableValue<String> argumentsValue;
    private final IObservableValue<String> resourceValue;
    private final IObservableValue<String> workingDirectoryValue;
    private ComboViewer cmdCombo;
    private Text cmdText;
    private Button helpButton;
    private InputArgumentsComposite argumentsControl;
    private ResourceInputComposite resourceControl;
    private ResourceInputComposite workingDirectoryControl;
    boolean withHelp = false;
    private ILaunchConfigurationTab rEnvTab;
    private ILaunchConfiguration configCache;

    public RCmdMainTab() {
        this.createCommands();
        Realm realm = this.getRealm();
        this.cmdValue = new WritableValue(realm, null, Cmd.class);
        this.argumentsValue = new WritableValue(realm, null, String.class);
        this.resourceValue = new WritableValue(realm, null, String.class);
        this.workingDirectoryValue = new WritableValue(realm, null, String.class);
    }

    private void createCommands() {
        ArrayList<Cmd> commands = new ArrayList<Cmd>();
        commands.add(new Cmd(Messages.RCmd_CmdCheck_name, "CMD check", 2));
        commands.add(new Cmd(Messages.RCmd_CmdBuild_name, "CMD build", 1));
        commands.add(new Cmd(Messages.RCmd_CmdInstall_name, "CMD INSTALL", 2));
        commands.add(new Cmd(Messages.RCmd_CmdRemove_name, "CMD REMOVE", 1));
        commands.add(new Cmd(Messages.RCmd_CmdRdconv_name, "CMD Rdconv", 3));
        commands.add(new Cmd(Messages.RCmd_CmdRd2dvi_name, "CMD Rd2dvi", 4));
        commands.add(new Cmd(Messages.RCmd_CmdRd2txt_name, "CMD Rd2txt", 3));
        commands.add(new Cmd(Messages.RCmd_CmdSd2Rd_name, "CMD Sd2Rd", 3));
        commands.add(new Cmd(Messages.RCmd_CmdRoxygen_name, "CMD roxygen", 1));
        commands.add(new Cmd(Messages.RCmd_CmdSweave_name, "CMD Sweave", 3));
        this.customCommand = new Cmd(Messages.RCmd_CmdOther_name, "", 5);
        commands.add(this.customCommand);
        this.commands = commands.toArray(new Cmd[commands.size()]);
        this.resetCommands();
    }

    private void resetCommands() {
        this.customCommand.command = "CMD ";
    }

    public String getName() {
        return Messages.MainTab_name;
    }

    public Image getImage() {
        return SharedUIResources.getImages().get("org.eclipse.statet.ecommons.uimisc/images/obj/main_tab");
    }

    public void createControl(Composite parent) {
        Composite mainComposite = new Composite(parent, 0);
        this.setControl((Control)mainComposite);
        mainComposite.setLayout((Layout)LayoutUtils.newTabGrid((int)1));
        Group group = new Group(mainComposite, 0);
        group.setLayoutData((Object)new GridData(4, 4, true, false));
        group.setText(Messages.MainTab_Cmd_label);
        this.createCommandControls((Composite)group);
        Composite composite = this.createWorkingDirectoryGroup(mainComposite);
        composite.setLayoutData((Object)new GridData(4, 4, true, false));
        Label note = new Label(mainComposite, 64);
        note.setText(String.valueOf(SharedMessages.Note_label) + ": " + this.argumentsControl.getNoteText());
        note.setLayoutData((Object)new GridData(4, 1024, true, true));
        Dialog.applyDialogFont((Control)parent);
        this.initBindings();
    }

    private Composite createWorkingDirectoryGroup(Composite parent) {
        ResourceInputComposite control = new ResourceInputComposite(parent, 2, 10, Messages.MainTab_WorkingDir_label);
        control.setShowInsertVariable(true, (List)VariableFilterUtils.DEFAULT_INTERACTIVE_FILTERS, null);
        this.workingDirectoryControl = control;
        return control;
    }

    private void createCommandControls(Composite container) {
        ILaunchConfigurationTab[] iLaunchConfigurationTabArray = this.getLaunchConfigurationDialog().getTabs();
        int n = iLaunchConfigurationTabArray.length;
        int n2 = 0;
        while (n2 < n) {
            ILaunchConfigurationTab tab = iLaunchConfigurationTabArray[n2];
            if (tab instanceof REnvTab) {
                this.rEnvTab = tab;
                break;
            }
            ++n2;
        }
        this.withHelp = this.rEnvTab != null && this.getLaunchConfigurationDialog() instanceof TrayDialog;
        container.setLayout((Layout)LayoutUtils.newGroupGrid((int)3));
        String[] names = new String[this.commands.length];
        int i = 0;
        while (i < this.commands.length) {
            names[i] = this.commands[i].getName();
            ++i;
        }
        this.cmdCombo = new ComboViewer(container, 12);
        this.cmdCombo.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.cmdCombo.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                Cmd cmd = (Cmd)((Object)element);
                return cmd.getName();
            }
        });
        this.cmdCombo.setInput((Object)this.commands);
        this.cmdCombo.getCombo().setVisibleItemCount(names.length);
        this.cmdCombo.getControl().setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        this.cmdText = new Text(container, 2052);
        this.cmdText.setLayoutData((Object)new GridData(4, 0x1000000, true, false, this.withHelp ? 1 : 2, 1));
        if (this.withHelp) {
            this.helpButton = new Button(container, 8);
            this.helpButton.setText(Messages.MainTab_RunHelp_label);
            this.helpButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    RCmdMainTab.this.queryHelp();
                }
            });
            GridData gd = new GridData(4, 0x1000000, false, false);
            gd.widthHint = LayoutUtils.hintWidth((Button)this.helpButton);
            this.helpButton.setLayoutData((Object)gd);
        }
        LayoutUtils.addSmallFiller((Composite)container, (boolean)false);
        this.argumentsControl = new InputArgumentsComposite(container);
        this.argumentsControl.setLayoutData((Object)new GridData(4, 4, true, false, 3, 1));
        this.resourceControl = new ResourceInputComposite(container, 4, 9, "");
        this.resourceControl.setShowInsertVariable(true, (List)ImCollections.newList((Object)VariableFilterUtils.EXCLUDE_JAVA_FILTER), null);
        this.resourceControl.setLayoutData((Object)new GridData(4, 4, true, false, 3, 1));
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    protected void addBindings(DataBindingContext dbc) {
        IViewerObservableValue cmdSelection = ViewerProperties.singleSelection(Cmd.class).observe((Viewer)this.cmdCombo);
        dbc.bindValue((IObservableValue)cmdSelection, this.cmdValue);
        @Nullable IValidator cmdValidator = value -> {
            if (value == null || value.trim().isEmpty()) {
                return ValidationStatus.warning((String)Messages.MainTab_error_MissingCMD_message);
            }
            return ValidationStatus.ok();
        };
        dbc.bindValue((IObservableValue)WidgetProperties.text((int)24).observe((Widget)this.cmdText), BeanProperties.value(Cmd.class, (String)"command", String.class).observeDetail((IObservableValue)cmdSelection), new UpdateValueStrategy().setAfterGetValidator(cmdValidator), new UpdateValueStrategy().setBeforeSetValidator(cmdValidator));
        dbc.bindValue((IObservableValue)WidgetProperties.text((int)24).observe((Widget)this.argumentsControl.getTextControl()), this.argumentsValue);
        this.resourceControl.getValidator().setOnLateResolve(2);
        this.resourceControl.getValidator().setOnEmpty(0);
        this.resourceControl.getValidator().setIgnoreRelative(true);
        final Binding resourceBinding = dbc.bindValue(this.resourceControl.getObservable(), this.resourceValue, new UpdateValueStrategy().setAfterGetValidator((IValidator)new UpdateableErrorValidator((IValidator)this.resourceControl.getValidator())), null);
        cmdSelection.addValueChangeListener((IValueChangeListener)new IValueChangeListener<Cmd>(){

            public void handleValueChange(ValueChangeEvent<? extends Cmd> event) {
                Cmd cmd = (Cmd)((Object)event.diff.getNewValue());
                if (cmd != null) {
                    String label;
                    RCmdMainTab.this.cmdText.setEditable(cmd.getType() == 5);
                    int mode = 0;
                    switch (cmd.getType()) {
                        case 1: {
                            label = Messages.MainTab_Resource_PackageDir_label;
                            mode = 2;
                            break;
                        }
                        case 2: {
                            label = Messages.MainTab_Resource_PackageDirOrArchive_label;
                            mode = 3;
                            break;
                        }
                        case 3: {
                            label = Messages.MainTab_Resource_Doc_label;
                            mode = 1;
                            break;
                        }
                        case 4: {
                            label = Messages.MainTab_Resource_DocOrDir_label;
                            mode = 3;
                            break;
                        }
                        default: {
                            label = Messages.MainTab_Resource_Other_label;
                            mode = 3;
                        }
                    }
                    RCmdMainTab.this.resourceControl.setResourceLabel(label);
                    RCmdMainTab.this.resourceControl.setMode(mode | 8);
                    resourceBinding.validateTargetToModel();
                }
            }
        });
        this.workingDirectoryControl.getValidator().setOnEmpty(0);
        dbc.bindValue(this.workingDirectoryControl.getObservable(), this.workingDirectoryValue, new UpdateValueStrategy().setAfterGetValidator((IValidator)new UpdateableErrorValidator((IValidator)this.workingDirectoryControl.getValidator())), null);
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute("org.eclipse.statet.r.debug/RCmd/arguments.cmd", this.commands[0].getCommand());
        configuration.setAttribute("org.eclipse.statet.r.debug/RCmd/arguments.options", "");
        configuration.setAttribute("org.eclipse.statet.r.debug/RCmd/arguments.resource", "${resource_loc}");
        REnvTab.setWorkingDirectory((ILaunchConfigurationWorkingCopy)configuration, (String)"");
    }

    protected void doInitialize(ILaunchConfiguration configuration) {
        String value;
        this.resetCommands();
        String command = this.readAttribute(configuration, "org.eclipse.statet.r.debug/RCmd/arguments.cmd", "");
        Cmd cmd = null;
        Cmd[] cmdArray = this.commands;
        int n = this.commands.length;
        int n2 = 0;
        while (n2 < n) {
            Cmd candidate = cmdArray[n2];
            if (candidate.getCommand().equals(command)) {
                cmd = candidate;
                break;
            }
            ++n2;
        }
        if (cmd == null) {
            this.customCommand.setCommand(command);
            cmd = this.customCommand;
        }
        this.cmdValue.setValue(cmd);
        this.argumentsValue.setValue((Object)this.readAttribute(configuration, "org.eclipse.statet.r.debug/RCmd/arguments.options", ""));
        this.resourceValue.setValue((Object)this.readAttribute(configuration, "org.eclipse.statet.r.debug/RCmd/arguments.resource", ""));
        try {
            value = REnvTab.readWorkingDirectory((ILaunchConfiguration)configuration);
        }
        catch (CoreException e) {
            value = "";
            this.logReadingError(e);
        }
        this.workingDirectoryValue.setValue((Object)value);
        this.checkHelp(configuration);
    }

    public void activated(ILaunchConfigurationWorkingCopy workingCopy) {
        this.checkHelp((ILaunchConfiguration)workingCopy);
        super.activated(workingCopy);
    }

    private void checkHelp(ILaunchConfiguration configuration) {
        this.configCache = configuration;
        if (this.withHelp) {
            this.helpButton.setEnabled(this.rEnvTab.isValid(this.configCache));
        }
    }

    protected void doSave(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute("org.eclipse.statet.r.debug/RCmd/arguments.cmd", ((Cmd)((Object)this.cmdValue.getValue())).getCommand());
        configuration.setAttribute("org.eclipse.statet.r.debug/RCmd/arguments.options", (String)this.argumentsValue.getValue());
        configuration.setAttribute("org.eclipse.statet.r.debug/RCmd/arguments.resource", (String)this.resourceValue.getValue());
        REnvTab.setWorkingDirectory((ILaunchConfigurationWorkingCopy)configuration, (String)((String)this.workingDirectoryValue.getValue()));
    }

    private void queryHelp() {
        if (!this.withHelp) {
            return;
        }
        try {
            ArrayList<String> cmdLine = new ArrayList<String>();
            ILaunchConfigurationDialog dialog = this.getLaunchConfigurationDialog();
            IREnvConfiguration renv = RLaunching.getREnvConfig((ILaunchConfiguration)this.configCache, (boolean)true);
            String cmd = ((Cmd)((Object)this.cmdValue.getValue())).getCommand().trim();
            if (cmd.length() != 0) {
                cmdLine.addAll(Arrays.asList(cmd.split(" ")));
            }
            String arg1 = null;
            if (cmdLine.size() > 0) {
                arg1 = (String)cmdLine.remove(0);
            }
            cmdLine.addAll(0, renv.getExecCommand(arg1, EnumSet.of(IREnvConfiguration.Exec.CMD)));
            cmdLine.add("--help");
            ProcessBuilder processBuilder = new ProcessBuilder(cmdLine);
            HelpRequestor helper = new HelpRequestor(processBuilder, (TrayDialog)dialog);
            Map<String, String> envp = processBuilder.environment();
            LaunchUtils.configureEnvironment(envp, (ILaunchConfiguration)this.configCache, (Map[])new Map[]{renv.getEnvironmentsVariables()});
            dialog.run(true, true, (IRunnableWithProgress)helper);
            this.updateLaunchConfigurationDialog();
        }
        catch (CoreException e) {
            StatusManager.getManager().handle((IStatus)new Status(4, "org.eclipse.statet.r.console.ui", -1, Messages.MainTab_error_CannotRunHelp_message, (Throwable)e), 3);
        }
        catch (InvocationTargetException e) {
            StatusManager.getManager().handle((IStatus)new Status(4, "org.eclipse.statet.r.console.ui", -1, Messages.MainTab_error_WhileRunningHelp_message, e.getTargetException()), 3);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void dispose() {
        if (this.withHelp) {
            HelpRequestor.closeHelpTray((TrayDialog)((TrayDialog)this.getLaunchConfigurationDialog()));
        }
        super.dispose();
    }

    private static class Cmd
    extends AbstractSettingsModelObject {
        public static final int PACKAGE_DIR = 1;
        public static final int PACKAGE_DIR_OR_ARCHIVE = 2;
        public static final int DOC = 3;
        public static final int DOC_OR_DIR = 4;
        public static final int CUSTOM = 5;
        private final String name;
        private String command;
        private final int type;

        public Cmd(String name, String command, int type) {
            this.name = name;
            this.command = command;
            this.type = type;
        }

        public String getName() {
            return this.name;
        }

        public int getType() {
            return this.type;
        }

        public void setCommand(String command) {
            this.command = command.trim();
        }

        public String getCommand() {
            return this.command;
        }
    }
}

