/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.r.ui.tools;

import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.osgi.util.NLS;
import org.eclipse.statet.internal.r.ui.tools.Messages;
import org.eclipse.statet.jcommons.status.ProgressMonitor;
import org.eclipse.statet.jcommons.status.StatusException;
import org.eclipse.statet.jcommons.ts.core.Tool;
import org.eclipse.statet.jcommons.ts.core.ToolRunnable;
import org.eclipse.statet.jcommons.ts.core.ToolService;
import org.eclipse.statet.r.console.core.IRBasicAdapter;
import org.eclipse.statet.r.core.RUtil;

public class LoadRImageRunnable
implements ToolRunnable {
    public static final String TYPE_ID = "r/tools/loadData";
    static final String REQUIRED_FEATURESET_ID = "org.eclipse.statet.r.basic";
    private final IFileStore dataFile;

    public LoadRImageRunnable(IFileStore workingdir) {
        this.dataFile = workingdir;
    }

    public String getTypeId() {
        return TYPE_ID;
    }

    public boolean canRunIn(Tool tool) {
        return tool.isProvidingFeatureSet(REQUIRED_FEATURESET_ID);
    }

    public String getLabel() {
        return NLS.bind((String)Messages.LoadData_Runnable_label, (Object)this.dataFile.getName());
    }

    public boolean changed(int event, Tool process) {
        return true;
    }

    public void run(ToolService service, ProgressMonitor m) throws StatusException {
        IRBasicAdapter r = (IRBasicAdapter)service;
        String toolPath = r.getWorkspaceData().toToolPath(this.dataFile);
        try {
            String command = "load(\"" + RUtil.escapeCompletely((String)toolPath) + "\")";
            r.submitToConsole(command, m);
        }
        finally {
            r.refreshWorkspaceData(1, m);
        }
    }
}

