/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.r.ui.search;

import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.statet.ecommons.ui.SharedUIResources;
import org.eclipse.statet.ecommons.workbench.search.ui.LineElement;
import org.eclipse.statet.ecommons.workbench.search.ui.TextSearchLabelUtil;
import org.eclipse.statet.internal.r.ui.search.Messages;
import org.eclipse.statet.internal.r.ui.search.RElementMatch;
import org.eclipse.statet.internal.r.ui.search.RElementSearchResultPage;
import org.eclipse.statet.ltk.model.core.element.LtkModelElement;
import org.eclipse.statet.ltk.model.core.element.SourceUnit;
import org.eclipse.statet.r.core.model.RSourceUnit;
import org.eclipse.statet.r.ui.RLabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class RElementSearchLabelProvider
extends RLabelProvider
implements DelegatingStyledCellLabelProvider.IStyledLabelProvider {
    private final RElementSearchResultPage page;
    private final TextSearchLabelUtil util;
    private final WorkbenchLabelProvider workbenchLabelProvider;

    public RElementSearchLabelProvider(RElementSearchResultPage page, int style) {
        super(style);
        this.page = page;
        this.util = new TextSearchLabelUtil();
        this.workbenchLabelProvider = new WorkbenchLabelProvider();
    }

    public void dispose() {
        super.dispose();
        this.workbenchLabelProvider.dispose();
    }

    public void addListener(ILabelProviderListener listener) {
        super.addListener(listener);
        this.workbenchLabelProvider.addListener(listener);
    }

    public void removeListener(ILabelProviderListener listener) {
        super.removeListener(listener);
        this.workbenchLabelProvider.removeListener(listener);
    }

    public boolean isLabelProperty(Object element, String property) {
        if (element instanceof LtkModelElement) {
            return super.isLabelProperty(element, property);
        }
        if (element instanceof RElementMatch || element instanceof LineElement) {
            return true;
        }
        return this.workbenchLabelProvider.isLabelProperty(element, property);
    }

    @Override
    public Image getImage(Object element) {
        if (element instanceof LtkModelElement) {
            if (element instanceof SourceUnit) {
                return this.workbenchLabelProvider.getImage(((SourceUnit)element).getResource());
            }
            return super.getImage((LtkModelElement)element);
        }
        if (element instanceof RElementMatch || element instanceof LineElement) {
            return SharedUIResources.getImages().get("org.eclipse.statet.ecommons.uimisc/images/obj/line_match");
        }
        return this.workbenchLabelProvider.getImage(element);
    }

    /*
     * WARNING - void declaration
     */
    public StyledString getStyledText(Object element) {
        if (element instanceof LtkModelElement) {
            StyledString text = super.getStyledText((LtkModelElement)element);
            if (element instanceof RSourceUnit) {
                int count = this.page.getDisplayedMatchCount(element);
                StringBuilder sb = this.getTextBuilder();
                sb.append(" (");
                sb.append(count);
                sb.append(' ');
                sb.append(count == 1 ? Messages.Search_Match_sing_label : Messages.Search_Match_plural_label);
                sb.append(')');
                text.append(sb.toString(), StyledString.COUNTER_STYLER);
            }
            return text;
        }
        Object object = element;
        if (object instanceof LineElement) {
            void lineElement;
            LineElement text = (LineElement)object;
            LineElement cfr_ignored_0 = (LineElement)object;
            return this.util.getStyledText((LineElement)lineElement, this.page.getDisplayedMatches((LineElement<?>)lineElement));
        }
        return this.workbenchLabelProvider.getStyledText(element);
    }
}

