/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.r.ui.pkgmanager;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.databinding.validation.ValidationStatus;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.statet.ecommons.ui.util.LayoutUtils;
import org.eclipse.statet.r.ui.REnvLabelProvider;
import org.eclipse.statet.rj.renv.core.RLibGroup;
import org.eclipse.statet.rj.renv.core.RLibLocation;
import org.eclipse.statet.rj.renv.runtime.RLibLocationInfo;
import org.eclipse.statet.rj.renv.runtime.RuntimeRLibPaths;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Tree;

public class RLibrarySelectionComposite
extends Composite {
    private TreeViewer treeViewer;
    private final Validator validator = new Validator();

    public RLibrarySelectionComposite(Composite parent) {
        super(parent, 0);
        this.setLayout((Layout)new FillLayout());
        this.createComponents(this);
    }

    private void createComponents(Composite parent) {
        TreeViewer viewer;
        Tree tree = new Tree(parent, 67588);
        this.treeViewer = viewer = new TreeViewer(tree);
        viewer.setLabelProvider((IBaseLabelProvider)new REnvLabelProvider());
        viewer.setContentProvider((IContentProvider)new ITreeContentProvider(){

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public void dispose() {
            }

            public Object[] getElements(Object inputElement) {
                return ((List)inputElement).toArray();
            }

            public Object getParent(Object element) {
                return null;
            }

            public boolean hasChildren(Object element) {
                if (element instanceof RLibGroup) {
                    for (RLibLocation location : ((RLibGroup)element).getLibLocations()) {
                        if (!RLibrarySelectionComposite.this.validator.matchesRequired(location)) continue;
                        return true;
                    }
                }
                return false;
            }

            public Object[] getChildren(Object parentElement) {
                if (parentElement instanceof RLibGroup) {
                    List all = ((RLibGroup)parentElement).getLibLocations();
                    ArrayList<RLibLocation> list = new ArrayList<RLibLocation>(all.size());
                    for (RLibLocation location : all) {
                        if (!RLibrarySelectionComposite.this.validator.matchesRequired(location)) continue;
                        list.add(location);
                    }
                    return list.toArray();
                }
                return null;
            }
        });
        viewer.setAutoExpandLevel(-1);
    }

    public GridData createGD() {
        GridData gd = new GridData(4, 4, true, true);
        gd.heightHint = LayoutUtils.hintHeight((Tree)this.treeViewer.getTree(), (int)8);
        return gd;
    }

    public Validator getValidator() {
        return this.validator;
    }

    public void setInput(RuntimeRLibPaths libPaths) {
        this.validator.libPaths = libPaths;
        this.treeViewer.setInput((Object)libPaths.getRLibGroups());
    }

    public TreeViewer getSelectionViewer() {
        return this.treeViewer;
    }

    public static class Validator
    implements IValidator<Object> {
        private RuntimeRLibPaths libPaths;
        private boolean isWritableRequired;

        public void setWritable(boolean required) {
            this.isWritableRequired = required;
        }

        public IStatus validate(Object value) {
            if (!(value instanceof RLibLocation)) {
                return ValidationStatus.error((String)"No library location selected where to install the package to.");
            }
            return ValidationStatus.ok();
        }

        private boolean matchesRequired(RLibLocation libLocation) {
            if (!this.isWritableRequired) {
                return true;
            }
            RLibLocationInfo info = this.libPaths.getInfo(libLocation);
            return info != null && info.isWritable();
        }
    }
}

