/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.r.ui.intable.css.properties;

import org.eclipse.e4.ui.css.core.engine.CSSEngine;
import org.eclipse.statet.ecommons.waltable.core.config.ConfigAttribute;
import org.eclipse.statet.ecommons.waltable.core.config.DisplayMode;
import org.eclipse.statet.ecommons.waltable.core.style.GridStyling;
import org.eclipse.statet.internal.r.ui.intable.DataTable;
import org.eclipse.statet.internal.r.ui.intable.css.dom.TableElement;
import org.eclipse.statet.internal.r.ui.intable.css.dom.TableRegionElement;
import org.eclipse.statet.internal.r.ui.intable.css.properties.AbstractDataTablePropertyHandler;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.swt.graphics.Color;
import org.w3c.dom.css.CSSValue;

@NonNullByDefault
public class TableRegionPropertyHandler
extends AbstractDataTablePropertyHandler {
    public @Nullable String retrieveCSSProperty(Object element, String property, @Nullable String pseudo, CSSEngine engine) throws Exception {
        block8: {
            if (!(element instanceof TableRegionElement)) {
                return null;
            }
            TableRegionElement regionElement = (TableRegionElement)((Object)element);
            DisplayMode displayMode = TableRegionPropertyHandler.getDisplayMode(regionElement, pseudo);
            if (displayMode == null) break block8;
            switch (property) {
                case "grid-line-color": {
                    return TableRegionPropertyHandler.receiveStyleAttribute(regionElement, displayMode, null, GridStyling.GRID_LINE_COLOR, Color.class, engine);
                }
            }
        }
        return null;
    }

    public boolean applyCSSProperty(Object element, String property, CSSValue value, @Nullable String pseudo, CSSEngine engine) throws Exception {
        block8: {
            if (!(element instanceof TableRegionElement)) {
                return false;
            }
            TableRegionElement regionElement = (TableRegionElement)((Object)element);
            DisplayMode displayMode = TableRegionPropertyHandler.getDisplayMode(regionElement, pseudo);
            if (displayMode == null) break block8;
            switch (property) {
                case "grid-line-color": {
                    TableRegionPropertyHandler.applyStyleAttribute(regionElement, displayMode, null, GridStyling.GRID_LINE_COLOR, Color.class, value, engine);
                    return true;
                }
            }
        }
        return true;
    }

    private static @Nullable DisplayMode getDisplayMode(TableRegionElement cellElement, @Nullable String pseudo) {
        if (pseudo == null) {
            return DisplayMode.NORMAL;
        }
        return null;
    }

    private static <T> @Nullable String receiveStyleAttribute(TableRegionElement regionElement, DisplayMode displayMode, @Nullable String label, ConfigAttribute<T> attribute, Class<T> valueType, CSSEngine engine) throws Exception {
        DataTable dataTable = (DataTable)((TableElement)regionElement.getParentNode()).getNativeWidget();
        if (label == null) {
            label = regionElement.getCSSClass();
        }
        Object value = dataTable.getConfigRegistry().getSpecificAttribute(attribute, displayMode, label);
        return engine.convert(value, valueType, null);
    }

    private static <T> void applyStyleAttribute(TableRegionElement regionElement, DisplayMode displayMode, @Nullable String label, ConfigAttribute<T> attribute, Class<T> valueType, CSSValue cssValue, CSSEngine engine) throws Exception {
        Object value;
        Object oldValue;
        DataTable dataTable = (DataTable)((TableElement)regionElement.getParentNode()).getNativeWidget();
        if (label == null) {
            label = regionElement.getCSSClass();
        }
        if ((oldValue = dataTable.getConfigRegistry().getSpecificAttribute(attribute, displayMode, label)) != null && (value = engine.convert(cssValue, valueType, (Object)dataTable.getDisplay())) != null && !value.equals(oldValue)) {
            dataTable.getConfigRegistry().registerAttribute(attribute, value);
        }
    }
}

