/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.r.console.core;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.statet.internal.r.console.core.RConsoleCorePlugin;
import org.eclipse.statet.internal.r.rdata.REnvironmentVar;
import org.eclipse.statet.internal.r.rdata.RReferenceVar;
import org.eclipse.statet.internal.r.rdata.VirtualMissingVar;
import org.eclipse.statet.jcommons.collections.ImCollections;
import org.eclipse.statet.jcommons.collections.IntArrayList;
import org.eclipse.statet.jcommons.collections.IntList;
import org.eclipse.statet.jcommons.status.ErrorStatus;
import org.eclipse.statet.jcommons.status.ProgressMonitor;
import org.eclipse.statet.jcommons.status.Status;
import org.eclipse.statet.jcommons.status.StatusException;
import org.eclipse.statet.r.console.core.AbstractRController;
import org.eclipse.statet.r.console.core.RProcessREnvironment;
import org.eclipse.statet.r.console.core.RWorkspace;
import org.eclipse.statet.r.core.data.CombinedRElement;
import org.eclipse.statet.r.core.data.CombinedRList;
import org.eclipse.statet.r.core.model.RElementName;
import org.eclipse.statet.r.nico.ICombinedRDataAdapter;
import org.eclipse.statet.rj.data.RCharacterStore;
import org.eclipse.statet.rj.data.RDataUtils;
import org.eclipse.statet.rj.data.RObject;
import org.eclipse.statet.rj.data.RReference;
import org.eclipse.statet.rj.data.RVector;
import org.eclipse.statet.rj.data.UnexpectedRDataException;

public class RObjectDB {
    private static final Set<Long> NO_ENVS_SET = Collections.emptySet();
    private static final byte UPTODATE = 2;
    private static final byte RECURSIVE = 8;
    private static final byte RECURSIVE_UPTODATE = 16;
    private final RWorkspace workspace;
    private final ConcurrentHashMap<Long, EnvironmentEntry> envsMap = new ConcurrentHashMap();
    private int searchEnvsStamp;
    private List<REnvironmentVar> searchEnvs;
    private List<? extends RProcessREnvironment> searchEnvsPublic;
    private int lazyEnvsStamp;
    private Set<Long> lazyEnvs;
    private final ConcurrentHashMap<String, NamespaceEntry> namespaceMap = new ConcurrentHashMap();
    private List<String> forceUpdatePkgNames;
    private RObjectDB previousDB;
    private byte resolveMode;
    private ICombinedRDataAdapter r;

    private static boolean isNamespaceEnv(RElementName elementName) {
        return elementName != null && elementName.getType() == 34 && elementName.getNextSegment() == null;
    }

    private static CombinedRElement first(CombinedRElement first, CombinedRElement second) {
        return first != null ? first : second;
    }

    public static byte toResolveMode(int resolve) {
        if ((resolve &= 0xA) == 10) {
            resolve |= 0x10;
        }
        return (byte)resolve;
    }

    public RObjectDB(RWorkspace workspace, int stamp, AbstractRController r, ProgressMonitor m) {
        this.workspace = r.getWorkspaceData();
        this.searchEnvsStamp = stamp;
        this.searchEnvsPublic = Collections.emptyList();
        this.lazyEnvs = NO_ENVS_SET;
        this.updateLazyEnvs(r, m);
    }

    public List<? extends RProcessREnvironment> getSearchEnvs() {
        return this.searchEnvsPublic;
    }

    public int getSearchEnvsStamp() {
        return this.searchEnvsStamp;
    }

    public int getSearchEnvsElementCount() {
        int count = 0;
        for (REnvironmentVar env : this.searchEnvs) {
            long l;
            if (env == null || (l = env.getLength()) <= 0L) continue;
            count = (int)((long)count + l);
        }
        return count;
    }

    public REnvironmentVar getEnv(Long handle) {
        EnvironmentEntry entry = this.envsMap.get(handle);
        return entry != null ? entry.env : null;
    }

    public CombinedRElement getNamespaceEnv(String name) {
        NamespaceEntry entry;
        if (name != null && (entry = this.namespaceMap.get(name)) != null) {
            return RObjectDB.first(entry.na, entry.namespaceEnv);
        }
        return null;
    }

    public CombinedRElement getNamespacePub(String name) {
        NamespaceEntry entry;
        if (name != null && (entry = this.namespaceMap.get(name)) != null) {
            return RObjectDB.first(entry.na, entry.namespaceExports);
        }
        return null;
    }

    public boolean isNamespaceLoaded(String name) {
        if (name != null) {
            NamespaceEntry entry = this.namespaceMap.get(name);
            return entry != null && entry.na == null;
        }
        return false;
    }

    public CombinedRElement getPackageEnv(String name) {
        NamespaceEntry entry;
        if (name != null && (entry = this.namespaceMap.get(name)) != null) {
            return RObjectDB.first(entry.na, entry.packageEnv);
        }
        return null;
    }

    public REnvironmentVar getSearchEnv(String name) {
        if (name != null) {
            for (REnvironmentVar env : this.searchEnvs) {
                RElementName elementName = env.getElementName();
                if (elementName == null || elementName.getType() != 37 || !name.equals(elementName.getSegmentName())) continue;
                return env;
            }
        }
        return null;
    }

    public CombinedRElement getByName(RElementName name) {
        switch (name.getType()) {
            case 33: {
                return this.getNamespacePub(name.getSegmentName());
            }
            case 34: {
                return this.getNamespaceEnv(name.getSegmentName());
            }
            case 37: {
                return this.getSearchEnv(name.getSegmentName());
            }
            case 38: {
                return this.getPackageEnv(name.getSegmentName());
            }
        }
        return null;
    }

    public int getLazyEnvsStamp() {
        return this.lazyEnvsStamp;
    }

    public void updateLazyEnvs(AbstractRController r, ProgressMonitor m) {
        if (this.envsMap != null && !this.envsMap.isEmpty() && !this.lazyEnvs.isEmpty()) {
            ((ConcurrentHashMap.KeySetView)this.envsMap.keySet()).removeAll(this.lazyEnvs);
        }
        this.lazyEnvsStamp = r.getChangeStamp();
        Set<Long> list = r.getLazyEnvironments(m);
        this.lazyEnvs = list != null && !list.isEmpty() ? list : NO_ENVS_SET;
    }

    public List<REnvironmentVar> update(Set<RElementName> envs, RObjectDB previous, boolean force, ICombinedRDataAdapter r, ProgressMonitor m) throws StatusException {
        this.r = r;
        try {
            this.updateSearchList(m);
            this.updateNamespaceList(m);
            if (m.isCanceled()) {
                return null;
            }
            List<String> forcePkgNames = null;
            if (previous != null) {
                if (force) {
                    previous = null;
                } else {
                    forcePkgNames = previous.forceUpdatePkgNames;
                }
            }
            IntList updateList = this.createUpdateIdxs(envs, previous, forcePkgNames);
            List<REnvironmentVar> updateEnvs = this.createUpdateEnvs(updateList, m);
            this.updateEnvMap(updateEnvs, previous, forcePkgNames, m);
            if (previous != null) {
                for (Map.Entry<String, NamespaceEntry> entry : previous.namespaceMap.entrySet()) {
                    String name = entry.getKey();
                    if (forcePkgNames != null && forcePkgNames.contains(name)) continue;
                    NamespaceEntry oldEntry = entry.getValue();
                    NamespaceEntry newEntry = this.namespaceMap.get(name);
                    if (oldEntry == null || oldEntry.na != null || newEntry == null) continue;
                    if (newEntry.namespaceEnv == null) {
                        newEntry.namespaceEnv = oldEntry.namespaceEnv;
                    }
                    if (newEntry.namespaceExports != null) continue;
                    newEntry.namespaceExports = oldEntry.namespaceExports;
                }
            }
            List<REnvironmentVar> list = updateEnvs;
            return list;
        }
        catch (UnexpectedRDataException e) {
            throw new StatusException((Status)new ErrorStatus("org.eclipse.statet.r.console.core", "Unexpected return value from R.", (Throwable)e));
        }
        finally {
            this.r = null;
        }
    }

    private void updateSearchList(ProgressMonitor m) throws StatusException, UnexpectedRDataException {
        this.searchEnvsStamp = this.r.getChangeStamp();
        this.searchEnvs = new ArrayList<REnvironmentVar>();
        this.searchEnvsPublic = Collections.unmodifiableList(this.searchEnvs);
        RVector searchObj = RDataUtils.checkRCharVector((RObject)this.r.evalData("base::search()", m));
        RCharacterStore namesData = (RCharacterStore)searchObj.getData();
        int i = 0;
        while ((long)i < namesData.getLength()) {
            if (!namesData.isNA(i)) {
                String name = namesData.getChar(i);
                this.searchEnvs.add(new REnvironmentVar(name, true, null, null));
            }
            ++i;
        }
    }

    private void updateNamespaceList(ProgressMonitor m) throws StatusException, UnexpectedRDataException {
        RVector searchObj = RDataUtils.checkRCharVector((RObject)this.r.evalData("base::loadedNamespaces()", m));
        RCharacterStore namesData = (RCharacterStore)searchObj.getData();
        int i = 0;
        while ((long)i < namesData.getLength()) {
            if (!namesData.isNA(i)) {
                String name = namesData.getChar(i);
                this.getNamespaceEntry(name);
            }
            ++i;
        }
    }

    public IntList createUpdateIdxs(Set<RElementName> envs, RObjectDB previous, List<String> forcePkgNames) {
        IntArrayList updateIdxs = new IntArrayList(this.searchEnvs.size());
        if (previous == null) {
            int newIdx = 0;
            while (newIdx < this.searchEnvs.size()) {
                updateIdxs.add(newIdx);
                ++newIdx;
            }
        } else {
            int newIdx = this.searchEnvs.size() - 1;
            int oldIdx = previous.searchEnvs.size();
            while (newIdx >= 0) {
                int j;
                String pkgName;
                REnvironmentVar current = this.searchEnvs.get(newIdx);
                if (current.getSpecialType() <= 0 || current.getSpecialType() > 5 || forcePkgNames != null && (pkgName = this.getPkgName(current)) != null && forcePkgNames.contains(pkgName) || (j = previous.searchEnvs.indexOf(current)) < 0 || j >= oldIdx) break;
                oldIdx = j;
                if (envs != null && envs.contains(current.getElementName())) {
                    updateIdxs.add(newIdx);
                } else {
                    this.searchEnvs.set(newIdx, previous.searchEnvs.get(oldIdx));
                }
                --newIdx;
            }
            while (newIdx >= 0) {
                updateIdxs.add(newIdx);
                --newIdx;
            }
        }
        return updateIdxs;
    }

    private List<REnvironmentVar> createUpdateEnvs(IntList updateIdxs, ProgressMonitor m) throws StatusException {
        ArrayList<REnvironmentVar> updateEnvs = new ArrayList<REnvironmentVar>(updateIdxs.size());
        int idx = 0;
        while (idx < updateIdxs.size()) {
            block5: {
                REnvironmentVar env;
                block4: {
                    if (m.isCanceled()) {
                        throw new StatusException(Status.CANCEL_STATUS);
                    }
                    env = this.searchEnvs.get(idx);
                    RElementName elementName = env.getElementName();
                    try {
                        int loadOptions = 32;
                        CombinedRElement robject = this.r.evalCombinedStruct(elementName, 32, -1, m);
                        if (robject == null || robject.getRObjectType() != 8) break block4;
                        REnvironmentVar newEnv = (REnvironmentVar)robject;
                        this.searchEnvs.set(idx, newEnv);
                        updateEnvs.add(newEnv);
                        break block5;
                    }
                    catch (StatusException e) {
                        RConsoleCorePlugin.logError("Error update environment " + elementName, e);
                        if (!this.r.getTool().isTerminated() && !m.isCanceled()) break block4;
                        throw e;
                    }
                }
                env.setError("update error");
                updateEnvs.add(env);
            }
            ++idx;
        }
        return updateEnvs;
    }

    private NamespaceEntry getNamespaceEntry(String name) {
        NamespaceEntry entry = this.namespaceMap.get(name);
        if (entry == null) {
            entry = new NamespaceEntry();
            this.namespaceMap.put(name, entry);
        }
        return entry;
    }

    private String getPkgName(REnvironmentVar env) {
        switch (env.getSpecialType()) {
            case 1: {
                return "base";
            }
            case 5: {
                return env.getEnvironmentName().substring(8);
            }
            case 11: {
                return env.getEnvironmentName();
            }
            case 12: {
                return env.getEnvironmentName();
            }
        }
        return null;
    }

    private EnvironmentEntry registerEnv(Long handle, REnvironmentVar env, boolean isUptodate) {
        EnvironmentEntry environmentEntry;
        if (handle != null) {
            environmentEntry = new EnvironmentEntry(env);
            this.envsMap.put(handle, environmentEntry);
        } else {
            environmentEntry = null;
        }
        String name = this.getPkgName(env);
        if (name != null) {
            NamespaceEntry entry = this.getNamespaceEntry(name);
            switch (env.getSpecialType()) {
                case 1: 
                case 5: {
                    if (!isUptodate && (entry.na != null || entry.packageEnv != null)) break;
                    entry.packageEnv = env;
                    break;
                }
                case 11: {
                    if (!isUptodate && (entry.na != null || entry.namespaceEnv != null)) break;
                    entry.namespaceEnv = env;
                    break;
                }
                case 12: {
                    if (!isUptodate && (entry.na != null || entry.namespaceExports != null)) break;
                    entry.namespaceExports = env;
                    break;
                }
                default: {
                    return environmentEntry;
                }
            }
            if (isUptodate) {
                entry.na = null;
            }
        }
        return environmentEntry;
    }

    private void registerNA(VirtualMissingVar na) {
        NamespaceEntry entry = this.getNamespaceEntry(na.getElementName().getSegmentName());
        entry.na = na;
        entry.namespaceEnv = null;
        entry.namespaceExports = null;
    }

    private void updateEnvMap(List<REnvironmentVar> updateEnvs, RObjectDB previous, List<String> forcePkgNames, ProgressMonitor m) throws StatusException {
        if (m.isCanceled()) {
            return;
        }
        this.previousDB = null;
        this.resolveMode = (byte)8;
        for (REnvironmentVar env : this.searchEnvs) {
            this.registerEnv(env.getHandle(), env, true);
        }
        for (REnvironmentVar env : updateEnvs) {
            Long handle = env.getHandle();
            EnvironmentEntry entry = this.envsMap.get(handle);
            if (entry == null) {
                entry = this.registerEnv(handle, env, true);
            }
            this.check(entry, m);
        }
        this.previousDB = previous;
        this.forceUpdatePkgNames = forcePkgNames;
        for (REnvironmentVar env : this.searchEnvs) {
            if (updateEnvs.contains(env)) continue;
            this.check(env, m);
        }
        this.previousDB = null;
        this.forceUpdatePkgNames = null;
    }

    public CombinedRElement resolve(RReferenceVar ref, int resolve, int loadOptions, ICombinedRDataAdapter r, ProgressMonitor m) throws StatusException {
        this.r = r;
        this.resolveMode = RObjectDB.toResolveMode(resolve);
        try {
            CombinedRElement resolved = this.evalResolve(ref, ref.getElementName(), loadOptions, m);
            if (resolved != null) {
                this.checkDirectAccessName(resolved, ref.getElementName());
            }
            CombinedRElement combinedRElement = resolved;
            return combinedRElement;
        }
        finally {
            this.r = null;
        }
    }

    private CombinedRElement evalResolve(RReferenceVar ref, RElementName fullName, int loadOptions, ProgressMonitor m) throws StatusException {
        Long handle = ref.getHandle() != 0L ? Long.valueOf(ref.getHandle()) : null;
        byte mode = this.resolveMode;
        try {
            this.resolveMode = (mode & 0x10) != 0 ? mode : (byte)(mode & 0xFFFFFFFD);
            boolean lazy = false;
            if (ref.getReferencedRObjectType() == 8 && handle != null) {
                ref.setResolver(this.workspace);
                EnvironmentEntry entry = this.envsMap.get(handle);
                if (entry != null) {
                    if ((mode & 2) == 0 || entry.env.getStamp() == this.r.getChangeStamp()) {
                        this.check(entry, m);
                        REnvironmentVar rEnvironmentVar = entry.env;
                        return rEnvironmentVar;
                    }
                    this.resolveMode = (byte)(this.resolveMode | 8);
                }
                if (!(lazy = this.lazyEnvs.contains(handle)) && this.previousDB != null) {
                    EnvironmentEntry entry2;
                    String pkgName;
                    EnvironmentEntry prevEntry = this.previousDB.envsMap.get(handle);
                    List<String> forcePkgNames = this.forceUpdatePkgNames;
                    if (!(prevEntry == null || (mode & 2) != 0 && prevEntry.env.getStamp() != this.r.getChangeStamp() || forcePkgNames != null && (pkgName = this.getPkgName(prevEntry.env)) != null && forcePkgNames.contains(pkgName) || (entry2 = this.registerEnv(handle, prevEntry.env, false)) == null)) {
                        this.check(entry2, m);
                        REnvironmentVar rEnvironmentVar = entry2.env;
                        return rEnvironmentVar;
                    }
                }
            }
            CombinedRElement element = null;
            if (ref.getReferencedRObjectType() == 8 && handle != null) {
                if (!lazy && !RObjectDB.isNamespaceEnv(ref.getElementName())) {
                    loadOptions |= 0x20;
                }
                element = this.r.evalCombinedStruct((RReference)ref, loadOptions, -1, null, m);
            } else if (fullName != null) {
                RElementName symbolName;
                if (!lazy && !RObjectDB.isNamespaceEnv(fullName)) {
                    loadOptions |= 0x20;
                }
                if ((symbolName = fullName.getLastSegment()).getType() == 17) {
                    RElementName envName = RElementName.create((RElementName)fullName, (RElementName)symbolName, (boolean)true);
                    try {
                        element = this.r.findCombinedStruct(symbolName, envName, false, loadOptions, -1, m);
                    }
                    catch (StatusException statusException) {
                        // empty catch block
                    }
                }
                if (element == null) {
                    element = this.r.evalCombinedStruct(fullName, loadOptions, -1, m);
                }
            } else {
                throw new StatusException((Status)new ErrorStatus("org.eclipse.statet.r.console.core", "Unsupported ref: " + ref));
            }
            if (element != null && element.getRObjectType() == 8) {
                EnvironmentEntry entry;
                REnvironmentVar env = (REnvironmentVar)element;
                if (handle == null && env.getHandle() != 0L) {
                    handle = env.getHandle();
                }
                if ((entry = this.registerEnv(handle, env, true)) != null) {
                    this.check(entry, m);
                    REnvironmentVar rEnvironmentVar = env;
                    return rEnvironmentVar;
                }
            }
            if (element instanceof CombinedRList) {
                this.check((CombinedRList)element, m);
            }
            CombinedRElement combinedRElement = element;
            return combinedRElement;
        }
        catch (StatusException e) {
            if (fullName != null && fullName.getNextSegment() == null && RElementName.isPackageFacetScopeType((int)fullName.getType())) {
                VirtualMissingVar na = new VirtualMissingVar(fullName, this.r.getTool(), this.r.getChangeStamp());
                this.registerNA(na);
            }
            RConsoleCorePlugin.logError("Error update ref: " + ref.getElementName(), e);
            if (this.r.getTool().isTerminated() || m.isCanceled()) {
                throw e;
            }
            return null;
        }
        finally {
            this.resolveMode = mode;
        }
    }

    private void checkDirectAccessName(CombinedRElement var, RElementName name) {
        if (name == null || name.getNextSegment() != null) {
            return;
        }
        if (var instanceof REnvironmentVar && RElementName.isScopeType((int)name.getType())) {
            ((REnvironmentVar)var).setElementName(name);
        }
    }

    private void check(EnvironmentEntry entry, ProgressMonitor m) throws StatusException {
        byte mode = (byte)(2 | this.resolveMode);
        if ((mode & ~(entry.checked | entry.checking)) != 0) {
            byte was = entry.checking;
            entry.checking = (byte)(entry.checking | mode);
            try {
                this.check(entry.env, m);
                entry.checked = (byte)(entry.checked | mode);
            }
            finally {
                entry.checking = was;
            }
        }
    }

    private void check(CombinedRList list, ProgressMonitor m) throws StatusException {
        block16: {
            if (!list.hasModelChildren(null)) break block16;
            long length = list.getLength();
            if (length <= Integer.MAX_VALUE) {
                int l = (int)length;
                int i = 0;
                while (i < l) {
                    CombinedRElement object = list.get(i);
                    if (object != null) {
                        switch (object.getRObjectType()) {
                            case 14: {
                                if ((this.resolveMode & 8) != 0 && ((RReference)object).getReferencedRObjectType() == 8) {
                                    this.evalResolve((RReferenceVar)object, null, 0, m);
                                    break;
                                }
                                ((RReferenceVar)object).setResolver(this.workspace);
                                break;
                            }
                            case 7: 
                            case 10: {
                                this.check((CombinedRList)object, m);
                                break;
                            }
                        }
                    }
                    ++i;
                }
            } else {
                long i = 0L;
                while (i < length) {
                    CombinedRElement object = list.get(i);
                    if (object != null) {
                        switch (object.getRObjectType()) {
                            case 14: {
                                if ((this.resolveMode & 8) != 0 && ((RReference)object).getReferencedRObjectType() == 8) {
                                    this.evalResolve((RReferenceVar)object, null, 0, m);
                                    break;
                                }
                                ((RReferenceVar)object).setResolver(this.workspace);
                                break;
                            }
                            case 7: 
                            case 10: {
                                this.check((CombinedRList)object, m);
                                break;
                            }
                        }
                    }
                    ++i;
                }
            }
        }
    }

    public void handleRPkgChange(List<String> names) {
        this.forceUpdatePkgNames = this.forceUpdatePkgNames != null ? ImCollections.concatList(this.forceUpdatePkgNames, names) : names;
    }

    private static class EnvironmentEntry {
        private final REnvironmentVar env;
        private byte checking;
        private byte checked;

        public EnvironmentEntry(REnvironmentVar env) {
            this.env = env;
        }
    }

    private static class NamespaceEntry {
        private volatile VirtualMissingVar na;
        private REnvironmentVar namespaceEnv;
        private REnvironmentVar namespaceExports;
        private REnvironmentVar packageEnv;

        private NamespaceEntry() {
        }
    }
}

