/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.debug.core.util;

import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchDelegate;
import org.eclipse.debug.internal.core.LaunchConfiguration;
import org.eclipse.statet.jcommons.lang.NonNull;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;

@NonNullByDefault
public class OverlayLaunchConfiguration
extends LaunchConfiguration {
    private final ILaunchConfiguration launchConfiguration;
    private final Map<String, Object> additionalAttributes;

    public OverlayLaunchConfiguration(ILaunchConfiguration orginal, Map<String, Object> additional) {
        super(orginal.getName(), null);
        this.launchConfiguration = orginal;
        this.additionalAttributes = additional;
    }

    public ILaunchConfiguration getOriginal() {
        return this.launchConfiguration;
    }

    public boolean contentsEqual(@Nullable ILaunchConfiguration configuration) {
        return configuration != null && this.launchConfiguration.contentsEqual(configuration);
    }

    public ILaunchConfigurationWorkingCopy copy(String name) throws CoreException {
        return this.launchConfiguration.copy(name);
    }

    public void delete() throws CoreException {
        this.launchConfiguration.delete();
    }

    public boolean exists() {
        return this.launchConfiguration.exists();
    }

    public boolean hasAttribute(String attributeName) throws CoreException {
        if (this.additionalAttributes.containsKey(attributeName)) {
            return true;
        }
        return this.launchConfiguration.hasAttribute(attributeName);
    }

    public boolean getAttribute(String attributeName, boolean defaultValue) throws CoreException {
        Object value = this.additionalAttributes.get(attributeName);
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        return this.launchConfiguration.getAttribute(attributeName, defaultValue);
    }

    public int getAttribute(String attributeName, int defaultValue) throws CoreException {
        Object value = this.additionalAttributes.get(attributeName);
        if (value instanceof Integer) {
            return (Integer)value;
        }
        return this.launchConfiguration.getAttribute(attributeName, defaultValue);
    }

    public @Nullable List<String> getAttribute(String attributeName, @Nullable List<String> defaultValue) throws CoreException {
        Object value = this.additionalAttributes.get(attributeName);
        if (value instanceof List) {
            return (List)value;
        }
        return this.launchConfiguration.getAttribute(attributeName, defaultValue);
    }

    public @Nullable Set<String> getAttribute(String attributeName, @Nullable Set<String> defaultValue) throws CoreException {
        Object value = this.additionalAttributes.get(attributeName);
        if (value instanceof Set) {
            return (Set)value;
        }
        return this.launchConfiguration.getAttribute(attributeName, defaultValue);
    }

    public @Nullable Map getAttribute(String attributeName, @Nullable Map defaultValue) throws CoreException {
        Object value = this.additionalAttributes.get(attributeName);
        if (value instanceof Map) {
            return (Map)value;
        }
        return this.launchConfiguration.getAttribute(attributeName, defaultValue);
    }

    public @Nullable String getAttribute(String attributeName, @Nullable String defaultValue) throws CoreException {
        Object value = this.additionalAttributes.get(attributeName);
        if (value instanceof String) {
            return (String)value;
        }
        return this.launchConfiguration.getAttribute(attributeName, defaultValue);
    }

    public Map<String, Object> getAttributes() throws CoreException {
        return this.launchConfiguration.getAttributes();
    }

    public @Nullable String getCategory() throws CoreException {
        return this.launchConfiguration.getCategory();
    }

    public @Nullable IFile getFile() {
        return this.launchConfiguration.getFile();
    }

    @Deprecated
    public @Nullable IPath getLocation() {
        return this.launchConfiguration.getLocation();
    }

    public @Nullable IFileStore getFileStore() throws CoreException {
        if (this.launchConfiguration instanceof LaunchConfiguration) {
            return ((LaunchConfiguration)this.launchConfiguration).getFileStore();
        }
        return super.getFileStore();
    }

    public @NonNull IResource @Nullable [] getMappedResources() throws CoreException {
        return this.launchConfiguration.getMappedResources();
    }

    public @Nullable String getMemento() throws CoreException {
        return this.launchConfiguration.getMemento();
    }

    public Set<String> getModes() throws CoreException {
        return this.launchConfiguration.getModes();
    }

    public String getName() {
        return this.launchConfiguration.getName();
    }

    public @Nullable ILaunchDelegate getPreferredDelegate(Set<String> modes) throws CoreException {
        return this.launchConfiguration.getPreferredDelegate(modes);
    }

    public ILaunchConfigurationType getType() throws CoreException {
        return this.launchConfiguration.getType();
    }

    public ILaunchConfigurationWorkingCopy getWorkingCopy() throws CoreException {
        return this.launchConfiguration.getWorkingCopy();
    }

    public boolean isLocal() {
        return this.launchConfiguration.isLocal();
    }

    public boolean isMigrationCandidate() throws CoreException {
        return this.launchConfiguration.isMigrationCandidate();
    }

    public boolean isReadOnly() {
        return this.launchConfiguration.isReadOnly();
    }

    public boolean isWorkingCopy() {
        return false;
    }

    public void migrate() throws CoreException {
        this.launchConfiguration.migrate();
    }

    public boolean supportsMode(String mode) throws CoreException {
        return this.launchConfiguration.supportsMode(mode);
    }

    public <T> @Nullable T getAdapter(Class<T> adapterType) {
        return (T)this.launchConfiguration.getAdapter(adapterType);
    }
}

