/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.r.core.refactoring;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.text.AbstractDocument;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.RefactoringDescriptor;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.TextChange;
import org.eclipse.ltk.core.refactoring.TextFileChange;
import org.eclipse.osgi.util.NLS;
import org.eclipse.statet.internal.r.core.refactoring.Messages;
import org.eclipse.statet.jcommons.text.core.TextRegion;
import org.eclipse.statet.ltk.ast.core.AstInfo;
import org.eclipse.statet.ltk.ast.core.AstNode;
import org.eclipse.statet.ltk.ast.core.util.AstSelection;
import org.eclipse.statet.ltk.core.Ltk;
import org.eclipse.statet.ltk.model.core.ElementSet;
import org.eclipse.statet.ltk.model.core.element.SourceUnit;
import org.eclipse.statet.ltk.refactoring.core.CommonRefactoringDescriptor;
import org.eclipse.statet.ltk.refactoring.core.LtkRefactoring;
import org.eclipse.statet.ltk.refactoring.core.RefactoringChange;
import org.eclipse.statet.ltk.refactoring.core.RefactoringMessages;
import org.eclipse.statet.ltk.refactoring.core.SourceUnitChange;
import org.eclipse.statet.ltk.refactoring.core.TextChangeCompatibility;
import org.eclipse.statet.r.core.RUtil;
import org.eclipse.statet.r.core.model.RSourceUnit;
import org.eclipse.statet.r.core.model.RSourceUnitModelInfo;
import org.eclipse.statet.r.core.refactoring.RRefactoringAdapter;
import org.eclipse.statet.r.core.source.ast.FDef;
import org.eclipse.statet.r.core.source.ast.GenericVisitor;
import org.eclipse.statet.r.core.source.ast.RAstNode;
import org.eclipse.statet.r.core.source.ast.RAsts;
import org.eclipse.statet.r.core.source.util.RHeuristicTokenScanner;
import org.eclipse.text.edits.InsertEdit;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;

public class ExtractTempRefactoring
extends LtkRefactoring {
    private final RRefactoringAdapter adapter = new RRefactoringAdapter();
    private final ElementSet elementSet;
    private TextRegion selectionRegion;
    private TextRegion operationRegion;
    private final RSourceUnit sourceUnit;
    private RAstNode expression;
    private RAstNode container;
    private List<RAstNode> occurrencesList;
    private String tempName = "";
    private boolean replaceAllOccurrences = true;

    public ExtractTempRefactoring(RSourceUnit su, TextRegion region) {
        this.sourceUnit = su;
        this.elementSet = new ElementSet(new Object[]{su});
        if (region != null && region.getStartOffset() >= 0 && region.getLength() >= 0) {
            this.selectionRegion = region;
        }
    }

    public String getBundleId() {
        return "org.eclipse.statet.r.core";
    }

    public String getIdentifier() {
        return "org.eclipse.statet.r.refactoring.ExtractTempOperation";
    }

    public String getName() {
        return Messages.ExtractTemp_label;
    }

    public void setTempName(String newName) {
        this.tempName = newName;
    }

    public String getTempName() {
        return this.tempName;
    }

    public void setReplaceAllOccurrences(boolean enable) {
        this.replaceAllOccurrences = enable;
    }

    public int getAllOccurrencesCount() {
        return this.occurrencesList != null ? Integer.valueOf(this.occurrencesList.size()) : null;
    }

    public boolean getReplaceAllOccurrences() {
        return this.replaceAllOccurrences;
    }

    public RefactoringStatus checkInitialConditions(IProgressMonitor monitor) throws CoreException {
        SubMonitor m = SubMonitor.convert((IProgressMonitor)monitor, (int)6);
        try {
            if (this.selectionRegion != null) {
                this.sourceUnit.connect((IProgressMonitor)m.newChild(1));
                try {
                    RAstNode region;
                    AbstractDocument document = this.sourceUnit.getDocument(monitor);
                    RHeuristicTokenScanner scanner = this.adapter.getScanner(this.sourceUnit);
                    RSourceUnitModelInfo modelInfo = (RSourceUnitModelInfo)this.sourceUnit.getModelInfo("R", 2, (IProgressMonitor)m.newChild(1));
                    if (modelInfo != null) {
                        region = this.adapter.trimToAstRegion(document, this.selectionRegion, scanner);
                        AstInfo ast = modelInfo.getAst();
                        if (ast != null) {
                            this.expression = (RAstNode)AstSelection.search((AstNode)ast.getRoot(), (int)region.getStartOffset(), (int)region.getEndOffset(), (int)3).getCovering();
                        }
                    }
                    if (this.expression != null) {
                        region = this.expression;
                        this.operationRegion = this.adapter.expandSelectionRegion(document, (TextRegion)region, this.selectionRegion, scanner);
                    }
                }
                finally {
                    this.sourceUnit.disconnect((IProgressMonitor)m.newChild(1));
                }
            }
            if (this.expression == null) {
                RefactoringStatus refactoringStatus = RefactoringStatus.createFatalErrorStatus((String)Messages.ExtractTemp_error_InvalidSelection_message);
                return refactoringStatus;
            }
            RefactoringStatus result = new RefactoringStatus();
            this.adapter.checkInitialToModify(result, this.elementSet);
            m.worked(1);
            if (result.hasFatalError()) {
                RefactoringStatus refactoringStatus = result;
                return refactoringStatus;
            }
            this.checkExpression(result);
            m.worked(2);
            RefactoringStatus refactoringStatus = result;
            return refactoringStatus;
        }
        catch (BadLocationException e) {
            throw this.handleUnexpectedError(e);
        }
        finally {
            m.done();
        }
    }

    private void checkExpression(RefactoringStatus result) {
        switch (this.expression.getNodeType()) {
            case SYMBOL: 
            case STRING_CONST: 
            case NUM_CONST: 
            case NULL_CONST: 
            case BLOCK: 
            case GROUP: 
            case SUB_INDEXED_S: 
            case SUB_INDEXED_D: 
            case NS_GET: 
            case NS_GET_INT: 
            case SUB_NAMED_PART: 
            case SUB_NAMED_SLOT: 
            case POWER: 
            case SIGN: 
            case SEQ: 
            case SPECIAL: 
            case MULT: 
            case ADD: 
            case RELATIONAL: 
            case NOT: 
            case AND: 
            case OR: 
            case MODEL: 
            case A_RIGHT: 
            case A_EQUALS: 
            case A_LEFT: 
            case A_COLON: 
            case C_IF: 
            case C_FOR: 
            case C_WHILE: 
            case C_REPEAT: 
            case F_DEF: 
            case F_CALL: {
                break;
            }
            default: {
                result.merge(RefactoringStatus.createFatalErrorStatus((String)Messages.ExtractTemp_error_InvalidSelectionType_message));
                return;
            }
        }
        RAstNode parent = this.expression.getRParent();
        block9: while (parent != null) {
            switch (parent.getNodeType()) {
                case SOURCELINES: 
                case BLOCK: {
                    break block9;
                }
                case F_DEF_ARGS: {
                    result.merge(RefactoringStatus.createFatalErrorStatus((String)Messages.ExtractTemp_error_InvalidSelectionFHeader_message));
                    return;
                }
                default: {
                    parent = parent.getRParent();
                }
            }
        }
        if (parent == null) {
            throw new IllegalStateException();
        }
        if (this.selectionRegion != null && (this.selectionRegion.getStartOffset() != this.operationRegion.getStartOffset() || this.selectionRegion.getLength() != this.operationRegion.getLength())) {
            result.merge(RefactoringStatus.createWarningStatus((String)Messages.ExtractTemp_warning_ChangedRange_message));
        }
        this.occurrencesList = new ArrayList<RAstNode>();
        try {
            parent.acceptInRChildren(new OccurrencesSearcher());
        }
        catch (InvocationTargetException invocationTargetException) {
            // empty catch block
        }
        for (RAstNode node : this.occurrencesList) {
            if (!RAsts.hasErrors((AstNode)node)) continue;
            result.merge(RefactoringStatus.createWarningStatus((String)Messages.ExtractTemp_warning_OccurrencesSyntaxError_message));
            break;
        }
        this.container = parent;
    }

    public RefactoringStatus checkTempName(String name) {
        String message = this.adapter.validateIdentifier(name, "The local variable name");
        if (message != null) {
            return RefactoringStatus.createFatalErrorStatus((String)message);
        }
        return new RefactoringStatus();
    }

    public RefactoringStatus checkFinalConditions(IProgressMonitor monitor) throws CoreException {
        SubMonitor m = SubMonitor.convert((IProgressMonitor)monitor, (String)RefactoringMessages.Common_FinalCheck_label, (int)3);
        try {
            RefactoringStatus status = this.checkTempName(this.tempName);
            this.adapter.checkFinalToModify(status, this.elementSet, (IProgressMonitor)m.newChild(2));
            RefactoringStatus refactoringStatus = status;
            return refactoringStatus;
        }
        finally {
            m.done();
        }
    }

    public Change createChange(IProgressMonitor monitor) throws CoreException {
        SubMonitor m = SubMonitor.convert((IProgressMonitor)monitor, (String)RefactoringMessages.Common_CreateChanges_label, (int)3);
        try {
            SourceUnitChange textFileChange = new SourceUnitChange((SourceUnit)this.sourceUnit);
            if (this.sourceUnit.getWorkingContext() == Ltk.EDITOR_CONTEXT) {
                textFileChange.setSaveMode(4);
            }
            this.createChanges((TextFileChange)textFileChange, m.newChild(2));
            HashMap arguments = new HashMap();
            String varName = RRefactoringAdapter.getUnquotedIdentifier(this.tempName);
            String description = NLS.bind((String)Messages.ExtractTemp_Descriptor_description, (Object)RUtil.formatVarName(varName));
            IProject resource = this.elementSet.getSingleProject();
            String project = resource != null ? resource.getName() : null;
            String source = project != null ? NLS.bind((String)RefactoringMessages.Common_Source_Project_label, (Object)project) : RefactoringMessages.Common_Source_Workspace_label;
            boolean flags = false;
            String comment = "";
            CommonRefactoringDescriptor descriptor = new CommonRefactoringDescriptor(this.getIdentifier(), project, description, "", arguments, 0);
            m.worked(1);
            RefactoringChange refactoringChange = new RefactoringChange((RefactoringDescriptor)descriptor, Messages.ExtractTemp_label, new Change[]{textFileChange});
            return refactoringChange;
        }
        catch (BadLocationException e) {
            throw this.handleUnexpectedError(e);
        }
        finally {
            m.done();
        }
    }

    private void createChanges(TextFileChange change, SubMonitor m) throws BadLocationException, CoreException {
        m.setWorkRemaining(11);
        this.sourceUnit.connect((IProgressMonitor)m.newChild(1));
        try {
            AbstractDocument doc = this.sourceUnit.getDocument((IProgressMonitor)m.newChild(1));
            StringBuilder sb = new StringBuilder();
            String defAssign = " <- ";
            String text = doc.get(this.expression.getStartOffset(), this.expression.getLength());
            String variableName = this.tempName;
            sb.setLength(0);
            sb.append(variableName);
            sb.append(" <- ");
            sb.append(text);
            RAstNode baseNode = this.expression;
            while (baseNode.getRParent() != this.container) {
                baseNode = baseNode.getRParent();
            }
            int assignOffset = RRefactoringAdapter.prepareInsertBefore(sb, doc, baseNode.getStartOffset(), this.sourceUnit);
            TextChangeCompatibility.addTextEdit((TextChange)change, (String)Messages.ExtractTemp_Changes_AddVariable_name, (TextEdit)new InsertEdit(assignOffset, sb.toString()));
            m.worked(4);
            int i = 0;
            while (i < this.occurrencesList.size()) {
                RAstNode node = this.occurrencesList.get(i);
                TextChangeCompatibility.addTextEdit((TextChange)change, (String)Messages.ExtractTemp_Changes_ReplaceOccurrence_name, (TextEdit)new ReplaceEdit(node.getStartOffset(), node.getLength(), variableName), (node == this.expression || this.replaceAllOccurrences ? 1 : 0) != 0);
                ++i;
            }
            m.worked(4);
        }
        finally {
            this.sourceUnit.disconnect((IProgressMonitor)m.newChild(1));
        }
    }

    private class OccurrencesSearcher
    extends GenericVisitor {
        private final int start;

        private OccurrencesSearcher() {
            this.start = ExtractTempRefactoring.this.expression.getStartOffset();
        }

        @Override
        public void visitNode(RAstNode node) throws InvocationTargetException {
            if (node.getEndOffset() < this.start) {
                return;
            }
            if (ExtractTempRefactoring.this.expression.equalsValue(node)) {
                ExtractTempRefactoring.this.occurrencesList.add(node);
            } else {
                node.acceptInRChildren(this);
            }
        }

        @Override
        public void visit(FDef node) throws InvocationTargetException {
        }
    }
}

