/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.ltk.ui;

import org.eclipse.core.expressions.PropertyTester;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.content.IContentDescription;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.statet.ltk.core.Ltk;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;

public class ActivatedContentTypeTester
extends PropertyTester {
    public static final String MATCH_ACTIVATED_TYPE = "matchesActivatedContentType";
    public static final String MATCH_TYPE = "matchesContentType";

    /*
     * WARNING - void declaration
     */
    public boolean test(Object receiver, String property, Object[] args, Object expectedValue) {
        String expectedContentTypeId;
        Object editorInput;
        if (!(expectedValue instanceof String)) {
            return false;
        }
        IContentType contentType = null;
        IFile file = null;
        if (receiver instanceof IFile) {
            file = (IFile)receiver;
        } else {
            Object object = receiver;
            if (object instanceof IAdaptable) {
                IResource resource;
                void adaptableReceiver;
                IAdaptable iAdaptable = (IAdaptable)object;
                IAdaptable cfr_ignored_0 = (IAdaptable)object;
                file = (IFile)adaptableReceiver.getAdapter(IFile.class);
                if (file == null && (resource = (IResource)adaptableReceiver.getAdapter(IResource.class)) instanceof IFile) {
                    file = (IFile)resource;
                }
            }
        }
        if (file == null && (editorInput = receiver instanceof IEditorInput ? (IEditorInput)receiver : (receiver instanceof IEditorPart ? ((IEditorPart)receiver).getEditorInput() : null)) != null) {
            file = (IFile)editorInput.getAdapter(IFile.class);
        }
        if (file != null) {
            try {
                IContentDescription contentDescription = file.getContentDescription();
                if (contentDescription != null) {
                    contentType = contentDescription.getContentType();
                }
            }
            catch (CoreException contentDescription) {}
        } else if (receiver instanceof IAdaptable) {
            contentType = (IContentType)((IAdaptable)receiver).getAdapter(IContentType.class);
        }
        if (property.equals(MATCH_ACTIVATED_TYPE)) {
            expectedContentTypeId = (String)expectedValue;
            if (contentType != null) {
                return Ltk.getExtContentTypeManager().matchesActivatedContentType(contentType.getId(), expectedContentTypeId, true);
            }
            return false;
        }
        if (property.equals(MATCH_TYPE)) {
            expectedContentTypeId = (String)expectedValue;
            while (contentType != null) {
                if (expectedContentTypeId.equals(contentType.getId())) {
                    return true;
                }
                contentType = contentType.getBaseType();
            }
            return false;
        }
        return false;
    }
}

