/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.jcommons.text.core;

import org.eclipse.statet.jcommons.collections.ImIdentityList;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.string.CharPair;

@NonNullByDefault
public class CharPairSet {
    private final ImIdentityList<CharPair> pairs;
    private final char escapeChar;
    private final @Nullable CharMatch[] chars = new CharMatch[127];

    public CharPairSet(ImIdentityList<CharPair> pairs, char escapeChar) {
        this.pairs = pairs;
        this.escapeChar = escapeChar;
        int pairIndex = 0;
        while (pairIndex < pairs.size()) {
            CharPair pair = (CharPair)pairs.get(pairIndex);
            if (this.chars[pair.opening] != null || this.chars[pair.closing] != null) {
                throw new IllegalArgumentException();
            }
            this.chars[pair.opening] = new OpeningMatch(pair, pairIndex);
            this.chars[pair.closing] = new ClosingMatch(pair, pairIndex);
            ++pairIndex;
        }
    }

    public CharPairSet(ImIdentityList<CharPair> pairs) {
        this(pairs, '\u0000');
    }

    public ImIdentityList<CharPair> getPairs() {
        return this.pairs;
    }

    public int getPairCount() {
        return this.pairs.size();
    }

    public int getPairIndex(CharPair pair) {
        return this.pairs.indexOf((Object)pair);
    }

    public char getEscapeChar() {
        return this.escapeChar;
    }

    public @Nullable CharMatch getMatch(int c) {
        return c > 0 && c < 127 ? this.chars[c] : null;
    }

    public int hashCode() {
        return this.pairs.hashCode() + this.escapeChar * 31;
    }

    /*
     * WARNING - void declaration
     */
    public boolean equals(@Nullable Object obj) {
        block2: {
            block3: {
                void other;
                if (this == obj) break block2;
                Object object = obj;
                if (!(object instanceof CharPairSet)) break block3;
                CharPairSet charPairSet = (CharPairSet)object;
                CharPairSet cfr_ignored_0 = (CharPairSet)object;
                if (this.pairs.equals(other.pairs) && this.escapeChar == other.escapeChar) break block2;
            }
            return false;
        }
        return true;
    }

    public static abstract class CharMatch {
        protected final CharPair pair;
        private final int pairIndex;

        public CharMatch(CharPair pair, int pairIndex) {
            this.pair = pair;
            this.pairIndex = pairIndex;
        }

        public final CharPair getPair() {
            return this.pair;
        }

        public final int getPairIndex() {
            return this.pairIndex;
        }

        public abstract char getChar();

        public abstract boolean isOpening();

        public abstract boolean isClosing();

        public abstract char getMatchingChar();
    }

    private static final class ClosingMatch
    extends CharMatch {
        public ClosingMatch(CharPair pair, int pairIndex) {
            super(pair, pairIndex);
        }

        @Override
        public char getChar() {
            return this.pair.closing;
        }

        @Override
        public boolean isOpening() {
            return false;
        }

        @Override
        public boolean isClosing() {
            return true;
        }

        @Override
        public char getMatchingChar() {
            return this.pair.opening;
        }
    }

    private static final class OpeningMatch
    extends CharMatch {
        public OpeningMatch(CharPair pair, int pairIndex) {
            super(pair, pairIndex);
        }

        @Override
        public char getChar() {
            return this.pair.opening;
        }

        @Override
        public boolean isOpening() {
            return true;
        }

        @Override
        public boolean isClosing() {
            return false;
        }

        @Override
        public char getMatchingChar() {
            return this.pair.closing;
        }
    }
}

