/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.waltable.edit.gui;

import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.statet.ecommons.waltable.Messages;
import org.eclipse.statet.ecommons.waltable.config.CellConfigAttributes;
import org.eclipse.statet.ecommons.waltable.core.config.ConfigRegistry;
import org.eclipse.statet.ecommons.waltable.core.config.DisplayMode;
import org.eclipse.statet.ecommons.waltable.core.coordinate.Direction;
import org.eclipse.statet.ecommons.waltable.core.layer.LayerCell;
import org.eclipse.statet.ecommons.waltable.data.convert.ConversionFailedException;
import org.eclipse.statet.ecommons.waltable.data.convert.IDisplayConverter;
import org.eclipse.statet.ecommons.waltable.data.validate.IDataValidator;
import org.eclipse.statet.ecommons.waltable.data.validate.ValidationFailedException;
import org.eclipse.statet.ecommons.waltable.edit.DialogEditHandler;
import org.eclipse.statet.ecommons.waltable.edit.EditConfigAttributes;
import org.eclipse.statet.ecommons.waltable.edit.EditConfigHelper;
import org.eclipse.statet.ecommons.waltable.edit.EditMode;
import org.eclipse.statet.ecommons.waltable.edit.EditTypeEnum;
import org.eclipse.statet.ecommons.waltable.edit.ICellEditHandler;
import org.eclipse.statet.ecommons.waltable.edit.editor.ICellEditor;
import org.eclipse.statet.ecommons.waltable.edit.editor.IEditErrorHandler;
import org.eclipse.statet.ecommons.waltable.edit.gui.ICellEditDialog;
import org.eclipse.statet.internal.ecommons.waltable.WaLTablePlugin;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public abstract class AbstractDialogCellEditor
implements ICellEditor,
ICellEditDialog {
    protected Composite parent;
    protected Object dialog;
    protected LayerCell layerCell;
    protected DialogEditHandler editHandler = new DialogEditHandler();
    protected IDisplayConverter displayConverter;
    protected IDataValidator dataValidator;
    protected IEditErrorHandler conversionEditErrorHandler;
    protected IEditErrorHandler validationEditErrorHandler;
    protected ConfigRegistry configRegistry;
    protected Map<String, Object> editDialogSettings;

    @Override
    public EditTypeEnum getEditType() {
        return EditTypeEnum.SET;
    }

    @Override
    public Object calculateValue(Object currentValue, Object processValue) {
        return processValue;
    }

    @Override
    public abstract int open();

    @Override
    public Control activateCell(Composite parent, Object originalCanonicalValue, EditMode editMode, ICellEditHandler editHandler, LayerCell cell, ConfigRegistry configRegistry) {
        this.parent = parent;
        this.layerCell = cell;
        this.configRegistry = configRegistry;
        List<String> configLabels = cell.getLabels().getLabels();
        this.displayConverter = configRegistry.getAttribute(CellConfigAttributes.DISPLAY_CONVERTER, DisplayMode.EDIT, configLabels);
        this.dataValidator = configRegistry.getAttribute(EditConfigAttributes.DATA_VALIDATOR, DisplayMode.EDIT, configLabels);
        this.conversionEditErrorHandler = EditConfigHelper.getEditErrorHandler(configRegistry, EditConfigAttributes.CONVERSION_ERROR_HANDLER, configLabels);
        this.validationEditErrorHandler = EditConfigHelper.getEditErrorHandler(configRegistry, EditConfigAttributes.VALIDATION_ERROR_HANDLER, configLabels);
        this.dialog = this.createDialogInstance();
        this.setCanonicalValue(originalCanonicalValue);
        return null;
    }

    public abstract Object createDialogInstance();

    public abstract Object getDialogInstance();

    @Override
    public abstract Object getEditorValue();

    @Override
    public abstract void setEditorValue(Object var1);

    @Override
    public Object getCanonicalValue() {
        return this.getCanonicalValue(this.conversionEditErrorHandler);
    }

    @Override
    public Object getCanonicalValue(IEditErrorHandler conversionErrorHandler) {
        Object canonicalValue;
        try {
            canonicalValue = this.displayConverter != null ? this.displayConverter.displayToCanonicalValue(this.layerCell, this.configRegistry, this.getEditorValue()) : this.getEditorValue();
            conversionErrorHandler.removeError(this);
        }
        catch (ConversionFailedException e) {
            conversionErrorHandler.displayError(this, e);
            throw e;
        }
        catch (Exception e) {
            conversionErrorHandler.displayError(this, e);
            throw new ConversionFailedException(e.getMessage(), e);
        }
        return canonicalValue;
    }

    @Override
    public void setCanonicalValue(Object canonicalValue) {
        Object displayValue = this.displayConverter != null ? this.displayConverter.canonicalToDisplayValue(this.layerCell, this.configRegistry, canonicalValue) : canonicalValue;
        this.setEditorValue(displayValue);
    }

    @Override
    public boolean validateCanonicalValue(Object canonicalValue) {
        return this.validateCanonicalValue(canonicalValue, this.validationEditErrorHandler);
    }

    @Override
    public boolean validateCanonicalValue(Object canonicalValue, IEditErrorHandler validationErrorHandler) {
        if (this.dataValidator != null) {
            try {
                boolean validationResult = this.dataValidator.validate(this.layerCell, this.configRegistry, canonicalValue);
                if (!validationResult) {
                    throw new ValidationFailedException(Messages.getString("AbstractCellEditor.validationFailure"));
                }
                this.validationEditErrorHandler.removeError(this);
                return validationResult;
            }
            catch (Exception e) {
                this.validationEditErrorHandler.displayError(this, e);
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean commit(Direction direction) {
        return this.commit(direction, true);
    }

    @Override
    public boolean commit(Direction direction, boolean closeAfterCommit) {
        return this.commit(direction, closeAfterCommit, false);
    }

    @Override
    public boolean commit(Direction direction, boolean closeAfterCommit, boolean skipValidation) {
        if (this.editHandler != null && this.dialog != null && !this.isClosed()) {
            try {
                Object canonicalValue = this.getCanonicalValue();
                if (skipValidation || !skipValidation && this.validateCanonicalValue(canonicalValue)) {
                    boolean committed = this.editHandler.commit(canonicalValue, direction);
                    if (committed && closeAfterCommit) {
                        this.close();
                    }
                    return committed;
                }
            }
            catch (ConversionFailedException canonicalValue) {
            }
            catch (ValidationFailedException canonicalValue) {
            }
            catch (Exception e) {
                WaLTablePlugin.log((IStatus)new Status(4, "org.eclipse.statet.ecommons.waltable.core", "Error on updating cell value: " + e.getLocalizedMessage(), (Throwable)e));
            }
        }
        return false;
    }

    @Override
    public Object getCommittedValue() {
        return this.editHandler.getCommittedValue();
    }

    @Override
    public abstract void close();

    @Override
    public abstract boolean isClosed();

    @Override
    public Control getEditorControl() {
        return null;
    }

    @Override
    public Control createEditorControl(Composite parent) {
        return null;
    }

    @Override
    public boolean openInline(ConfigRegistry configRegistry, List<String> configLabels) {
        return false;
    }

    @Override
    public boolean supportMultiEdit(ConfigRegistry configRegistry, List<String> configLabels) {
        Boolean supportMultiEdit = configRegistry.getAttribute(EditConfigAttributes.SUPPORT_MULTI_EDIT, DisplayMode.EDIT, configLabels);
        return supportMultiEdit == null || supportMultiEdit != false;
    }

    @Override
    public boolean openMultiEditDialog() {
        return true;
    }

    @Override
    public boolean openAdjacentEditor() {
        return false;
    }

    @Override
    public boolean activateAtAnyPosition() {
        return true;
    }

    @Override
    public void addEditorControlListeners() {
    }

    @Override
    public void removeEditorControlListeners() {
    }

    @Override
    public Rectangle calculateControlBounds(Rectangle cellBounds) {
        return cellBounds;
    }

    @Override
    public void setDialogSettings(Map<String, Object> editDialogSettings) {
        this.editDialogSettings = editDialogSettings;
    }

    @Override
    public long getColumnPosition() {
        return this.layerCell.getColumnPosition();
    }

    @Override
    public long getRowPosition() {
        return this.layerCell.getRowPosition();
    }
}

