/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.docmlet.wikitext.ui.sourceediting;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.eclipse.jface.text.templates.Template;
import org.eclipse.mylyn.internal.wikitext.ui.WikiTextUiPlugin;
import org.eclipse.mylyn.internal.wikitext.ui.editor.assist.Templates;
import org.eclipse.mylyn.wikitext.parser.Attributes;
import org.eclipse.mylyn.wikitext.parser.DocumentBuilder;
import org.eclipse.mylyn.wikitext.parser.MarkupParser;
import org.eclipse.mylyn.wikitext.parser.markup.AbstractMarkupLanguage;
import org.eclipse.mylyn.wikitext.parser.markup.MarkupLanguage;
import org.eclipse.mylyn.wikitext.ui.WikiText;
import org.eclipse.statet.docmlet.wikitext.core.markup.WikitextMarkupLanguage;
import org.eclipse.statet.jcommons.collections.ImCollections;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.ltk.core.ElementName;
import org.eclipse.statet.ltk.model.core.element.LtkModelElement;
import org.eclipse.statet.ltk.model.core.element.LtkModelElementFilter;

@NonNullByDefault
public class MarkupTemplates {
    private final WikitextMarkupLanguage markupLanguage;
    private final List<Template> templates;
    private final Map<Template, MarkupInfo> templateInfos;

    public MarkupTemplates(WikitextMarkupLanguage markupLanguage) {
        this.markupLanguage = markupLanguage;
        this.templateInfos = new HashMap<Template, MarkupInfo>();
        this.templates = this.init();
    }

    private List<Template> init() {
        Templates mylynTemplates = this.getMylynTemplates();
        if (mylynTemplates == null) {
            return ImCollections.emptyList();
        }
        List list = mylynTemplates.getTemplate();
        TemplateTester tester = new TemplateTester((MarkupLanguage)this.markupLanguage);
        for (Template template : list) {
            if (!mylynTemplates.isBlock(template)) continue;
            this.templateInfos.put(template, tester.createInfo(template));
        }
        return list;
    }

    private @Nullable Templates getMylynTemplates() {
        Templates mylynTemplates;
        Map map = WikiTextUiPlugin.getDefault().getTemplates();
        MarkupLanguage language = (MarkupLanguage)this.markupLanguage;
        while ((mylynTemplates = (Templates)map.get(language.getName())) == null && language.getExtendsLanguage() != null && (language = WikiText.getMarkupLanguage((String)language.getExtendsLanguage())) != null) {
        }
        return mylynTemplates;
    }

    public List<Template> getTemplates() {
        return this.templates;
    }

    public MarkupInfo getMarkupInfo(Template template) {
        return this.templateInfos.get(template);
    }

    public static class MarkupInfo
    implements LtkModelElement {
        private final int headingLevel;
        private final // Could not load outer class - annotation placement on inner may be incorrect
        @Nullable DocumentBuilder.BlockType blockType;
        private final int modelElementType;

        public MarkupInfo() {
            this.headingLevel = 0;
            this.blockType = null;
            this.modelElementType = 0;
        }

        public MarkupInfo(int headingLevel) {
            this.headingLevel = headingLevel;
            this.blockType = null;
            this.modelElementType = 0x420 | headingLevel;
        }

        public MarkupInfo(DocumentBuilder.BlockType blockType) {
            this.headingLevel = 0;
            this.blockType = blockType;
            this.modelElementType = 0;
        }

        public int getHeadingLevel() {
            return this.headingLevel;
        }

        public DocumentBuilder.BlockType getBlockType() {
            return this.blockType;
        }

        public String getModelTypeId() {
            return "Wikidoc";
        }

        public <T> @Nullable T getAdapter(Class<T> adapterType) {
            return null;
        }

        public int getElementType() {
            return this.modelElementType;
        }

        public ElementName getElementName() {
            return null;
        }

        public String getId() {
            return null;
        }

        public boolean exists() {
            return false;
        }

        public boolean isReadOnly() {
            return false;
        }

        public @Nullable LtkModelElement getModelParent() {
            return null;
        }

        public boolean hasModelChildren(@Nullable LtkModelElementFilter filter) {
            return false;
        }

        public List<? extends LtkModelElement> getModelChildren(@Nullable LtkModelElementFilter filter) {
            return ImCollections.emptyList();
        }
    }

    private static class TemplateTester
    extends DocumentBuilder {
        private static final Pattern VARIABLE_PATTERN = Pattern.compile("(\\$\\{\\w*\\})");
        private final MarkupParser parser;
        private @Nullable MarkupInfo found;

        /*
         * WARNING - void declaration
         */
        public TemplateTester(MarkupLanguage markupLanguage) {
            MarkupLanguage markupLanguage2 = markupLanguage = markupLanguage.clone();
            if (markupLanguage2 instanceof AbstractMarkupLanguage) {
                void language;
                AbstractMarkupLanguage abstractMarkupLanguage = (AbstractMarkupLanguage)markupLanguage2;
                AbstractMarkupLanguage cfr_ignored_0 = (AbstractMarkupLanguage)markupLanguage2;
                language.setFilterGenerativeContents(true);
                language.setBlocksOnly(true);
            }
            this.parser = new MarkupParser(markupLanguage, (DocumentBuilder)this);
        }

        public MarkupInfo createInfo(Template template) {
            this.found = null;
            String text = template.getPattern();
            text = VARIABLE_PATTERN.matcher(text).replaceAll("Abcdefg ");
            text = String.valueOf(text) + "Abcdefg \n\n\n";
            try {
                this.parser.parse(text);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (this.found == null) {
                this.found = new MarkupInfo();
            }
            return this.found;
        }

        public void beginDocument() {
        }

        public void endDocument() {
        }

        public void beginBlock(DocumentBuilder.BlockType type, Attributes attributes) {
            this.found = new MarkupInfo(type);
            throw new RuntimeException();
        }

        public void endBlock() {
        }

        public void beginSpan(DocumentBuilder.SpanType type, Attributes attributes) {
        }

        public void endSpan() {
        }

        public void beginHeading(int level, Attributes attributes) {
            this.found = new MarkupInfo(level);
            throw new RuntimeException();
        }

        public void endHeading() {
        }

        public void characters(String text) {
        }

        public void entityReference(String entity) {
        }

        public void image(Attributes attributes, String url) {
        }

        public void link(Attributes attributes, String hrefOrHashName, String text) {
        }

        public void imageLink(Attributes linkAttributes, Attributes imageAttributes, String href, String imageUrl) {
        }

        public void acronym(String text, String definition) {
        }

        public void lineBreak() {
        }

        public void charactersUnescaped(String literal) {
        }
    }
}

