/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.docmlet.tex.ui;

import org.eclipse.statet.docmlet.base.ui.DocmlBaseUIResources;
import org.eclipse.statet.docmlet.tex.core.model.TexNameAccess;
import org.eclipse.statet.docmlet.tex.ui.TexUIResources;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.ltk.model.core.element.LtkModelElement;
import org.eclipse.statet.ltk.ui.ElementLabelProvider;
import org.eclipse.swt.graphics.Image;

@NonNullByDefault
public class TexElementLabelProvider
implements ElementLabelProvider {
    private final DocmlBaseUIResources docBaseResources = DocmlBaseUIResources.INSTANCE;
    private final TexUIResources texResources = TexUIResources.INSTANCE;

    protected @Nullable Image getDocBaseImage(String imageId) {
        return this.docBaseResources.getImage(imageId);
    }

    protected @Nullable Image getTexImage(String imageId) {
        return this.texResources.getImage(imageId);
    }

    public @Nullable Image getImage(LtkModelElement<?> element) {
        if (element.getModelTypeId() == "Ltx") {
            return switch (element.getElementType() & 0xFFF) {
                case 1040 -> this.getDocBaseImage("org.eclipse.statet.docmlet.base/image/obj/Preamble");
                case 1057 -> this.getTexImage("org.eclipse.statet.docmlet.tex/image/obj/sectioning-part");
                case 1058 -> this.getTexImage("org.eclipse.statet.docmlet.tex/image/obj/sectioning-chapter");
                case 1059 -> this.getTexImage("org.eclipse.statet.docmlet.tex/image/obj/sectioning-section");
                case 1060 -> this.getTexImage("org.eclipse.statet.docmlet.tex/image/obj/sectioning-subsection");
                case 1061 -> this.getTexImage("org.eclipse.statet.docmlet.tex/image/obj/sectioning-subsubsection");
                default -> null;
            };
        }
        return null;
    }

    public @Nullable Image getImage(TexNameAccess access) {
        if (access.getType() == 66) {
            return this.getTexImage("org.eclipse.statet.docmlet.base/image/obj/Label-Ref");
        }
        return null;
    }

    public @Nullable String getText(LtkModelElement<?> element) {
        if (element.getModelTypeId() == "Ltx") {
            return element.getElementName().getDisplayName();
        }
        return null;
    }
}

