/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.client;

import org.eclipse.jetty.client.Connection;
import org.eclipse.jetty.client.Destination;
import org.eclipse.jetty.client.MultiplexConnectionPool;
import org.eclipse.jetty.util.ConcurrentPool;
import org.eclipse.jetty.util.Pool;
import org.eclipse.jetty.util.annotation.ManagedObject;

@ManagedObject
public class RoundRobinConnectionPool
extends MultiplexConnectionPool {
    public RoundRobinConnectionPool(Destination destination, int maxConnections) {
        this(destination, maxConnections, 1);
    }

    public RoundRobinConnectionPool(Destination destination, int maxConnections, int initialMaxMultiplex) {
        super(destination, (Pool.Factory<Connection>)((Pool.Factory)() -> new ConcurrentPool(ConcurrentPool.StrategyType.ROUND_ROBIN, maxConnections, false, RoundRobinConnectionPool.newMaxMultiplexer(initialMaxMultiplex))), initialMaxMultiplex);
        this.setMaximizeConnections(true);
    }
}

