/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.r.core.pkgmanager;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.statet.internal.r.core.RCorePlugin;
import org.eclipse.statet.internal.r.core.pkgmanager.RViewImpl;
import org.eclipse.statet.jcommons.collections.ImCollections;
import org.eclipse.statet.jcommons.collections.ImList;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.lang.ObjectUtils;
import org.eclipse.statet.jcommons.status.ProgressMonitor;
import org.eclipse.statet.jcommons.status.StatusException;
import org.eclipse.statet.r.core.pkgmanager.RRepo;
import org.eclipse.statet.r.core.pkgmanager.RView;
import org.eclipse.statet.rj.data.RCharacterStore;
import org.eclipse.statet.rj.data.RDataFrame;
import org.eclipse.statet.rj.data.RDataUtils;
import org.eclipse.statet.rj.data.RList;
import org.eclipse.statet.rj.data.RLogicalStore;
import org.eclipse.statet.rj.data.RObject;
import org.eclipse.statet.rj.data.UnexpectedRDataException;
import org.eclipse.statet.rj.data.impl.DefaultRObjectFactory;
import org.eclipse.statet.rj.services.FunctionCall;
import org.eclipse.statet.rj.services.RService;

@NonNullByDefault
class RViewTasks {
    RViewTasks() {
    }

    static @Nullable ImList<RView> loadRViews(ImList<RRepo> repos, RService r, ProgressMonitor m) {
        m.beginSubTask("Loading R task views...");
        try {
            if (repos.isEmpty()) {
                return ImCollections.emptyList();
            }
            FunctionCall call = r.createFunctionCall("ctv::available.views");
            call.add("repos", (RObject)DefaultRObjectFactory.INSTANCE.createCharVector((List)repos.map(RRepo::getURL).toList()));
            RList rViews = RDataUtils.checkRList((RObject)call.evalData(m), (String)"ctvlist");
            int nViews = RDataUtils.checkIntLength((RObject)rViews);
            ArrayList<RViewImpl> views = new ArrayList<RViewImpl>(nViews);
            int iView = 0;
            while (iView < nViews) {
                RList rView = RDataUtils.checkRList((RObject)rViews.get(iView), (String)"ctv");
                String name = RDataUtils.checkSingleCharValue((RObject)rView.get("name"));
                String topic = RDataUtils.checkSingleCharValue((RObject)rView.get("topic"));
                RDataFrame rPkgList = RDataUtils.checkRDataFrame((RObject)rView.get("packagelist"));
                RCharacterStore rPkgsName = RDataUtils.checkRCharColumn((RDataFrame)rPkgList, (String)"name");
                RLogicalStore rPkgsCore = RDataUtils.checkRLogiColumn((RDataFrame)rPkgList, (String)"core");
                Object[] viewPkgs = new RView.Pkg[RDataUtils.checkIntLength((RObject)rPkgList)];
                int iPkg = 0;
                while (iPkg < viewPkgs.length) {
                    viewPkgs[iPkg] = new RView.Pkg((String)ObjectUtils.nonNullAssert((Object)rPkgsName.get(iPkg)), rPkgsCore.getLogi(iPkg));
                    ++iPkg;
                }
                views.add(new RViewImpl(name, topic, (ImList<RView.Pkg>)ImCollections.newList((Object[])viewPkgs)));
                ++iView;
            }
            return ImCollections.toList(views);
        }
        catch (StatusException | UnexpectedRDataException e) {
            RCorePlugin.logError("An error occurred when loading R task views.", e);
            return null;
        }
    }
}

