/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.r.core.builder;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.content.IContentDescription;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.osgi.util.NLS;
import org.eclipse.statet.internal.r.core.Messages;
import org.eclipse.statet.internal.r.core.RCorePlugin;
import org.eclipse.statet.internal.r.core.RProjectNature;
import org.eclipse.statet.internal.r.core.builder.RdParser;
import org.eclipse.statet.internal.r.core.rmodel.RModelManagerImpl;
import org.eclipse.statet.jcommons.collections.ImList;
import org.eclipse.statet.ltk.buildpath.core.BuildpathElement;
import org.eclipse.statet.ltk.buildpath.core.BuildpathUtils;
import org.eclipse.statet.ltk.core.Ltk;
import org.eclipse.statet.ltk.core.source.SourceContent;
import org.eclipse.statet.ltk.model.core.LtkModels;
import org.eclipse.statet.ltk.model.core.SourceUnitManager;
import org.eclipse.statet.r.core.project.RBuildpaths;
import org.eclipse.statet.r.core.project.RProject;
import org.eclipse.statet.r.core.project.RTaskMarkerHandler;
import org.eclipse.statet.r.core.rmodel.RSourceUnit;
import org.eclipse.statet.r.core.rmodel.RWorkspaceSourceUnit;

public class RBuilder
implements IResourceDeltaVisitor,
IResourceVisitor {
    private final SourceUnitManager suManager = LtkModels.getSourceUnitManager();
    private final List<IFile> toRemoveRSU = new ArrayList<IFile>();
    private final ArrayList<RWorkspaceSourceUnit> toUpdateRSU = new ArrayList();
    private final RModelManagerImpl modelManager;
    private MultiStatus statusCollector;
    private IProject project;
    private IPath pkgRootPath;
    private ImList<BuildpathElement> sourceContainters;
    private BuildpathElement currentSourceContainer;
    private final RTaskMarkerHandler taskMarkerHandler = new RTaskMarkerHandler();

    public static void clearMarkers(IResource resource, int depth) {
        try {
            resource.deleteMarkers("org.eclipse.statet.r.resourceMarkers.RModelProblem", false, depth);
            resource.deleteMarkers("org.eclipse.statet.r.resourceMarkers.Tasks", false, depth);
        }
        catch (CoreException e) {
            RCorePlugin.logError("R Builder: Failed to remove old markers.", e);
        }
    }

    private static IContainer getContainer(IProject project, IPath path) {
        return path.isEmpty() ? project : project.getFolder(path);
    }

    public RBuilder() {
        this.modelManager = RCorePlugin.getInstance().getRModelManager();
    }

    private void initBuildpath(RProject project) {
        this.sourceContainters = project.getRawBuildpath();
        this.pkgRootPath = project.getPkgRootPath();
        this.currentSourceContainer = null;
        this.initRd(project);
    }

    private boolean isValidSourceFolder(IResource resource) {
        return this.currentSourceContainer != null && !BuildpathUtils.isExcluded((IResource)resource, (BuildpathElement)this.currentSourceContainer);
    }

    /*
     * Unable to fully structure code
     */
    public IStatus buildIncremental(RProject rProject, IResourceDelta delta, IProgressMonitor monitor) {
        block11: {
            block10: {
                this.project = rProject.getProject();
                this.statusCollector = new MultiStatus("org.eclipse.statet.r.core", 0, "R build status for " + this.project.getName(), null);
                this.initBuildpath(rProject);
                m = SubMonitor.convert((IProgressMonitor)monitor, (int)13);
                try {
                    try {
                        m.subTask(NLS.bind((String)"Collecting resource changes of ''{0}''.", (Object)this.project.getName()));
                        pkgRoot = null;
                        if (this.pkgRootPath != null) {
                            pkgRoot = this.visitPkgRoot(delta.findMember(this.pkgRootPath.removeFirstSegments(1)));
                        }
                        m.worked(1);
                        for (BuildpathElement sourceContainer : this.sourceContainters) {
                            sourceDelta = delta.findMember(sourceContainer.getPath().removeFirstSegments(1));
                            if (sourceDelta != null) {
                                this.currentSourceContainer = sourceContainer;
                                sourceDelta.accept((IResourceDeltaVisitor)this);
                            }
                            if (!m.isCanceled()) continue;
                            throw new OperationCanceledException();
                        }
                        m.worked(1);
                        this.modelManager.getIndex().update(rProject, pkgRoot, this.toRemoveRSU, this.toUpdateRSU, this.statusCollector, m.newChild(10));
                        break block10;
                    }
                    catch (CoreException e) {
                        this.statusCollector.add((IStatus)new Status(4, "org.eclipse.statet.r.core", 0, "An error occurred when indexing the project.", (Throwable)e));
                        this.currentSourceContainer = null;
                        ** for (su : this.toUpdateRSU)
                    }
                }
                catch (Throwable var9_16) {
                    this.currentSourceContainer = null;
                    ** for (su : this.toUpdateRSU)
                }
lbl-1000:
                // 1 sources

                {
                    if (su == null) continue;
                    su.disconnect((IProgressMonitor)m);
                    continue;
                }
lbl29:
                // 1 sources

                this.toRemoveRSU.clear();
                this.toUpdateRSU.clear();
                this.project = null;
                break block11;
lbl-1000:
                // 1 sources

                {
                    if (su == null) continue;
                    su.disconnect((IProgressMonitor)m);
                    continue;
                }
lbl39:
                // 1 sources

                this.toRemoveRSU.clear();
                this.toUpdateRSU.clear();
                this.project = null;
                throw var9_16;
            }
            this.currentSourceContainer = null;
            for (RSourceUnit su : this.toUpdateRSU) {
                if (su == null) continue;
                su.disconnect((IProgressMonitor)m);
            }
            this.toRemoveRSU.clear();
            this.toUpdateRSU.clear();
            this.project = null;
        }
        return this.statusCollector;
    }

    private IContainer visitPkgRoot(IResourceDelta delta) throws CoreException {
        IResource resource;
        if (delta != null && (resource = delta.getResource()) instanceof IContainer) {
            IContainer container = (IContainer)resource;
            this.project.deleteMarkers("org.eclipse.statet.r.resourceMarkers.BuildpathProblem", false, 0);
            switch (delta.getKind()) {
                case 1: 
                case 4: {
                    RBuilder.clearMarkers(resource, 0);
                    break;
                }
                case 2: {
                    IResource movedTo;
                    if ((delta.getFlags() & 0x2000) == 0 || (movedTo = resource.getWorkspace().getRoot().findMember(delta.getMovedToPath())) == null || this.isRPkgRootLocation(movedTo)) break;
                    RBuilder.clearMarkers(movedTo, 0);
                }
            }
            this.visitPkgFile(delta.findMember(RBuildpaths.PKG_DESCRIPTION_FILE_PATH));
            return container;
        }
        return null;
    }

    private boolean visitPkgFile(IResourceDelta delta) throws CoreException {
        IResource resource;
        if (delta != null && (resource = delta.getResource()) instanceof IFile) {
            switch (delta.getKind()) {
                case 1: 
                case 4: {
                    RBuilder.clearMarkers(resource, 0);
                    break;
                }
                case 2: {
                    IResource movedTo;
                    if ((delta.getFlags() & 0x2000) == 0 || (movedTo = resource.getWorkspace().getRoot().findMember(delta.getMovedToPath())) == null || this.isRPkgRootLocation((IResource)movedTo.getParent())) break;
                    RBuilder.clearMarkers(movedTo, 0);
                }
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean visit(IResourceDelta delta) throws CoreException {
        IResource resource = delta.getResource();
        try {
            if (!this.isValidSourceFolder(resource)) {
                return false;
            }
            switch (delta.getKind()) {
                case 1: 
                case 4: {
                    IResource iResource = resource;
                    if (iResource instanceof IFile) {
                        void file;
                        IFile iFile = (IFile)iResource;
                        IFile cfr_ignored_0 = (IFile)iResource;
                        IContentDescription contentDescription = file.getContentDescription();
                        if (contentDescription == null) {
                            return true;
                        }
                        IContentType contentType = contentDescription.getContentType();
                        if (contentType == null) {
                            return true;
                        }
                        if ("org.eclipse.statet.r.contentTypes.R".equals(contentType.getId())) {
                            RBuilder.clearMarkers(resource, 0);
                            RWorkspaceSourceUnit su = (RWorkspaceSourceUnit)this.suManager.getSourceUnit(Ltk.PERSISTENCE_CONTEXT, (Object)file, contentType, true, null);
                            if (su != null) {
                                this.toUpdateRSU.add(su);
                            }
                            return true;
                        }
                        if ("org.eclipse.statet.r.contentTypes.Rd".equals(contentType.getId())) {
                            RBuilder.clearMarkers(resource, 0);
                            this.doParseRd((IFile)file);
                            return true;
                        }
                    }
                    return true;
                }
                case 2: {
                    IResource movedTo;
                    if ((delta.getFlags() & 0x2000) != 0 && (movedTo = resource.getWorkspace().getRoot().findMember(delta.getMovedToPath())) != null && !this.isRSourceLocation(movedTo)) {
                        RBuilder.clearMarkers(movedTo, 2);
                    }
                    if (resource instanceof IFile) {
                        this.toRemoveRSU.add((IFile)resource);
                    }
                    return true;
                }
            }
            return true;
        }
        catch (CoreException e) {
            this.statusCollector.add((IStatus)new Status(4, "org.eclipse.statet.r.core", 0, NLS.bind((String)"An error occurred when checking ''{0}''", (Object)resource.getFullPath().toString()), (Throwable)e));
            return false;
        }
    }

    /*
     * Unable to fully structure code
     */
    public IStatus buildFull(RProject rProject, IProgressMonitor monitor) {
        block11: {
            block10: {
                this.project = rProject.getProject();
                this.statusCollector = new MultiStatus("org.eclipse.statet.r.core", 0, "R build status for " + this.project.getName(), null);
                this.initBuildpath(rProject);
                m = SubMonitor.convert((IProgressMonitor)monitor, (int)13);
                try {
                    try {
                        m.subTask(NLS.bind((String)"Collecting resource changes of ''{0}''.", (Object)this.project.getName()));
                        pkgRoot = null;
                        if (this.pkgRootPath != null) {
                            pkgRoot = this.visitPkgRoot(RBuilder.getContainer(this.project, this.pkgRootPath.removeFirstSegments(1)));
                            this.project.deleteMarkers("org.eclipse.statet.r.resourceMarkers.BuildpathProblem", false, 0);
                        }
                        m.worked(1);
                        for (BuildpathElement sourceContainer : this.sourceContainters) {
                            resource = this.project.findMember(sourceContainer.getPath().removeFirstSegments(1));
                            if (resource != null) {
                                this.currentSourceContainer = sourceContainer;
                                resource.accept((IResourceVisitor)this);
                            }
                            if (!m.isCanceled()) continue;
                            throw new OperationCanceledException();
                        }
                        m.worked(1);
                        this.modelManager.getIndex().update(rProject, pkgRoot, null, this.toUpdateRSU, this.statusCollector, m.newChild(10));
                        break block10;
                    }
                    catch (CoreException e) {
                        this.statusCollector.add((IStatus)new Status(4, "org.eclipse.statet.r.core", 0, "An error occurred when indexing the project.", (Throwable)e));
                        this.currentSourceContainer = null;
                        ** for (su : this.toUpdateRSU)
                    }
                }
                catch (Throwable var8_15) {
                    this.currentSourceContainer = null;
                    ** for (su : this.toUpdateRSU)
                }
lbl-1000:
                // 1 sources

                {
                    if (su == null) continue;
                    su.disconnect((IProgressMonitor)m);
                    continue;
                }
lbl30:
                // 1 sources

                this.toRemoveRSU.clear();
                this.toUpdateRSU.clear();
                this.project = null;
                break block11;
lbl-1000:
                // 1 sources

                {
                    if (su == null) continue;
                    su.disconnect((IProgressMonitor)m);
                    continue;
                }
lbl40:
                // 1 sources

                this.toRemoveRSU.clear();
                this.toUpdateRSU.clear();
                this.project = null;
                throw var8_15;
            }
            this.currentSourceContainer = null;
            for (RSourceUnit su : this.toUpdateRSU) {
                if (su == null) continue;
                su.disconnect((IProgressMonitor)m);
            }
            this.toRemoveRSU.clear();
            this.toUpdateRSU.clear();
            this.project = null;
        }
        return this.statusCollector;
    }

    private IContainer visitPkgRoot(IContainer container) throws CoreException {
        this.project.deleteMarkers("org.eclipse.statet.r.resourceMarkers.BuildpathProblem", false, 0);
        if (container.exists()) {
            RBuilder.clearMarkers((IResource)container, 0);
            this.visitPkgFile(container.findMember(RBuildpaths.PKG_DESCRIPTION_FILE_PATH));
        }
        return container;
    }

    private void visitPkgFile(IResource resource) {
        if (resource instanceof IFile) {
            RBuilder.clearMarkers(resource, 0);
        }
    }

    /*
     * WARNING - void declaration
     */
    public boolean visit(IResource resource) throws CoreException {
        block8: {
            IContentType contentType;
            void file;
            block11: {
                block10: {
                    IContentDescription contentDescription;
                    block9: {
                        block7: {
                            try {
                                if (this.isValidSourceFolder(resource)) break block7;
                                return false;
                            }
                            catch (CoreException e) {
                                this.statusCollector.add((IStatus)new Status(4, "org.eclipse.statet.r.core", 0, NLS.bind((String)"An error occurred when checking ''{0}''", (Object)resource.getFullPath().toString()), (Throwable)e));
                                return false;
                            }
                        }
                        IResource iResource = resource;
                        if (!(iResource instanceof IFile)) break block8;
                        IFile iFile = (IFile)iResource;
                        IFile cfr_ignored_0 = (IFile)iResource;
                        contentDescription = file.getContentDescription();
                        if (contentDescription != null) break block9;
                        return true;
                    }
                    contentType = contentDescription.getContentType();
                    if (contentType != null) break block10;
                    return true;
                }
                if (!"org.eclipse.statet.r.contentTypes.R".equals(contentType.getId())) break block11;
                RBuilder.clearMarkers(resource, 2);
                RWorkspaceSourceUnit su = (RWorkspaceSourceUnit)this.suManager.getSourceUnit(Ltk.PERSISTENCE_CONTEXT, (Object)file, contentType, true, null);
                if (su != null) {
                    this.toUpdateRSU.add(su);
                }
                return true;
            }
            if (!"org.eclipse.statet.r.contentTypes.Rd".equals(contentType.getId())) break block8;
            RBuilder.clearMarkers(resource, 2);
            this.doParseRd((IFile)file);
            return true;
        }
        return true;
    }

    public void clean(IProject project, IProgressMonitor monitor) {
        this.project = project;
        try {
            try {
                project.deleteMarkers("org.eclipse.statet.r.resourceMarkers.BuildpathProblem", false, 0);
                RBuilder.clearMarkers((IResource)project, 2);
                this.modelManager.getIndex().clear(project);
            }
            catch (CoreException e) {
                this.statusCollector.add((IStatus)new Status(4, "org.eclipse.statet.r.core", 0, "An error occurred when indexing the project.", (Throwable)e));
                this.project = null;
            }
        }
        finally {
            this.project = null;
        }
    }

    private boolean isRSourceLocation(IResource resource) throws CoreException {
        IProject project = resource.getProject();
        if (project == this.project) {
            return true;
        }
        return project.hasNature("org.eclipse.statet.r.resourceProjects.R");
    }

    private boolean isRPkgRootLocation(IResource resource) throws CoreException {
        IProject project = resource.getProject();
        if (project == this.project) {
            return resource.getFullPath().equals((Object)this.pkgRootPath);
        }
        if (project.hasNature("org.eclipse.statet.r.resourceProjects.RPkg")) {
            RProjectNature rProject = RProjectNature.getRProject(project);
            return rProject != null && resource.getFullPath().equals((Object)rProject.getPkgRootPath());
        }
        return false;
    }

    protected void initRd(RProject project) {
        this.taskMarkerHandler.init(project);
    }

    protected void doParseRd(IFile file) throws CoreException {
        try {
            SourceContent sourceContent = new SourceContent(0L, this.readFile(file));
            this.taskMarkerHandler.setup(sourceContent, (IResource)file);
            new RdParser(sourceContent, this.taskMarkerHandler).check();
        }
        catch (CoreException e) {
            this.statusCollector.add((IStatus)new Status(4, "org.eclipse.statet.r.core", 0, NLS.bind((String)"An error occurred when parsing Rd file ''{0}''", (Object)file.getFullPath().toString()), (Throwable)e));
        }
    }

    protected String readFile(IFile file) throws CoreException {
        String charset = null;
        InputStream input = null;
        try {
            int n;
            input = file.getContents();
            charset = file.getCharset();
            BufferedReader reader = new BufferedReader(new InputStreamReader(input, charset));
            StringBuilder text = new StringBuilder(1000);
            char[] readBuffer = new char[2048];
            while ((n = reader.read(readBuffer)) > 0) {
                text.append(readBuffer, 0, n);
            }
            String string = text.toString();
            return string;
        }
        catch (UnsupportedEncodingException e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.statet.r.core", 0, NLS.bind((String)Messages.Builder_error_UnsupportedEncoding_message, (Object[])new String[]{charset, file.getName()}), (Throwable)e));
        }
        catch (IOException e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.statet.r.core", 0, NLS.bind((String)Messages.Builder_error_IOReadingFile_message, (Object)file.getName()), (Throwable)e));
        }
        finally {
            if (input != null) {
                try {
                    input.close();
                }
                catch (IOException iOException) {}
            }
        }
    }
}

