/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.waltable.grid.core.labeled;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.statet.ecommons.waltable.core.coordinate.Orientation;
import org.eclipse.statet.ecommons.waltable.core.data.DataProvider;
import org.eclipse.statet.ecommons.waltable.core.layer.BasicLayerCell;
import org.eclipse.statet.ecommons.waltable.core.layer.BasicLayerCellDim;
import org.eclipse.statet.ecommons.waltable.core.layer.LabelStack;
import org.eclipse.statet.ecommons.waltable.core.layer.Layer;
import org.eclipse.statet.ecommons.waltable.core.layer.LayerCell;
import org.eclipse.statet.ecommons.waltable.core.layer.LayerPainter;
import org.eclipse.statet.ecommons.waltable.grid.core.layers.CornerLayer;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;

@NonNullByDefault
public class LabelCornerLayer
extends CornerLayer {
    private final @Nullable DataProvider columnHeaderLabelProvider;
    private final @Nullable DataProvider rowHeaderLabelProvider;

    public LabelCornerLayer(Layer baseLayer, Layer horizontalLayerDependency, Layer verticalLayerDependency, @Nullable DataProvider columnHeaderLabelProvider, @Nullable DataProvider rowHeaderLabelProvider, boolean useDefaultConfiguration, LayerPainter layerPainter) {
        super(baseLayer, horizontalLayerDependency, verticalLayerDependency, useDefaultConfiguration, layerPainter);
        this.columnHeaderLabelProvider = columnHeaderLabelProvider;
        this.rowHeaderLabelProvider = rowHeaderLabelProvider;
    }

    @Override
    public LayerCell getCellByPosition(long columnPosition, long rowPosition) {
        Object hDim = this.getDim(Orientation.HORIZONTAL);
        Object vDim = this.getDim(Orientation.VERTICAL);
        long columnId = hDim.getPositionId(columnPosition, columnPosition);
        long rowId = vDim.getPositionId(rowPosition, rowPosition);
        long columnCount = this.getColumnCount();
        long rowCount = this.getRowCount();
        if (rowPosition < rowCount - 1L) {
            return new BasicLayerCell(this, new BasicLayerCellDim(Orientation.HORIZONTAL, columnId, columnPosition, 0L, columnCount), new BasicLayerCellDim(Orientation.VERTICAL, rowId, rowPosition)){

                @Override
                public LabelStack getLabels() {
                    return new LabelStack("COLUMN_HEADER_LABEL");
                }

                @Override
                public @Nullable Object getDataValue(int flags, @Nullable IProgressMonitor monitor) {
                    DataProvider labelProvider = LabelCornerLayer.this.columnHeaderLabelProvider;
                    return labelProvider != null ? labelProvider.getDataValue(0L, this.getRowPosition(), flags, monitor) : "";
                }
            };
        }
        if (columnPosition < columnCount - 1L) {
            return new BasicLayerCell(this, new BasicLayerCellDim(Orientation.HORIZONTAL, columnId, columnPosition), new BasicLayerCellDim(Orientation.VERTICAL, rowId, rowPosition)){

                @Override
                public LabelStack getLabels() {
                    return new LabelStack("ROW_HEADER_LABEL");
                }

                @Override
                public @Nullable Object getDataValue(int flags, @Nullable IProgressMonitor monitor) {
                    DataProvider labelProvider = LabelCornerLayer.this.rowHeaderLabelProvider;
                    return labelProvider != null ? labelProvider.getDataValue(this.getColumnPosition(), 0L, flags, monitor) : "";
                }
            };
        }
        return new BasicLayerCell(this, new BasicLayerCellDim(Orientation.HORIZONTAL, columnId, columnPosition), new BasicLayerCellDim(Orientation.VERTICAL, rowId, rowPosition)){

            @Override
            public LabelStack getLabels() {
                return new LabelStack("HEADER_PLACEHOLDER");
            }
        };
    }
}

