/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute;

import java.util.Iterator;
import java.util.List;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.sql.Activation;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.RoleClosureIterator;
import org.apache.derby.iapi.sql.dictionary.RoleGrantDescriptor;
import org.apache.derby.iapi.store.access.TransactionController;
import org.apache.derby.impl.sql.execute.DDLConstantAction;

class RevokeRoleConstantAction
extends DDLConstantAction {
    private List roleNames;
    private List grantees;
    private final boolean withAdminOption = false;

    public RevokeRoleConstantAction(List list, List list2) {
        this.roleNames = list;
        this.grantees = list2;
    }

    @Override
    public void executeConstantAction(Activation activation) throws StandardException {
        LanguageConnectionContext languageConnectionContext = activation.getLanguageConnectionContext();
        DataDictionary dataDictionary = languageConnectionContext.getDataDictionary();
        TransactionController transactionController = languageConnectionContext.getTransactionExecute();
        String string = languageConnectionContext.getCurrentUserId(activation);
        dataDictionary.startWriting(languageConnectionContext);
        for (String string2 : this.roleNames) {
            if (string2.equals("PUBLIC")) {
                throw StandardException.newException("4251B", new Object[0]);
            }
            for (String string3 : this.grantees) {
                RoleGrantDescriptor roleGrantDescriptor = dataDictionary.getRoleDefinitionDescriptor(string2);
                if (roleGrantDescriptor == null) {
                    throw StandardException.newException("0P000", string2);
                }
                if (!string.equals(languageConnectionContext.getDataDictionary().getAuthorizationDatabaseOwner())) {
                    throw StandardException.newException("4251A", "REVOKE role");
                }
                RoleGrantDescriptor roleGrantDescriptor2 = dataDictionary.getRoleGrantDescriptor(string2, string3, string);
                if (roleGrantDescriptor2 != null) {
                    // empty if block
                }
                if (roleGrantDescriptor2 != null) {
                    String string4;
                    RoleClosureIterator roleClosureIterator = dataDictionary.createRoleClosureIterator(activation.getTransactionController(), string2, false);
                    while ((string4 = roleClosureIterator.next()) != null) {
                        roleGrantDescriptor = dataDictionary.getRoleDefinitionDescriptor(string4);
                        dataDictionary.getDependencyManager().invalidateFor(roleGrantDescriptor, 47, languageConnectionContext);
                    }
                    roleGrantDescriptor2.drop(languageConnectionContext);
                    continue;
                }
                activation.addWarning(StandardException.newWarning("01007", string2, string3));
            }
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        Object object = this.roleNames.iterator();
        while (object.hasNext()) {
            if (stringBuffer.length() > 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(object.next().toString());
        }
        object = new StringBuffer();
        Iterator iterator = this.grantees.iterator();
        while (iterator.hasNext()) {
            if (((StringBuffer)object).length() > 0) {
                ((StringBuffer)object).append(", ");
            }
            ((StringBuffer)object).append(iterator.next().toString());
        }
        return "REVOKE " + stringBuffer.toString() + " FROM: " + ((StringBuffer)object).toString() + "\n";
    }
}

