/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.rj.servi;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.channels.Channels;
import java.nio.channels.SeekableByteChannel;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.rmi.NotBoundException;
import java.rmi.UnmarshalException;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import org.eclipse.statet.internal.rj.servi.NodeFactory;
import org.eclipse.statet.internal.rj.servi.NodeHandler;
import org.eclipse.statet.internal.rj.servi.Utils;
import org.eclipse.statet.jcommons.collections.CollectionUtils;
import org.eclipse.statet.jcommons.collections.ImCollections;
import org.eclipse.statet.jcommons.collections.ImList;
import org.eclipse.statet.jcommons.concurrent.DaemonThreadFactory;
import org.eclipse.statet.jcommons.io.FileUtils;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.lang.ObjectUtils;
import org.eclipse.statet.jcommons.lang.SystemUtils;
import org.eclipse.statet.jcommons.rmi.RMIAddress;
import org.eclipse.statet.jcommons.rmi.RMIRegistry;
import org.eclipse.statet.jcommons.runtime.CommonsRuntime;
import org.eclipse.statet.jcommons.runtime.bundle.BundleEntry;
import org.eclipse.statet.jcommons.runtime.bundle.BundleSpec;
import org.eclipse.statet.jcommons.status.Status;
import org.eclipse.statet.jcommons.status.StatusException;
import org.eclipse.statet.rj.RjException;
import org.eclipse.statet.rj.RjInvalidConfigurationException;
import org.eclipse.statet.rj.server.Server;
import org.eclipse.statet.rj.server.ServerLogin;
import org.eclipse.statet.rj.server.util.LocalREnv;
import org.eclipse.statet.rj.server.util.RJContext;
import org.eclipse.statet.rj.server.util.ServerUtils;
import org.eclipse.statet.rj.servi.node.RServiNode;
import org.eclipse.statet.rj.servi.node.RServiNodeConfig;

@NonNullByDefault
public class LocalNodeFactory
implements NodeFactory {
    public static final ImList<BundleSpec> CODEBASE_LIB_SPECS = ServerUtils.MIN_RMI_CODEBASE_SPECS;
    private static final Set<String> EXCLUDE_ENV_VAR_NAMES = ImCollections.newSet((Object[])new String[]{"CLASSPATH", "R_HOME"});
    private static final ScheduledExecutorService MONITOR_EXECUTOR = Executors.newSingleThreadScheduledExecutor((ThreadFactory)new DaemonThreadFactory("LocalNodeFactory-Monitor"));
    private static final String NODELOG_FILENAME = "out.log";
    private final String poolId;
    private final String factoryId;
    private @Nullable RServiNodeConfig baseConfig;
    private final RJContext context;
    private final ImList<BundleSpec> libSpecs;
    private @Nullable ProcessConfig processConfig;
    private @Nullable String errorMessage = null;
    private @Nullable RMIRegistry nodeRegistry;
    private boolean verbose;
    private long timeoutNanos = TimeUnit.SECONDS.toNanos(10L);
    private final List<String> sslPropertyArgs;
    private int nodeCounter;
    private static final int LOG_NODELOG_MAX = 50000;

    private static void copySystemProperty(String key, List<String> command) {
        String property = System.getProperty(key);
        if (property != null) {
            command.add("-D" + key + "=" + property);
        }
    }

    private static void copySystemPropertyPath(String key, List<String> command) {
        String property = System.getProperty(key);
        if (property != null) {
            Path path = Path.of(property, new String[0]);
            if (!path.isAbsolute()) {
                property = FileUtils.getUserWorkingDirectory().resolve(path).toString();
            }
            command.add("-D" + key + "=" + property);
        }
    }

    private static List<String> createSSLPropertyArgs() {
        ArrayList<String> args = new ArrayList<String>();
        LocalNodeFactory.copySystemPropertyPath("javax.net.ssl.keyStore", args);
        LocalNodeFactory.copySystemProperty("javax.net.ssl.keyStorePassword", args);
        LocalNodeFactory.copySystemPropertyPath("javax.net.ssl.trustStore", args);
        LocalNodeFactory.copySystemProperty("javax.net.ssl.trustStorePassword", args);
        return args;
    }

    public LocalNodeFactory(String poolId, RJContext context, List<BundleSpec> libSpecs) {
        if (poolId == null) {
            throw new NullPointerException("poolId");
        }
        if (context == null) {
            throw new NullPointerException("context");
        }
        this.poolId = poolId;
        this.factoryId = String.format("%1$s-%2$08X", poolId, ThreadLocalRandom.current().nextInt());
        this.context = context;
        this.libSpecs = ImCollections.toList(libSpecs);
        this.sslPropertyArgs = LocalNodeFactory.createSSLPropertyArgs();
    }

    @Override
    public void setRegistry(@Nullable RMIRegistry registry) {
        this.nodeRegistry = registry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setConfig(RServiNodeConfig config) throws RjInvalidConfigurationException {
        String rArch;
        String hostname;
        Path rHomeDir;
        ProcessConfig p = new ProcessConfig();
        StringBuilder sb = new StringBuilder();
        String value = config.getRHome();
        if ((value == null || value.isEmpty()) && ((value = config.getEnvironmentVariables().get("R_HOME")) == null || value.isEmpty())) {
            this.errorMessage = "Missing value for R_HOME.";
            throw new RjInvalidConfigurationException(this.errorMessage);
        }
        String rHomeString = value;
        try {
            rHomeDir = Path.of(rHomeString, new String[0]);
        }
        catch (InvalidPathException e) {
            this.errorMessage = String.format("Invalid value for R_HOME: %1$s.", e.getMessage());
            throw new RjInvalidConfigurationException(this.errorMessage);
        }
        if (!Files.isDirectory(rHomeDir, new LinkOption[0])) {
            this.errorMessage = "Invalid value for R_HOME: directory does not exists.";
            throw new RjInvalidConfigurationException(this.errorMessage);
        }
        p.addEnv.put("R_HOME", rHomeString);
        LocalREnv serverREnv = new LocalREnv(name -> {
            if (name.equals("R_HOME")) {
                return rHomeString;
            }
            return config.getEnvironmentVariables().get(name);
        });
        Path rjPkgPath = serverREnv.searchRPkg("rj");
        if (rjPkgPath == null) {
            this.errorMessage = "Can not find the R package 'rj' in the R library path:\n\t" + CollectionUtils.toString((List)serverREnv.getRLibPaths(), (String)"\n\t");
            throw new RjInvalidConfigurationException(this.errorMessage);
        }
        String javaHome = config.getJavaHome();
        if (javaHome == null || javaHome.isEmpty()) {
            javaHome = (String)ObjectUtils.nonNullAssert((Object)System.getProperty("java.home"));
        }
        p.addEnv.put("JAVA_HOME", javaHome);
        p.command.add(String.valueOf(javaHome) + File.separatorChar + "bin" + File.separatorChar + "java");
        p.command.add("-classpath");
        String s = new BundleEntry.Jar("rj-boot", rjPkgPath.resolve("server/rj-boot.jar")).getJClassPathString();
        String env = config.getEnvironmentVariables().get("CLASSPATH");
        if (env != null) {
            s = String.valueOf(s) + File.pathSeparatorChar + env;
        }
        p.command.add(s);
        String javaArgs = config.getJavaArgs();
        if (javaArgs != null && (javaArgs = javaArgs.trim()).length() > 0) {
            p.command.addAll(Utils.parseArguments(javaArgs));
        } else {
            javaArgs = "";
        }
        if (javaArgs.indexOf("-Dorg.eclipse.statet.rj.server.ClassPath.urls=") < 0) {
            List bundles;
            try {
                bundles = this.context.resolveBundles(this.libSpecs);
            }
            catch (StatusException e) {
                this.errorMessage = "Can not resolve bundles for Java classpath of node - " + e.getMessage();
                throw new RjInvalidConfigurationException(this.errorMessage, (Throwable)e);
            }
            sb.setLength(0);
            sb.append("-Dorg.eclipse.statet.rj.server.ClassPath.urls=");
            sb.append(ServerUtils.concatRJClassPath((Collection)bundles));
            p.command.add(sb.toString());
        }
        if ((hostname = System.getProperty("java.rmi.server.hostname")) != null && hostname.length() > 0) {
            p.command.add("-Djava.rmi.server.hostname=" + hostname);
        }
        if (javaArgs.indexOf("-Djava.security.policy=") < 0) {
            sb.setLength(0);
            sb.append("-Djava.security.policy=");
            sb.append(this.context.getServerPolicyFilePath());
            p.command.add(sb.toString());
        }
        if (javaArgs.indexOf("-Djava.rmi.server.codebase=") < 0) {
            List bundles;
            try {
                bundles = this.context.resolveBundles(CODEBASE_LIB_SPECS);
            }
            catch (StatusException e) {
                this.errorMessage = "Can not resolve bundles for Java codebase of node - " + e.getMessage();
                throw new RjInvalidConfigurationException(this.errorMessage, (Throwable)e);
            }
            sb.setLength(0);
            sb.append("-Djava.rmi.server.codebase=");
            sb.append(ServerUtils.concatCodebase((Collection)bundles));
            p.command.add(sb.toString());
        }
        p.command.add("RJSrv");
        p.command.add("start");
        p.nameCommandIdx = p.command.size();
        p.command.add("");
        p.command.add("-server=org.eclipse.statet.internal.rj.servi.server.NodeServer");
        p.command.add("-log");
        String nodeArgs = config.getNodeArgs();
        if (nodeArgs != null && (nodeArgs = nodeArgs.trim()).length() > 0) {
            p.command.addAll(Utils.parseArguments(nodeArgs));
        }
        if ((rArch = config.getRArch()) != null && rArch.isEmpty()) {
            rArch = null;
        }
        boolean rArchAuto = false;
        if (rArch == null && javaHome.equals(System.getProperty("java.home"))) {
            rArch = (String)ObjectUtils.nonNullAssert((Object)System.getProperty("os.arch"));
            if (rArch.equals("amd64")) {
                rArch = "x86_64";
            } else if (rArch.equals("x86")) {
                rArch = "i386";
            }
            rArchAuto = true;
        }
        if (rArch != null) {
            if (SystemUtils.getLocalOs() == 1) {
                Path binDir;
                if (rArch.equals("x86_64")) {
                    rArch = "x64";
                }
                if (!Files.isDirectory((binDir = rHomeDir.resolve("bin")).resolve(rArch), new LinkOption[0])) {
                    rArch = null;
                }
            } else {
                Path execDir = rHomeDir.resolve("bin").resolve("exec");
                if (!Files.isDirectory(execDir.resolve(rArch), new LinkOption[0])) {
                    rArch = Files.isDirectory(execDir, new LinkOption[0]) && (rArch.equals("i386") || rArch.equals("i586") || rArch.equals("i686")) ? (Files.isDirectory(execDir.resolve("i686"), new LinkOption[0]) ? "i686" : (Files.isDirectory(execDir.resolve("i586"), new LinkOption[0]) ? "i586" : (Files.isDirectory(execDir.resolve("i386"), new LinkOption[0]) ? "i386" : null))) : null;
                }
            }
            if (rArch != null) {
                p.addEnv.put("R_ARCH", String.valueOf('/') + rArch);
            } else if (!rArchAuto) {
                Utils.logInfo("Failed to validate specified architecture, value is not used.");
            }
        }
        switch (SystemUtils.getLocalOs()) {
            case 1: {
                String rBinDir = rArch != null ? String.valueOf(rHomeString) + File.separatorChar + "bin" + File.separatorChar + rArch : String.valueOf(rHomeString) + File.separatorChar + "bin";
                String pathEnv = System.getenv("PATH");
                p.addEnv.put("PATH", pathEnv != null ? String.valueOf(rBinDir) + File.pathSeparatorChar + pathEnv : rBinDir);
                break;
            }
            case 2: {
                String rBinDir = String.valueOf(rHomeString) + File.separatorChar + "bin";
                String pathEnv = System.getenv("PATH");
                p.addEnv.put("PATH", pathEnv != null ? String.valueOf(rBinDir) + File.pathSeparatorChar + pathEnv : rBinDir);
                String rLibDir = String.valueOf(rHomeString) + File.separatorChar + "lib";
                String libPathEnv = System.getenv("DYLD_LIBRARY_PATH");
                p.addEnv.put("DYLD_LIBRARY_PATH", libPathEnv != null ? String.valueOf(rLibDir) + File.pathSeparatorChar + libPathEnv : rLibDir);
                break;
            }
            default: {
                String rBinDir = String.valueOf(rHomeString) + File.separatorChar + "bin";
                String pathEnv = System.getenv("PATH");
                p.addEnv.put("PATH", pathEnv != null ? String.valueOf(rBinDir) + File.pathSeparatorChar + pathEnv : rBinDir);
                String rLibDir = rArch != null ? String.valueOf(rHomeString) + File.separatorChar + "lib" + File.separatorChar + rArch : String.valueOf(rHomeString) + File.separatorChar + "lib";
                String libPathEnv = System.getenv("LD_LIBRARY_PATH");
                p.addEnv.put("LD_LIBRARY_PATH", libPathEnv != null ? String.valueOf(rLibDir) + File.pathSeparatorChar + libPathEnv : rLibDir);
            }
        }
        String dirString = config.getBaseWorkingDirectory();
        if (dirString == null || dirString.isEmpty()) {
            dirString = (String)ObjectUtils.nonNullAssert((Object)System.getProperty("java.io.tmpdir"));
        }
        try {
            p.baseWorkingDir = this.checkBaseDir(dirString);
        }
        catch (IOException | InvalidPathException e) {
            this.errorMessage = "Invalid working directory base path.";
            throw new RjInvalidConfigurationException(this.errorMessage, (Throwable)e);
        }
        for (Map.Entry<String, String> var : config.getEnvironmentVariables().entrySet()) {
            if (EXCLUDE_ENV_VAR_NAMES.contains(var.getKey())) continue;
            p.addEnv.put(var.getKey(), var.getValue());
        }
        p.authConfig = config.getEnableConsole() ? "none" : null;
        p.rStartupSnippet = config.getRStartupSnippet();
        Duration timeout = config.getStartStopTimeout();
        LocalNodeFactory localNodeFactory = this;
        synchronized (localNodeFactory) {
            this.verbose = config.getEnableVerbose();
            this.baseConfig = config;
            this.processConfig = p;
            this.timeoutNanos = timeout != null ? timeout.toNanos() : -1L;
        }
    }

    private Path checkBaseDir(String s) throws IOException {
        Path path = Path.of(s, new String[0]);
        Files.createDirectories(path, new FileAttribute[0]);
        Path testDir = Files.createDirectory(path.resolve(String.valueOf(this.poolId) + "-test"), new FileAttribute[0]);
        Files.delete(testDir);
        return path;
    }

    @Override
    public @Nullable RServiNodeConfig getConfig() {
        return this.baseConfig;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void createNode(NodeHandler handler) throws RjException {
        StringBuilder sb;
        Exception e7;
        block63: {
            Throwable throwable;
            char[] buffer;
            ProcessBuilder processBuilder;
            int counter;
            long timeout;
            RMIRegistry registry;
            ProcessConfig p;
            long t = System.nanoTime();
            LocalNodeFactory localNodeFactory = this;
            synchronized (localNodeFactory) {
                p = this.processConfig;
                if (p == null) {
                    String string;
                    String message2 = this.errorMessage;
                    if (message2 != null) {
                        string = message2;
                        throw new RjInvalidConfigurationException(string);
                    }
                    string = "Missing R node configuration.";
                    throw new RjInvalidConfigurationException(string);
                }
                registry = this.nodeRegistry;
                if (registry == null) {
                    throw new RjInvalidConfigurationException("Missing registry configuration.");
                }
                timeout = this.timeoutNanos;
                counter = ++this.nodeCounter;
            }
            try {
                this.prepareNode(handler, p.baseWorkingDir, counter, registry);
            }
            catch (RjException e2) {
                try {
                    Thread.sleep(100L);
                    this.prepareNode(handler, p.baseWorkingDir, counter, registry);
                    this.logWarning(handler, "Preparing R node required a second attempt.", e2);
                }
                catch (InterruptedException | RjException e22) {
                    throw new RjException("Error preparing R node.", (Throwable)e2);
                }
            }
            ArrayList<String> command = null;
            try {
                command = new ArrayList<String>(p.command.size() + 2);
                command.addAll(p.command);
                command.set(p.nameCommandIdx, handler.address.toString());
                if (this.verbose) {
                    command.add("-verbose");
                }
                if (registry.getAddress().isSsl()) {
                    command.addAll(p.nameCommandIdx - 1, this.sslPropertyArgs);
                }
                processBuilder = new ProcessBuilder(command);
                processBuilder.environment().remove("Path");
                processBuilder.environment().putAll(p.addEnv);
                processBuilder.directory(handler.dir.toFile());
                processBuilder.redirectErrorStream(true);
            }
            catch (Exception e3) {
                throw new RjException("Error preparing process for R node.", (Throwable)e3);
            }
            Process process = null;
            try {
                process = processBuilder.start();
                int i = 1;
                while (true) {
                    if (i >= Integer.MAX_VALUE) {
                        return;
                    }
                    try {
                        Server server = (Server)registry.getRegistry().lookup(handler.nodeId);
                        ServerLogin login = server.createLogin("rservi.nodecontrol");
                        RServiNode node = (RServiNode)server.execute("rservi.nodecontrol", null, login);
                        this.logInfo(handler, "New R node started.", message -> message.addProp("duration(ms)", (System.nanoTime() - t) / 1000000L));
                        String line = null;
                        try {
                            String snippet = p.rStartupSnippet;
                            if (snippet != null && snippet.length() > 0) {
                                String[] lines = snippet.split("\\p{Blank}*\\r[\\n]?|\\n\\p{Blank}*");
                                int j = 0;
                                while (j < lines.length) {
                                    line = lines[j];
                                    if (line.length() > 0) {
                                        node.runSnippet(line);
                                    }
                                    ++j;
                                }
                            }
                        }
                        catch (RjException e4) {
                            try {
                                node.shutdown();
                                throw new RjException("Running the R startup snippet failed in line '" + line + "'.", (Throwable)e4);
                            }
                            catch (Exception lines) {
                                // empty catch block
                            }
                            throw new RjException("Running the R startup snippet failed in line '" + line + "'.", (Throwable)e4);
                        }
                        try {
                            handler.isConsoleEnabled = node.setConsole(p.authConfig);
                        }
                        catch (RjException e5) {
                            try {
                                node.shutdown();
                                throw e5;
                            }
                            catch (Exception lines) {
                                // empty catch block
                            }
                            throw e5;
                        }
                        handler.init2(node, process);
                        return;
                    }
                    catch (NotBoundException e6) {
                        long diff = System.nanoTime() - t;
                        if (i >= 10 && timeout >= 0L && diff > timeout) {
                            throw new RjException("Start of R node aborted because of timeout (t=" + diff / 1000000L + "ms).", (Throwable)e6);
                        }
                        try {
                            int exitValue = process.exitValue();
                            throw new RjException("R node process stopped (exit code= " + exitValue + ").");
                        }
                        catch (IllegalThreadStateException exitValue) {
                            Thread.sleep(250L);
                            ++i;
                            continue;
                        }
                    }
                    break;
                }
            }
            catch (Exception e7) {
                sb = new StringBuilder("Error starting R node:");
                if (processBuilder != null) {
                    sb.append("\n<COMMAND workingDirectory=\"").append(handler.dir).append("\">");
                    ServerUtils.prettyPrint(processBuilder.command(), (StringBuilder)sb);
                    sb.append("\n</COMMAND>");
                }
                if (process == null) break block63;
                buffer = new char[4096];
                InputStream stdout = process.getInputStream();
                sb.append("\n<STDOUT>\n");
                try {
                    Throwable line = null;
                    throwable = null;
                    try (InputStreamReader reader = new InputStreamReader(stdout);){
                        int n;
                        try {
                            while (reader.ready() && (n = reader.read(buffer, 0, buffer.length)) >= 0) {
                                sb.append(buffer, 0, n);
                            }
                        }
                        finally {
                            process.destroy();
                        }
                        while ((n = reader.read(buffer, 0, buffer.length)) >= 0) {
                            sb.append(buffer, 0, n);
                        }
                    }
                    catch (Throwable throwable2) {
                        if (line == null) {
                            line = throwable2;
                            throw line;
                        }
                        if (line == throwable2) throw line;
                        line.addSuppressed(throwable2);
                        throw line;
                    }
                }
                catch (IOException line) {
                    // empty catch block
                }
            }
            sb.append("</STDOUT>");
            Path logFile = handler.dir.resolve(NODELOG_FILENAME);
            if (Files.exists(logFile, new LinkOption[0])) {
                sb.append("\n<LOG file=\"").append(logFile).append("\">\n");
                try {
                    throwable = null;
                    Object var18_41 = null;
                    try (InputStreamReader reader = new InputStreamReader(Files.newInputStream(logFile, new OpenOption[0]), StandardCharsets.UTF_8);){
                        int n;
                        while ((n = reader.read(buffer, 0, buffer.length)) >= 0) {
                            sb.append(buffer, 0, n);
                            if (sb.length() <= 100000) continue;
                            sb.append(" ...");
                            break;
                        }
                    }
                    catch (Throwable throwable3) {
                        if (throwable == null) {
                            throwable = throwable3;
                            throw throwable;
                        }
                        if (throwable == throwable3) throw throwable;
                        throwable.addSuppressed(throwable3);
                        throw throwable;
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                if (sb.charAt(sb.length() - 1) != '\n') {
                    sb.append('\n');
                }
                sb.append("</LOG>");
            }
            sb.append("\n--------");
        }
        Thread.interrupted();
        try {
            FileUtils.deleteRecursively((Path)handler.dir);
            throw new RjException(sb.toString(), (Throwable)e7);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        throw new RjException(sb.toString(), (Throwable)e7);
    }

    protected void prepareNode(NodeHandler handler, Path baseWd, int counter, RMIRegistry registry) throws RjException {
        String id = String.format("%1$s-%2$016X-%3$08X", this.factoryId, System.nanoTime(), counter);
        Path dir = baseWd.resolve(id);
        RMIAddress rmiAddress = new RMIAddress(registry.getAddress(), id);
        try {
            handler.init1(id, rmiAddress, Files.createDirectory(dir, new FileAttribute[0]));
        }
        catch (IOException e) {
            throw new RjException(String.format("Failed to create working directory: %1$s", dir), (Throwable)e);
        }
    }

    @Override
    public void stopNode(NodeHandler handler) {
        block9: {
            Process process = handler.process;
            handler.process = null;
            AtomicInteger exitType = new AtomicInteger(0);
            try {
                if (process != null) {
                    if (!process.isAlive()) {
                        exitType.set(1);
                        this.logWarning(handler, "R node is already down (process crashed?).", message -> {
                            message.addProp("nodeExitCode", process.exitValue());
                            message.addProp("nodeLog", this.readLogTail(handler));
                        }, null);
                    } else {
                        MONITOR_EXECUTOR.schedule(() -> {
                            try {
                                if (process.isAlive()) {
                                    exitType.set(2);
                                    process.destroy();
                                    this.logWarning(handler, "Killed R node, because it did not shut down regularly.");
                                }
                            }
                            catch (Throwable e) {
                                this.logError(handler, "A runtime error occurred in StopMonitor during shutdown of R node.", e);
                            }
                        }, this.timeoutNanos, TimeUnit.NANOSECONDS);
                    }
                }
                handler.shutdown();
                if (process != null) {
                    try {
                        process.waitFor();
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
            catch (Throwable e) {
                if (exitType.get() != 0 && e instanceof UnmarshalException) break block9;
                this.logWarning(handler, "An error occurred when trying to shut down R node.", e);
            }
        }
        if (!this.verbose) {
            this.cleanupNode(handler);
        }
    }

    private void cleanupNode(NodeHandler handler) {
        block8: {
            try {
                if (!Files.isDirectory(handler.dir, new LinkOption[0])) break block8;
                int i = 0;
                while (true) {
                    try {
                        FileUtils.deleteRecursively((Path)handler.dir);
                    }
                    catch (IOException e) {
                        if (i >= 20) {
                            throw e;
                        }
                        try {
                            Thread.sleep(200L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        ++i;
                        continue;
                    }
                    break;
                }
            }
            catch (Throwable e) {
                this.logWarning(handler, "Failed to delete working directory of the R node.", message -> message.addProp("path", (Object)nodeHandler.dir), e);
            }
        }
    }

    private String readLogTail(NodeHandler handler) {
        Path logFile = handler.dir.resolve(NODELOG_FILENAME);
        try {
            long fileSize = Files.size(logFile);
            if (fileSize < 50000L) {
                return Files.readString(logFile, StandardCharsets.UTF_8).trim();
            }
            Throwable throwable = null;
            Object var6_7 = null;
            try (SeekableByteChannel channel = Files.newByteChannel(logFile, StandardOpenOption.READ);){
                int b;
                channel.position(fileSize - 50000L - 1L);
                InputStream stream = Channels.newInputStream(channel);
                while ((b = stream.read()) != -1 && b != 10) {
                }
                ByteArrayOutputStream bytes = new ByteArrayOutputStream(50000);
                stream.transferTo(bytes);
                return bytes.toString(StandardCharsets.UTF_8).trim();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            return String.format("<error: %1$s>", e.getMessage());
        }
    }

    private void log(NodeHandler handler, byte severity, String mainMessage, @Nullable Consumer<// Could not load outer class - annotation placement on inner may be incorrect
    ObjectUtils.ToStringBuilder> messageCustomizer, @Nullable Throwable e) {
        ObjectUtils.ToStringBuilder message = new ObjectUtils.ToStringBuilder(mainMessage);
        message.addProp("nodeId", handler.nodeId);
        if (messageCustomizer != null) {
            messageCustomizer.accept(message);
        }
        CommonsRuntime.log((Status)Status.newStatus((int)severity, (String)"org.eclipse.statet.rj.servi", (String)message.toString(), (Throwable)e));
    }

    private void logInfo(NodeHandler handler, String mainMessage, @Nullable Consumer<// Could not load outer class - annotation placement on inner may be incorrect
    ObjectUtils.ToStringBuilder> messageCustomizer) {
        this.log(handler, (byte)1, mainMessage, messageCustomizer, null);
    }

    private void logWarning(NodeHandler handler, String mainMessage, @Nullable Consumer<// Could not load outer class - annotation placement on inner may be incorrect
    ObjectUtils.ToStringBuilder> messageCustomizer, @Nullable Throwable e) {
        this.log(handler, (byte)2, mainMessage, messageCustomizer, e);
    }

    private void logWarning(NodeHandler handler, String mainMessage, @Nullable Throwable e) {
        this.log(handler, (byte)2, mainMessage, null, e);
    }

    private void logWarning(NodeHandler handler, String mainMessage) {
        this.log(handler, (byte)2, mainMessage, null, null);
    }

    private void logError(NodeHandler handler, String mainMessage, @Nullable Throwable e) {
        this.log(handler, (byte)4, mainMessage, null, e);
    }

    private static class ProcessConfig {
        final Map<String, String> addEnv = new HashMap<String, String>();
        final List<String> command = new ArrayList<String>();
        int nameCommandIdx = -1;
        Path baseWorkingDir;
        @Nullable String authConfig;
        @Nullable String rStartupSnippet;
    }
}

