/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.r.debug.ui.breakpoints;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IMarkerDelta;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IBreakpointsListener;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.IDebugModelPresentation;
import org.eclipse.statet.internal.r.debug.ui.Messages;
import org.eclipse.statet.jcommons.lang.Disposable;
import org.eclipse.statet.r.debug.core.breakpoints.RBreakpoint;
import org.eclipse.ui.statushandlers.StatusManager;

public class BreakpointsHelper
implements IBreakpointsListener,
Disposable {
    private final IDebugModelPresentation labelProvider = DebugUITools.newDebugModelPresentation((String)"org.eclipse.statet.r.debugModels.R");

    public BreakpointsHelper() {
        DebugPlugin.getDefault().getBreakpointManager().addBreakpointListener((IBreakpointsListener)this);
    }

    public void dispose() {
        DebugPlugin debugPlugin = DebugPlugin.getDefault();
        if (debugPlugin != null) {
            debugPlugin.getBreakpointManager().removeBreakpointListener((IBreakpointsListener)this);
        }
    }

    public void breakpointsAdded(IBreakpoint[] breakpoints) {
        if (this.containsRBreakpoint(breakpoints)) {
            new UpdateRunnable(breakpoints).exec();
        }
    }

    public void breakpointsChanged(IBreakpoint[] breakpoints, IMarkerDelta[] deltas) {
        if (this.containsRBreakpoint(breakpoints)) {
            new UpdateRunnable(breakpoints).exec();
        }
    }

    public void breakpointsRemoved(IBreakpoint[] breakpoints, IMarkerDelta[] deltas) {
    }

    private boolean containsRBreakpoint(IBreakpoint[] breakpoints) {
        int i = 0;
        while (i < breakpoints.length) {
            if (breakpoints[i] instanceof RBreakpoint) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private void updateBreakpoint(RBreakpoint breakpoint) throws CoreException {
        String typeLabel;
        String detail = this.labelProvider.getText((Object)breakpoint);
        switch (breakpoint.getBreakpointType()) {
            case "org.eclipse.statet.r.debugBreakpoints.RLineBreakpoint": {
                typeLabel = Messages.LineBreakpoint_name;
                break;
            }
            case "org.eclipse.statet.r.debugBreakpoints.RMethodBreakpoint": {
                typeLabel = Messages.MethodBreakpoint_name;
                break;
            }
            default: {
                return;
            }
        }
        IMarker marker = breakpoint.getMarker();
        if (marker != null && marker.exists()) {
            marker.setAttribute("message", (Object)(String.valueOf(typeLabel) + ": " + detail));
        }
    }

    class UpdateRunnable
    implements IWorkspaceRunnable {
        private final IBreakpoint[] breakpoints;
        private List<IStatus> errors;

        public UpdateRunnable(IBreakpoint[] breakpoints) {
            this.breakpoints = breakpoints;
        }

        public void exec() {
            try {
                ResourcesPlugin.getWorkspace().run((IWorkspaceRunnable)this, null, 0, null);
                this.log(null);
            }
            catch (CoreException e) {
                this.log(e);
            }
        }

        private void log(CoreException runError) {
            Status status = null;
            if (this.errors != null) {
                status = new MultiStatus("org.eclipse.statet.r.debug.ui", 0, this.errors.toArray(new IStatus[this.errors.size()]), "An error occurred when updating UI information of R breakpoints.", (Throwable)runError);
            } else if (runError != null) {
                status = new Status(4, "org.eclipse.statet.r.debug.ui", "An error occurred when updating UI information of R breakpoints.", (Throwable)runError);
            }
            if (status != null) {
                StatusManager.getManager().handle(status, 1);
            }
        }

        private boolean exists(IBreakpoint breakpoint) {
            try {
                IMarker marker = breakpoint.getMarker();
                return marker != null && marker.exists();
            }
            catch (Exception e) {
                return false;
            }
        }

        public void run(IProgressMonitor monitor) throws CoreException {
            int i = 0;
            while (i < this.breakpoints.length) {
                block5: {
                    if (this.breakpoints[i] instanceof RBreakpoint) {
                        try {
                            BreakpointsHelper.this.updateBreakpoint((RBreakpoint)this.breakpoints[i]);
                        }
                        catch (CoreException e) {
                            if (!this.exists(this.breakpoints[i])) break block5;
                            if (this.errors == null) {
                                this.errors = new ArrayList<IStatus>();
                            }
                            this.errors.add((IStatus)new Status(4, "org.eclipse.statet.r.debug.ui", "An error occurred when updating breakpoint message.", (Throwable)e));
                        }
                    }
                }
                ++i;
            }
        }
    }
}

