/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.waltable.freeze;

import java.util.Properties;
import java.util.StringTokenizer;
import org.eclipse.statet.ecommons.waltable.command.ILayerCommand;
import org.eclipse.statet.ecommons.waltable.config.IConfigRegistry;
import org.eclipse.statet.ecommons.waltable.coordinate.Orientation;
import org.eclipse.statet.ecommons.waltable.coordinate.PositionCoordinate;
import org.eclipse.statet.ecommons.waltable.freeze.FreezeCommandHandler;
import org.eclipse.statet.ecommons.waltable.freeze.FreezeHelper;
import org.eclipse.statet.ecommons.waltable.freeze.FreezeLayer;
import org.eclipse.statet.ecommons.waltable.freeze.IFreezeConfigAttributes;
import org.eclipse.statet.ecommons.waltable.freeze.config.DefaultFreezeGridBindings;
import org.eclipse.statet.ecommons.waltable.grid.ClientAreaResizeCommand;
import org.eclipse.statet.ecommons.waltable.grid.layer.DimensionallyDependentLayer;
import org.eclipse.statet.ecommons.waltable.layer.AbstractLayer;
import org.eclipse.statet.ecommons.waltable.layer.CompositeLayer;
import org.eclipse.statet.ecommons.waltable.layer.ILayer;
import org.eclipse.statet.ecommons.waltable.painter.cell.GraphicsUtils;
import org.eclipse.statet.ecommons.waltable.painter.layer.ILayerPainter;
import org.eclipse.statet.ecommons.waltable.selection.SelectionLayer;
import org.eclipse.statet.ecommons.waltable.style.DisplayMode;
import org.eclipse.statet.ecommons.waltable.util.GUIHelper;
import org.eclipse.statet.ecommons.waltable.viewport.ViewportLayer;
import org.eclipse.statet.ecommons.waltable.viewport.ViewportSelectDimPositionsCommandHandler;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;

public class CompositeFreezeLayer
extends CompositeLayer {
    private final FreezeLayer freezeLayer;
    private final ViewportLayer viewportLayer;
    private final SelectionLayer selectionLayer;

    public CompositeFreezeLayer(FreezeLayer freezeLayer, ViewportLayer viewportLayer, SelectionLayer selectionLayer) {
        this(freezeLayer, viewportLayer, selectionLayer, true);
    }

    public CompositeFreezeLayer(FreezeLayer freezeLayer, ViewportLayer viewportLayer, SelectionLayer selectionLayer, boolean useDefaultConfiguration) {
        super(2, 2);
        this.freezeLayer = freezeLayer;
        this.viewportLayer = viewportLayer;
        this.selectionLayer = selectionLayer;
        this.setChildLayer("FROZEN_REGION", freezeLayer, 0, 0);
        this.setChildLayer("FROZEN_ROW_REGION", new DimensionallyDependentLayer(viewportLayer.getScrollableLayer(), viewportLayer, freezeLayer), 1, 0);
        this.setChildLayer("FROZEN_COLUMN_REGION", new DimensionallyDependentLayer(viewportLayer.getScrollableLayer(), freezeLayer, viewportLayer), 0, 1);
        this.setChildLayer("NONFROZEN_REGION", viewportLayer, 1, 1);
        this.registerCommandHandlers();
        if (useDefaultConfiguration) {
            this.addConfiguration(new DefaultFreezeGridBindings());
        }
    }

    @Override
    protected ILayerPainter createPainter() {
        return new FreezableLayerPainter();
    }

    public boolean isFrozen() {
        return this.freezeLayer.isFrozen();
    }

    @Override
    public ILayerPainter getLayerPainter() {
        return this.layerPainter;
    }

    @Override
    protected void registerCommandHandlers() {
        this.registerCommandHandler(new FreezeCommandHandler(this.freezeLayer, this.viewportLayer, this.selectionLayer));
        AbstractLayer frozenRowLayer = (AbstractLayer)this.getChildLayerByLayoutCoordinate(1, 0);
        frozenRowLayer.registerCommandHandler(new ViewportSelectDimPositionsCommandHandler(frozenRowLayer, Orientation.VERTICAL));
        AbstractLayer frozenColumnLayer = (AbstractLayer)this.getChildLayerByLayoutCoordinate(0, 1);
        frozenColumnLayer.registerCommandHandler(new ViewportSelectDimPositionsCommandHandler(frozenRowLayer, Orientation.HORIZONTAL));
    }

    @Override
    public boolean doCommand(ILayerCommand command) {
        if (command instanceof ClientAreaResizeCommand) {
            this.viewportLayer.doCommand(command);
        }
        return super.doCommand(command);
    }

    @Override
    public void saveState(String prefix, Properties properties) {
        PositionCoordinate coord = this.freezeLayer.getTopLeftPosition();
        properties.setProperty(String.valueOf(prefix) + ".freezeTopLeftPosition", String.valueOf(coord.columnPosition) + "," + coord.rowPosition);
        coord = this.freezeLayer.getBottomRightPosition();
        properties.setProperty(String.valueOf(prefix) + ".freezeBottomRightPosition", String.valueOf(coord.columnPosition) + "," + coord.rowPosition);
        super.saveState(prefix, properties);
    }

    @Override
    public void loadState(String prefix, Properties properties) {
        String property = properties.getProperty(String.valueOf(prefix) + ".freezeTopLeftPosition");
        PositionCoordinate topLeftPosition = null;
        if (property != null) {
            StringTokenizer tok = new StringTokenizer(property, ",");
            String columnPosition = tok.nextToken();
            String rowPosition = tok.nextToken();
            topLeftPosition = new PositionCoordinate(this.freezeLayer, Long.valueOf(columnPosition), Long.valueOf(rowPosition));
        }
        property = properties.getProperty(String.valueOf(prefix) + ".freezeBottomRightPosition");
        PositionCoordinate bottomRightPosition = null;
        if (property != null) {
            StringTokenizer tok = new StringTokenizer(property, ",");
            String columnPosition = tok.nextToken();
            String rowPosition = tok.nextToken();
            bottomRightPosition = new PositionCoordinate(this.freezeLayer, Long.valueOf(columnPosition), Long.valueOf(rowPosition));
        }
        if (topLeftPosition != null && bottomRightPosition != null) {
            if (topLeftPosition.columnPosition == -1L && topLeftPosition.rowPosition == -1L && bottomRightPosition.columnPosition == -1L && bottomRightPosition.rowPosition == -1L) {
                FreezeHelper.unfreeze(this.freezeLayer, this.viewportLayer);
            } else {
                FreezeHelper.freeze(this.freezeLayer, this.viewportLayer, topLeftPosition, bottomRightPosition);
            }
        }
        super.loadState(prefix, properties);
    }

    class FreezableLayerPainter
    extends CompositeLayer.CompositeLayerPainter {
        public FreezableLayerPainter() {
            super(CompositeFreezeLayer.this);
        }

        @Override
        public void paintLayer(ILayer natLayer, GC gc, int xOffset, int yOffset, Rectangle rectangle, IConfigRegistry configRegistry) {
            long freezeHeight;
            super.paintLayer(natLayer, gc, xOffset, yOffset, rectangle, configRegistry);
            Color separatorColor = configRegistry.getConfigAttribute(IFreezeConfigAttributes.SEPARATOR_COLOR, DisplayMode.NORMAL, new String[0]);
            if (separatorColor == null) {
                separatorColor = GUIHelper.COLOR_BLUE;
            }
            gc.setClipping(rectangle);
            Color oldFg = gc.getForeground();
            gc.setForeground(separatorColor);
            long freezeWidth = CompositeFreezeLayer.this.freezeLayer.getWidth() - 1L;
            if (freezeWidth > 0L) {
                gc.drawLine(GraphicsUtils.safe((long)xOffset + freezeWidth), yOffset, GraphicsUtils.safe((long)xOffset + freezeWidth), GraphicsUtils.safe((long)yOffset + CompositeFreezeLayer.this.getHeight() - 1L));
            }
            if ((freezeHeight = CompositeFreezeLayer.this.freezeLayer.getHeight() - 1L) > 0L) {
                gc.drawLine(xOffset, GraphicsUtils.safe((long)yOffset + freezeHeight), GraphicsUtils.safe((long)xOffset + CompositeFreezeLayer.this.getWidth() - 1L), GraphicsUtils.safe((long)yOffset + freezeHeight));
            }
            gc.setForeground(oldFg);
        }
    }
}

