/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.rj.servi;

import java.util.concurrent.TimeUnit;
import org.apache.commons.pool2.impl.DefaultPooledObject;
import org.eclipse.statet.internal.rj.servi.APool2NodeHandler;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;

@NonNullByDefault
public class APool2NodeObject
extends DefaultPooledObject<APool2NodeHandler> {
    private volatile long lastAllocatedBeginNanos;
    private volatile long lastAllocatedEndNanos;
    private volatile long stateTime = this.getCreateTime();

    public APool2NodeObject(APool2NodeHandler object) {
        super((Object)object);
    }

    public synchronized boolean allocate() {
        if (super.allocate()) {
            this.lastAllocatedBeginNanos = System.nanoTime();
            this.stateTime = System.currentTimeMillis();
            return true;
        }
        return false;
    }

    public synchronized void markReturning() {
        switch (this.getState()) {
            case RETURNING: {
                return;
            }
            case ALLOCATED: {
                this.lastAllocatedEndNanos = System.nanoTime();
            }
        }
        this.stateTime = System.currentTimeMillis();
        super.markReturning();
    }

    public synchronized boolean deallocate() {
        switch (this.getState()) {
            case IDLE: {
                return false;
            }
            case ALLOCATED: {
                this.lastAllocatedEndNanos = System.nanoTime();
            }
            case RETURNING: {
                this.stateTime = System.currentTimeMillis();
                return super.deallocate();
            }
        }
        return false;
    }

    public synchronized void invalidate() {
        switch (this.getState()) {
            case INVALID: {
                return;
            }
            case ALLOCATED: {
                this.lastAllocatedEndNanos = System.nanoTime();
            }
        }
        this.stateTime = System.currentTimeMillis();
        super.invalidate();
    }

    public long getStateTime() {
        return this.stateTime;
    }

    public long getActiveTimeMillis() {
        if (this.getBorrowedCount() <= 0L) {
            return -1L;
        }
        long end = this.lastAllocatedEndNanos;
        long begin = this.lastAllocatedBeginNanos;
        long t = end - begin;
        if (t < 0L) {
            t = System.nanoTime() - begin;
        }
        return TimeUnit.NANOSECONDS.toMillis(t);
    }
}

