/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.r.ui.sourceediting;

import java.beans.PropertyChangeListener;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.filebuffers.IDocumentSetupParticipant;
import org.eclipse.statet.jcommons.collections.ImCollections;
import org.eclipse.statet.ltk.ui.sourceediting.SourceEditorViewerConfiguration;
import org.eclipse.statet.ltk.ui.sourceediting.SourceEditorViewerConfigurator;
import org.eclipse.statet.r.core.RCodeStyleSettings;
import org.eclipse.statet.r.core.RCoreAccess;
import org.eclipse.statet.r.core.source.RDocumentSetupParticipant;
import org.eclipse.statet.r.core.util.RCoreAccessWrapper;
import org.eclipse.statet.r.ui.sourceediting.RSourceViewerConfiguration;

public class RSourceViewerConfigurator
extends SourceEditorViewerConfigurator {
    private static final Set<String> RESET_GROUP_IDS = ImCollections.newSet((Object[])new String[]{"r/r.codestyle/indent", "statet.task_tags"});
    private RCoreAccessWrapper rCoreAccess;

    public RSourceViewerConfigurator(RCoreAccess coreAccess, RSourceViewerConfiguration config) {
        super((SourceEditorViewerConfiguration)config);
        this.rCoreAccess = new RCoreAccessWrapper(coreAccess){
            private final RCodeStyleSettings codeStyle;
            {
                this.codeStyle = new RCodeStyleSettings(1);
            }

            public RCodeStyleSettings getRCodeStyle() {
                return this.codeStyle;
            }
        };
        config.setCoreAccess((RCoreAccess)this.rCoreAccess);
        this.rCoreAccess.getRCodeStyle().load(this.rCoreAccess.getParent().getRCodeStyle());
        this.rCoreAccess.getRCodeStyle().resetDirty();
        this.rCoreAccess.getRCodeStyle().addPropertyChangeListener((PropertyChangeListener)((Object)this));
    }

    public final RCoreAccess getRCoreAccess() {
        return this.rCoreAccess;
    }

    public IDocumentSetupParticipant getDocumentSetupParticipant() {
        return new RDocumentSetupParticipant();
    }

    protected Set<String> getResetGroupIds() {
        return RESET_GROUP_IDS;
    }

    public void setSource(RCoreAccess rCoreAccess) {
        if (rCoreAccess != null) {
            this.rCoreAccess.setParent(rCoreAccess);
            this.handleSettingsChanged(null, null);
        }
    }

    public void handleSettingsChanged(Set<String> groupIds, Map<String, Object> options) {
        super.handleSettingsChanged(groupIds, options);
        this.rCoreAccess.getRCodeStyle().resetDirty();
    }

    protected void checkSettingsChanges(Set<String> groupIds, Map<String, Object> options) {
        super.checkSettingsChanges(groupIds, options);
        if (groupIds.contains("r/r.codestyle/indent") || groupIds.contains("r/r.codestyle/ws")) {
            this.rCoreAccess.getRCodeStyle().load(this.rCoreAccess.getParent().getRCodeStyle());
        }
        if (groupIds.contains("r/r.editor/options")) {
            this.updateCompleteConfig = true;
        }
        if (groupIds.contains("r/r.editor/hover")) {
            this.updateInfoHovers = true;
        }
    }
}

