/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.r.ui.pkgmanager;

import org.eclipse.core.databinding.observable.ChangeEvent;
import org.eclipse.core.databinding.observable.IChangeListener;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.statet.ecommons.databinding.jface.DataBindingSupport;
import org.eclipse.statet.ecommons.runtime.core.util.StatusUtils;
import org.eclipse.statet.ecommons.ui.components.StatusInfo;
import org.eclipse.statet.ecommons.ui.dialogs.DialogUtils;
import org.eclipse.statet.ecommons.ui.util.LayoutUtils;
import org.eclipse.statet.ecommons.ui.util.NestedServices;
import org.eclipse.statet.ecommons.ui.util.UIAccess;
import org.eclipse.statet.internal.r.ui.RUIPlugin;
import org.eclipse.statet.internal.r.ui.pkgmanager.InstallPkgFileWizard;
import org.eclipse.statet.internal.r.ui.pkgmanager.OptionsTab;
import org.eclipse.statet.internal.r.ui.pkgmanager.PkgTab;
import org.eclipse.statet.internal.r.ui.pkgmanager.RepoTab;
import org.eclipse.statet.jcommons.status.Status;
import org.eclipse.statet.jcommons.ts.core.Tool;
import org.eclipse.statet.nico.core.runtime.ToolProcess;
import org.eclipse.statet.nico.ui.util.ToolDialog;
import org.eclipse.statet.nico.ui.util.ToolInfoGroup;
import org.eclipse.statet.r.console.core.RProcess;
import org.eclipse.statet.r.core.pkgmanager.IRPkgManager;
import org.eclipse.statet.r.core.pkgmanager.IRPkgSet;
import org.eclipse.statet.r.core.pkgmanager.ISelectedRepos;
import org.eclipse.statet.r.core.renv.IREnvConfiguration;
import org.eclipse.statet.r.ui.pkgmanager.StartAction;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.eclipse.ui.services.IServiceLocator;

public class RPkgManagerDialog
extends ToolDialog
implements IChangeListener,
IRPkgManager.Listener {
    static final int APPLY_ID = 10;
    static final int INSTFILE_ID = 12;
    static final Object[] NO_INPUT = new Object[0];
    private final IRPkgManager.Ext rPkgManager;
    private Display display;
    private IStatus status;
    private TabFolder tabFolder;
    private PkgTab pkgTab;
    private RepoTab repoTab;
    private OptionsTab optionsTab;
    private Button applyButton;
    private final Object updateLock = new Object();
    private boolean updateRepos;
    private boolean updatePkgs;
    private boolean updateState;
    private int updatePage;
    private StartAction startAction;
    private NestedServices uiServices;

    public RPkgManagerDialog(IRPkgManager.Ext rPkgManager, RProcess rProcess, Shell parentShell) {
        super((ToolProcess)rProcess, parentShell, null, "R Package Manager", ToolInfoGroup.WIDE);
        this.rPkgManager = rPkgManager;
    }

    protected IDialogSettings getDialogBoundsSettings() {
        return DialogUtils.getDialogSettings((Plugin)RUIPlugin.getInstance(), (String)"pkgmanager/MainDialog");
    }

    protected RProcess getTool() {
        return (RProcess)super.getTool();
    }

    protected void setShellStyle(int newShellStyle) {
        super.setShellStyle(newShellStyle & 0xFFFEFFFF | 0x80 | 0x400);
    }

    public void create() {
        super.create();
        this.updateStatus();
    }

    protected Control createContents(Composite parent) {
        Control control = super.createContents(parent);
        this.setTitle(NLS.bind((String)"R Package Manager for ''{0}''", (Object)this.rPkgManager.getREnv().getName()));
        this.setTabFocus();
        if (this.rPkgManager.getReposStatus(null).getSeverity() != 0) {
            this.activateTab(this.repoTab.getTab());
        } else {
            this.onTabSelected(this.pkgTab.getTab());
        }
        this.display = parent.getDisplay();
        this.rPkgManager.addListener((IRPkgManager.Listener)this);
        parent.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                RPkgManagerDialog.this.rPkgManager.removeListener((IRPkgManager.Listener)RPkgManagerDialog.this);
            }
        });
        this.uiServices = new NestedServices.Dialog(this.getShell());
        this.pkgTab.createActions();
        return control;
    }

    protected final IServiceLocator getServiceLocator() {
        return this.uiServices.getLocator();
    }

    protected final PkgTab getPkgTab() {
        return this.pkgTab;
    }

    protected final RepoTab getRepoTab() {
        return this.repoTab;
    }

    protected final OptionsTab getOptionsTab() {
        return this.optionsTab;
    }

    protected Control createDialogContent(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)LayoutUtils.newCompositeGrid((int)1));
        this.tabFolder = new TabFolder(composite, 128);
        this.tabFolder.setLayoutData((Object)new GridData(4, 4, true, true));
        TabItem tabItem = new TabItem(this.tabFolder, 0);
        tabItem.setText("&Packages");
        this.pkgTab = new PkgTab(this, tabItem, (Composite)this.tabFolder, this.rPkgManager);
        tabItem.setControl((Control)this.pkgTab);
        tabItem = new TabItem(this.tabFolder, 0);
        tabItem.setText("&Repositories");
        this.repoTab = new RepoTab(this, tabItem, (Composite)this.tabFolder);
        tabItem.setControl((Control)this.repoTab);
        tabItem = new TabItem(this.tabFolder, 0);
        tabItem.setText("&Options");
        this.optionsTab = new OptionsTab(this, tabItem, (Composite)this.tabFolder);
        tabItem.setControl((Control)this.optionsTab);
        RPkgManagerDialog.applyDialogFont((Control)composite);
        DataBindingSupport databinding = new DataBindingSupport((Control)parent);
        this.addBindings(databinding);
        this.updateState = true;
        this.updatePkgs = true;
        this.updateRepos = true;
        this.update();
        this.repoTab.init();
        this.tabFolder.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RPkgManagerDialog.this.onTabSelected((TabItem)e.item);
            }
        });
        return composite;
    }

    public void activateTab(TabItem tab) {
        this.tabFolder.setSelection(tab);
        this.onTabSelected(tab);
    }

    private void onTabSelected(TabItem tab) {
        this.applyButton.setVisible(this.repoTab.getTab() == tab);
        this.checkAction();
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 12, "Install from file...", false);
        this.createButton(parent, 99, "", false).setVisible(false);
        this.applyButton = this.createButton(parent, 10, "&Apply", false);
        this.createButton(parent, 0, IDialogConstants.CLOSE_LABEL, true);
    }

    private void setTabFocus() {
        final Display display = Display.getCurrent();
        display.asyncExec(new Runnable(){

            @Override
            public void run() {
                int idx;
                if (display.getFocusControl() == RPkgManagerDialog.this.tabFolder && (idx = RPkgManagerDialog.this.tabFolder.getSelectionIndex()) >= 0) {
                    RPkgManagerDialog.this.tabFolder.getItem(idx).getControl().setFocus();
                }
            }
        });
    }

    protected void initBindings(Control control) {
    }

    int hintWidthInChars(int chars) {
        return this.convertWidthInCharsToPixels(chars);
    }

    void openPrefPage(String pageId) {
        Control content = this.getContents();
        PreferenceDialog dialog = PreferencesUtil.createPreferenceDialogOn((Shell)(content != null ? content.getShell() : null), (String)pageId, null, null);
        dialog.open();
        if (content != null) {
            content.setFocus();
        }
    }

    protected void addBindings(DataBindingSupport db) {
        this.repoTab.addBindings(db);
        this.pkgTab.addBinding(db);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void update() {
        boolean updatePkgs;
        boolean updateRepos;
        Object object = this.updateLock;
        synchronized (object) {
            updateRepos = this.updateRepos;
            this.updateRepos = false;
            updatePkgs = this.updatePkgs;
            this.updatePkgs = false;
            boolean updateState = this.updateState;
            this.updateState = false;
            if (!updateRepos && updatePkgs && !updateState) {
                return;
            }
        }
        this.rPkgManager.getReadLock().lock();
        try {
            if (updateRepos) {
                this.repoTab.updateSettings(this.rPkgManager);
            }
            if (updatePkgs) {
                this.pkgTab.updateSettings(this.rPkgManager);
                this.checkAction();
            }
            this.updateStatus();
        }
        finally {
            this.rPkgManager.getReadLock().unlock();
        }
    }

    public void handleChange(ChangeEvent event) {
        this.updateStatus();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleChange(IRPkgManager.Event event) {
        Object object = this.updateLock;
        synchronized (object) {
            this.updateRepos |= event.reposChanged() > 0;
            this.updatePkgs |= event.pkgsChanged() > 0;
            this.updatePkgs |= event.viewsChanged() > 0;
            this.updateState |= true;
        }
        if (!this.display.isDisposed()) {
            this.display.asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (UIAccess.isOkToUse((Control)RPkgManagerDialog.this.getContents())) {
                        RPkgManagerDialog.this.update();
                    }
                }
            });
        }
    }

    private void updateStatus() {
        if (!UIAccess.isOkToUse((Control)this.getContents())) {
            return;
        }
        ISelectedRepos repoSettings = this.repoTab.createRepoSettings();
        Status status = this.rPkgManager.getReposStatus(repoSettings);
        if (status.getSeverity() > 0) {
            this.setStatus(StatusUtils.convert((Status)status), this.repoTab.getTab());
            return;
        }
        this.setStatus((IStatus)new StatusInfo(0, "Install and Update R Packages"), this.pkgTab.getTab());
    }

    private void setStatus(IStatus status, TabItem tab) {
        this.status = status;
        if (!UIAccess.isOkToUse((Control)this.getButtonBar())) {
            return;
        }
        StatusInfo.applyToStatusLine((TitleAreaDialog)this, (IStatus)status);
        boolean apply = status.getSeverity() != 4;
        this.getButton(0).setEnabled(apply);
        this.getButton(10).setEnabled(apply);
        this.pkgTab.updateStatus(status);
        if (tab != null && this.updatePage >= 0 && this.updatePage == this.tabFolder.getSelectionIndex() && this.tabFolder.getItem(this.updatePage) != tab) {
            this.activateTab(tab);
        }
        this.updatePage = -1;
    }

    protected final IStatus getStatus() {
        return this.status;
    }

    protected void buttonPressed(int buttonId) {
        switch (buttonId) {
            case 10: {
                this.doApply(true);
                break;
            }
            case 12: {
                this.doInstFile();
            }
        }
        super.buttonPressed(buttonId);
    }

    void doApply(boolean forceRefresh) {
        this.rPkgManager.getWriteLock().lock();
        try {
            ISelectedRepos repoSettings = this.repoTab.createRepoSettings();
            this.rPkgManager.setSelectedRepos(repoSettings);
            if (forceRefresh) {
                this.rPkgManager.request(33792);
            }
            final int page = this.tabFolder.getSelectionIndex();
            this.display.asyncExec(new Runnable(){

                @Override
                public void run() {
                    RPkgManagerDialog.this.updatePage = page;
                }
            });
            this.rPkgManager.apply((Tool)this.getTool());
        }
        finally {
            this.rPkgManager.getWriteLock().unlock();
        }
    }

    void doInstFile() {
        IREnvConfiguration config = (IREnvConfiguration)this.rPkgManager.getREnv().get(IREnvConfiguration.class);
        if (config == null) {
            return;
        }
        InstallPkgFileWizard wizard = new InstallPkgFileWizard((Tool)this.getTool(), this.rPkgManager);
        WizardDialog dialog = new WizardDialog(this.getShell(), (IWizard)wizard);
        dialog.setBlockOnOpen(true);
        dialog.open();
    }

    protected void okPressed() {
        this.doApply(false);
        super.okPressed();
    }

    public void start(StartAction action) {
        this.startAction = action;
        if (this.pkgTab != null && this.tabFolder.getSelectionIndex() >= 0) {
            this.checkAction();
        }
    }

    private void checkAction() {
        if (this.startAction != null && this.status.getSeverity() == 0 && this.pkgTab.getPkgSet() != IRPkgSet.DUMMY) {
            StartAction action = this.startAction;
            this.startAction = null;
            switch (action.getAction()) {
                case 2: {
                    this.pkgTab.install(action.getPkgNames());
                    break;
                }
                case 3: {
                    this.pkgTab.reinstallAll();
                }
            }
        }
    }
}

