/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.r.debug.ui.preferences;

import com.ibm.icu.text.Collator;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.eclipse.core.databinding.Binding;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.beans.typed.BeanProperties;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.IValueChangeListener;
import org.eclipse.core.databinding.observable.value.ValueChangeEvent;
import org.eclipse.core.databinding.validation.ValidationStatus;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.variables.IStringVariableManager;
import org.eclipse.core.variables.VariablesPlugin;
import org.eclipse.jface.databinding.swt.typed.WidgetProperties;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.osgi.util.NLS;
import org.eclipse.statet.ecommons.databinding.jface.DataBindingSupport;
import org.eclipse.statet.ecommons.debug.core.util.LaunchUtils;
import org.eclipse.statet.ecommons.debug.ui.util.ProcessOutputCollector;
import org.eclipse.statet.ecommons.io.FileUtil;
import org.eclipse.statet.ecommons.runtime.core.util.StatusUtils;
import org.eclipse.statet.ecommons.ui.components.ButtonGroup;
import org.eclipse.statet.ecommons.ui.components.DataAdapter;
import org.eclipse.statet.ecommons.ui.components.ExtensibleTextCellEditor;
import org.eclipse.statet.ecommons.ui.dialogs.ExtStatusDialog;
import org.eclipse.statet.ecommons.ui.util.LayoutUtils;
import org.eclipse.statet.ecommons.ui.util.MessageUtils;
import org.eclipse.statet.ecommons.ui.util.VariableFilterUtils;
import org.eclipse.statet.ecommons.ui.viewers.ViewerUtils;
import org.eclipse.statet.ecommons.ui.workbench.ResourceInputComposite;
import org.eclipse.statet.internal.r.debug.ui.preferences.Messages;
import org.eclipse.statet.internal.r.ui.RUIPlugin;
import org.eclipse.statet.jcommons.collections.ImCollections;
import org.eclipse.statet.jcommons.collections.ImList;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.status.StatusException;
import org.eclipse.statet.r.core.RUtil;
import org.eclipse.statet.r.core.renv.IREnvConfiguration;
import org.eclipse.statet.r.core.renv.RLibGroupWorkingCopy;
import org.eclipse.statet.r.ui.REnvLabelProvider;
import org.eclipse.statet.r.ui.RUI;
import org.eclipse.statet.rj.renv.core.DefaultLocalConfigurator;
import org.eclipse.statet.rj.renv.core.REnvConfiguration;
import org.eclipse.statet.rj.renv.core.RLibGroup;
import org.eclipse.statet.rj.renv.core.RLibLocation;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.statushandlers.StatusManager;

public class LocalREnvConfigDialog
extends ExtStatusDialog {
    private static final String DETECT_START = "_R-Path-And-Library-Configuration_";
    private static final String DETECT_COMMAND = "cat('_R-Path-And-Library-Configuration_',Sys.getenv('R_HOME'),Sys.getenv('R_ARCH'),paste(.Library,collapse=.Platform$path.sep),paste(.Library.site,collapse=.Platform$path.sep),Sys.getenv('R_LIBS'),Sys.getenv('R_LIBS_USER'),R.home('doc'),R.home('share'),R.home('include'),R.version$arch,.Platform$OS.type,sep=intToUtf8(0x0AL));";
    private static final int DETECT_LENGTH = 12;
    private static final int DETECT_R_HOME = 1;
    private static final int DETECT_R_ARCHVAR = 2;
    private static final int DETECT_R_DEFAULT = 3;
    private static final int DETECT_R_SITE = 4;
    private static final int DETECT_R_OTHER = 5;
    private static final int DETECT_R_USER = 6;
    private static final int DETECT_R_DOC_DIR = 7;
    private static final int DETECT_R_SHARE_DIR = 8;
    private static final int DETECT_R_INCLUDE_DIR = 9;
    private static final int DETECT_R_ARCH = 10;
    private static final int DETECT_R_OS = 11;
    private static final Pattern DETECT_ITEM_PATTERN = RUtil.LINE_SEPARATOR_PATTERN;
    private static final Pattern DETECT_PATH_PATTERN = Pattern.compile(File.pathSeparator, 16);
    private final IREnvConfiguration.WorkingCopy configModel;
    private final boolean isNewConfig;
    private final Set<String> existingNames;
    private Text nameControl;
    private ResourceInputComposite rHomeControl;
    private Button loadButton;
    private Combo rArchControl;
    private TreeViewer rLibrariesViewer;
    private ButtonGroup<RLibLocation> rLibrariesButtons;
    private ResourceInputComposite rDocDirectoryControl;
    private ResourceInputComposite rShareDirectoryControl;
    private ResourceInputComposite rIncludeDirectoryControl;

    public LocalREnvConfigDialog(Shell parent, IREnvConfiguration.WorkingCopy config, boolean isNewConfig, Collection<IREnvConfiguration> existingConfigs) {
        super(parent, 1 | (isNewConfig ? 2 : 6));
        this.configModel = config;
        this.isNewConfig = isNewConfig;
        this.existingNames = new HashSet<String>();
        for (IREnvConfiguration ec : existingConfigs) {
            this.existingNames.add(ec.getName());
        }
        this.setTitle(this.isNewConfig ? Messages.REnv_Detail_AddDialog_title : Messages.REnv_Detail_Edit_Dialog_title);
    }

    public void create() {
        super.create();
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.getShell(), "org.eclipse.statet.r.ui.r_env");
    }

    protected Control createDialogArea(Composite parent) {
        Composite group;
        Composite area = new Composite(parent, 0);
        area.setLayoutData((Object)new GridData(4, 4, true, true));
        area.setLayout((Layout)LayoutUtils.newDialogGrid((int)2));
        Label label = new Label(area, 16384);
        label.setText(String.valueOf(Messages.REnv_Detail_Name_label) + ':');
        label.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        Text text = new Text(area, 2048);
        GridData gd = new GridData(4, 0x1000000, true, false);
        gd.widthHint = LayoutUtils.hintWidth((Text)text, (int)60);
        text.setLayoutData((Object)gd);
        text.setEditable(this.configModel.isEditable());
        this.nameControl = text;
        if (this.configModel.isEditable()) {
            label = new Label(area, 16384);
            label.setText(String.valueOf(Messages.REnv_Detail_Location_label) + ':');
            label.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
            this.rHomeControl = new RHomeComposite(area);
            this.rHomeControl.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        }
        LayoutUtils.addSmallFiller((Composite)area, (boolean)false);
        label = new Label(area, 16384);
        label.setText(String.valueOf(Messages.REnv_Detail_Arch_label) + ':');
        label.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        Composite composite = new Composite(area, 0);
        composite.setLayoutData((Object)new GridData(4, 4, true, false));
        composite.setLayout((Layout)LayoutUtils.newCompositeGrid((int)3));
        this.rArchControl = new Combo(composite, 4);
        gd = new GridData(4, 4, false, false);
        gd.widthHint = LayoutUtils.hintWidth((Combo)this.rArchControl, (int)8);
        this.rArchControl.setLayoutData((Object)gd);
        this.rArchControl.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int selectionIdx;
                if (!LocalREnvConfigDialog.this.rArchControl.getListVisible() && (selectionIdx = LocalREnvConfigDialog.this.rArchControl.getSelectionIndex()) >= 0) {
                    String string = LocalREnvConfigDialog.this.rArchControl.getItem(selectionIdx);
                }
            }
        });
        this.rArchControl.setEnabled(this.configModel.isEditable());
        if (this.configModel.isEditable()) {
            this.loadButton = new Button(composite, 8);
            this.loadButton.setLayoutData((Object)new GridData(131072, 4, true, false, 2, 1));
            this.loadButton.setText(Messages.REnv_Detail_DetectSettings_label);
            this.loadButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    LocalREnvConfigDialog.this.detectSettings();
                }
            });
        } else {
            LayoutUtils.addGDDummy((Composite)composite, (boolean)true, (int)2);
        }
        label = new Label(area, 16384);
        label.setText(String.valueOf(Messages.REnv_Detail_Libraries_label) + ":");
        label.setLayoutData((Object)new GridData(4, 128, false, false));
        composite = new Composite(area, 0);
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        composite.setLayout((Layout)LayoutUtils.newCompositeGrid((int)2));
        final ViewerUtils.TreeComposite treeComposite = new ViewerUtils.TreeComposite(composite, 67588);
        this.rLibrariesViewer = treeComposite.viewer;
        GridData gd2 = new GridData(4, 4, true, true);
        gd2.widthHint = LayoutUtils.hintWidth((Text)this.nameControl, (int)80);
        gd2.heightHint = LayoutUtils.hintHeight((Tree)treeComposite.tree, (int)10);
        treeComposite.setLayoutData((Object)gd2);
        treeComposite.viewer.setContentProvider((IContentProvider)new ITreeContentProvider(){

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public void dispose() {
            }

            public Object[] getElements(Object inputElement) {
                return LocalREnvConfigDialog.this.configModel.getRLibGroups().toArray();
            }

            public Object getParent(Object element) {
                if (element instanceof RLibraryContainer) {
                    return ((RLibraryContainer)element).parent;
                }
                return null;
            }

            public boolean hasChildren(Object element) {
                if (element instanceof RLibGroupWorkingCopy) {
                    return !((RLibGroupWorkingCopy)element).getLibLocations().isEmpty();
                }
                return false;
            }

            public Object[] getChildren(Object parentElement) {
                if (parentElement instanceof RLibGroupWorkingCopy) {
                    RLibGroupWorkingCopy group = (RLibGroupWorkingCopy)parentElement;
                    List libs = group.getLibLocations();
                    Object[] array = new RLibraryContainer[libs.size()];
                    int i = 0;
                    while (i < libs.size()) {
                        array[i] = new RLibraryContainer(group, (RLibLocation)libs.get(i));
                        ++i;
                    }
                    return array;
                }
                return null;
            }
        });
        TreeViewerColumn column = treeComposite.addColumn(16384, (ColumnLayoutData)new ColumnWeightData(100));
        column.setLabelProvider((CellLabelProvider)new REnvLabelProvider(){

            @Override
            public void update(ViewerCell cell) {
                Object element = cell.getElement();
                if (element instanceof RLibraryContainer) {
                    RLibLocation lib = ((RLibraryContainer)element).library;
                    cell.setImage(RUI.getImage("org.eclipse.statet.r.ui/image/obj/library.location"));
                    if (lib.getSource() != "user" && lib.getLabel() != null) {
                        cell.setText(lib.getLabel());
                    } else {
                        cell.setText(lib.getDirectory());
                    }
                    this.finishUpdate(cell);
                    return;
                }
                super.update(cell);
            }
        });
        column.setEditingSupport(new EditingSupport((ColumnViewer)treeComposite.viewer){

            protected boolean canEdit(Object element) {
                if (element instanceof RLibraryContainer) {
                    RLibraryContainer container = (RLibraryContainer)element;
                    return container.library.getSource() == "user";
                }
                return false;
            }

            protected void setValue(Object element, Object value) {
                RLibraryContainer container = (RLibraryContainer)element;
                if (container.set((String)value)) {
                    this.getViewer().refresh((Object)container, true);
                    LocalREnvConfigDialog.this.getDataBinding().updateStatus();
                }
            }

            protected Object getValue(Object element) {
                RLibraryContainer container = (RLibraryContainer)element;
                return container.library.getDirectory();
            }

            protected CellEditor getCellEditor(Object element) {
                return new ExtensibleTextCellEditor((Composite)treeComposite.tree){

                    protected Control createCustomControl(Composite parent) {
                        ResourceInputComposite chooseResourceComposite = new ResourceInputComposite(parent, 0, 10, Messages.REnv_Detail_LibraryLocation_label){

                            protected void beforeMenuAction() {
                                this.getFocusGroup().discontinueTracking();
                            }

                            protected void afterMenuAction() {
                                this.getFocusGroup().continueTracking();
                            }
                        };
                        chooseResourceComposite.setShowInsertVariable(true, (List)VariableFilterUtils.DEFAULT_NON_ITERACTIVE_FILTERS, null);
                        this.text = (Text)chooseResourceComposite.getTextControl();
                        return chooseResourceComposite;
                    }
                };
            }
        });
        treeComposite.viewer.setAutoExpandLevel(-1);
        treeComposite.viewer.setInput((Object)this.configModel);
        ViewerUtils.installDefaultEditBehaviour((TreeViewer)treeComposite.viewer);
        ViewerUtils.scheduleStandardSelection((TreeViewer)treeComposite.viewer);
        this.rLibrariesButtons = new ButtonGroup<RLibLocation>(composite){

            protected RLibLocation edit1(RLibLocation item, boolean newItem, Object parent) {
                if (newItem) {
                    return ((RLibGroupWorkingCopy)parent).newLibrary("");
                }
                return item;
            }

            public void updateState() {
                super.updateState();
                if (this.getDataAdapter().isDirty()) {
                    LocalREnvConfigDialog.this.getDataBinding().updateStatus();
                }
            }
        };
        this.rLibrariesButtons.setLayoutData((Object)new GridData(4, 4, false, true));
        this.rLibrariesButtons.addAddButton(null);
        this.rLibrariesButtons.addDeleteButton(null);
        DataAdapter.TreeAdapter<RLibLocation> adapter = new DataAdapter.TreeAdapter<RLibLocation>((ITreeContentProvider)this.rLibrariesViewer.getContentProvider(), null){

            private RLibGroupWorkingCopy getGroup(Object element) {
                if (element instanceof RLibGroupWorkingCopy) {
                    return (RLibGroupWorkingCopy)element;
                }
                return ((RLibraryContainer)element).parent;
            }

            public RLibLocation getModelItem(Object element) {
                if (element instanceof RLibraryContainer) {
                    return ((RLibraryContainer)element).library;
                }
                return (RLibLocation)element;
            }

            public Object getViewerElement(RLibLocation item, Object parent) {
                return new RLibraryContainer((RLibGroupWorkingCopy)parent, item);
            }

            public boolean isAddAllowed(Object element) {
                return !this.getGroup(element).getId().equals("r.default");
            }

            public boolean isModifyAllowed(Object element) {
                return element instanceof RLibraryContainer && ((RLibraryContainer)element).library.getSource() == "user";
            }

            public Object getAddParent(Object element) {
                return this.getGroup(element);
            }

            public List<? extends RLibLocation> getContainerFor(Object element) {
                if (element instanceof RLibGroup) {
                    return ((RLibGroup)element).getLibLocations();
                }
                return ((RLibraryContainer)element).parent.getLibLocations();
            }
        };
        this.rLibrariesButtons.connectTo((StructuredViewer)this.rLibrariesViewer, (DataAdapter)adapter);
        if (this.configModel.isEditable() && (group = this.createInstallDirGroup(area)) != null) {
            group.setLayoutData((Object)new GridData(4, 4, true, false, 2, 1));
        }
        LayoutUtils.addSmallFiller((Composite)area, (boolean)true);
        LocalREnvConfigDialog.applyDialogFont((Control)area);
        return area;
    }

    private Composite createInstallDirGroup(Composite parent) {
        Group composite = new Group(parent, 0);
        composite.setLayout((Layout)LayoutUtils.newGroupGrid((int)2));
        composite.setText("Advanced - Installation locations:");
        Label label = new Label((Composite)composite, 0);
        label.setText("Documentation ('R_DOC_DIR'):");
        label.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        ResourceInputComposite text = new ResourceInputComposite((Composite)composite, 0, 10, "R_DOC_DIR");
        text.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        text.setShowInsertVariable(true, (List)VariableFilterUtils.DEFAULT_NON_ITERACTIVE_FILTERS, null);
        this.rDocDirectoryControl = text;
        label = new Label((Composite)composite, 0);
        label.setText("Shared files ('R_SHARE_DIR'):");
        label.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        text = new ResourceInputComposite((Composite)composite, 0, 10, "R_SHARE_DIR");
        text.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        text.setShowInsertVariable(true, (List)VariableFilterUtils.DEFAULT_NON_ITERACTIVE_FILTERS, null);
        this.rShareDirectoryControl = text;
        label = new Label((Composite)composite, 0);
        label.setText("Include files ('R_INCLUDE_DIR'):");
        label.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        text = new ResourceInputComposite((Composite)composite, 0, 10, "R_INCLUDE_DIR");
        text.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        text.setShowInsertVariable(true, (List)VariableFilterUtils.DEFAULT_NON_ITERACTIVE_FILTERS, null);
        this.rIncludeDirectoryControl = text;
        return composite;
    }

    protected void addBindings(DataBindingSupport db) {
        db.getContext().bindValue((IObservableValue)WidgetProperties.text((int)24).observe((Widget)this.nameControl), BeanProperties.value((String)"name", String.class).observe((Object)this.configModel), new UpdateValueStrategy().setAfterGetValidator(value -> {
            String s = value.trim();
            if (s.isEmpty()) {
                return ValidationStatus.error((String)Messages.REnv_Detail_Name_error_Missing_message);
            }
            if (this.existingNames.contains(s)) {
                return ValidationStatus.error((String)Messages.REnv_Detail_Name_error_Duplicate_message);
            }
            if (s.contains("/")) {
                return ValidationStatus.error((String)Messages.REnv_Detail_Name_error_InvalidChar_message);
            }
            return ValidationStatus.ok();
        }), null);
        if (this.rHomeControl != null) {
            Binding rHomeBinding = db.getContext().bindValue(this.rHomeControl.getObservable(), BeanProperties.value((String)"RHomeDirectory", String.class).observe((Object)this.configModel), new UpdateValueStrategy().setAfterGetValidator(value -> {
                IStatus status = this.rHomeControl.getValidator().validate(value);
                if (!status.isOK()) {
                    return status;
                }
                if (!this.configModel.isValidRHomeLocation(this.rHomeControl.getResourceAsFileStore())) {
                    return ValidationStatus.error((String)Messages.REnv_Detail_Location_error_NoRHome_message);
                }
                this.updateArchs(!this.isNewConfig);
                return ValidationStatus.ok();
            }), null);
            rHomeBinding.getValidationStatus().addValueChangeListener((IValueChangeListener)new IValueChangeListener<IStatus>(){

                public void handleValueChange(ValueChangeEvent<? extends IStatus> event) {
                    IStatus status = (IStatus)event.diff.getNewValue();
                    LocalREnvConfigDialog.this.loadButton.setEnabled(status.isOK());
                }
            });
            rHomeBinding.validateTargetToModel();
        }
        db.getContext().bindValue((IObservableValue)WidgetProperties.text().observe((Widget)this.rArchControl), BeanProperties.value((String)"RArch", String.class).observe((Object)this.configModel));
        if (this.rDocDirectoryControl != null) {
            db.getContext().bindValue(this.rDocDirectoryControl.getObservable(), BeanProperties.value((String)"RDocDirectory", String.class).observe((Object)this.configModel));
            db.getContext().bindValue(this.rShareDirectoryControl.getObservable(), BeanProperties.value((String)"RShareDirectory", String.class).observe((Object)this.configModel));
            db.getContext().bindValue(this.rIncludeDirectoryControl.getObservable(), BeanProperties.value((String)"RIncludeDirectory", String.class).observe((Object)this.configModel));
        }
    }

    private String[] searchRHOME() {
        try {
            ImList locCandidates;
            IFileStore locStore;
            IStringVariableManager variables = VariablesPlugin.getDefault().getStringVariableManager();
            String loc = variables.performStringSubstitution("${env_var:R_HOME}", false);
            if (loc != null && loc.length() > 0 && (loc = this.resolve(loc)) != null && (locStore = EFS.getLocalFileSystem().getStore((IPath)new Path(loc))).fetchInfo().exists()) {
                return new String[]{loc, Messages.REnv_SystemRHome_name};
            }
            String prefixPattern = null;
            String prefixReplacement = null;
            if (Platform.getOS().startsWith("win")) {
                String baseLoc = "${env_var:PROGRAMFILES}\\R";
                IFileStore baseStore = EFS.getLocalFileSystem().getStore((IPath)new Path(variables.performStringSubstitution(baseLoc)));
                if (baseStore.fetchInfo().exists()) {
                    prefixReplacement = baseLoc;
                    prefixPattern = baseLoc = FileUtil.toString((IFileStore)baseStore);
                    Object[] names = baseStore.childNames(0, null);
                    Arrays.sort(names, 0, names.length, Collections.reverseOrder(Collator.getInstance()));
                    int i = 0;
                    while (i < names.length) {
                        names[i] = String.valueOf(baseLoc) + '\\' + (String)names[i];
                        ++i;
                    }
                    locCandidates = ImCollections.newList((Object[])names);
                } else {
                    locCandidates = ImCollections.newList();
                }
            } else {
                locCandidates = Platform.getOS().equals("macosx") ? ImCollections.newList((Object)"/Library/Frameworks/R.framework/Resources") : ImCollections.newList((Object[])new String[]{"/usr/local/lib64/R", "/usr/lib64/R", "/usr/local/lib/R", "/usr/lib/R"});
            }
            for (String loc2 : locCandidates) {
                String name;
                IFileStore locStore2;
                if ((loc2 = this.resolve(loc2)) == null || !this.configModel.isValidRHomeLocation(locStore2 = EFS.getLocalFileSystem().getStore((IPath)new Path(loc2)))) continue;
                if (prefixPattern != null && loc2.startsWith(prefixPattern)) {
                    loc2 = String.valueOf(prefixReplacement) + loc2.substring(prefixPattern.length());
                }
                if ((name = locStore2.getName()).equals("Resources")) {
                    IFileStore parent = locStore2.getParent();
                    String string = name = parent != null ? parent.getName() : null;
                }
                if (name != null) {
                    if (name.isEmpty() || name.equals("R")) {
                        name = null;
                    } else if (Character.isDigit(name.charAt(0))) {
                        name = "R " + name;
                    }
                }
                return new String[]{loc2, name};
            }
            return null;
        }
        catch (Exception e) {
            RUIPlugin.logError(-1, "Error when searching R_HOME location", e);
            return null;
        }
    }

    private String resolve(String loc) {
        try {
            java.nio.file.Path path = Paths.get(loc, new String[0]);
            path = path.toRealPath(new LinkOption[0]);
            return path.toString();
        }
        catch (IOException e2) {
            return null;
        }
    }

    private void updateArchs(boolean conservative) {
        if (this.rHomeControl == null) {
            return;
        }
        try {
            int idx;
            IFileStore rHome = this.rHomeControl.getResourceAsFileStore();
            List availableArchs = this.configModel.searchAvailableSubArchs(rHome);
            if (availableArchs == null) {
                this.rArchControl.setItems(new String[0]);
                return;
            }
            String oldArch = this.rArchControl.getText();
            this.rArchControl.setItems(availableArchs.toArray(new String[availableArchs.size()]));
            int n = idx = oldArch.length() > 0 ? availableArchs.indexOf(oldArch) : -1;
            if (idx >= 0) {
                this.rArchControl.select(idx);
            }
            if (conservative && this.rArchControl.getText().length() > 0) {
                return;
            }
            idx = availableArchs.indexOf(Platform.getOSArch());
            if (idx < 0 && Platform.getOSArch().equals("x86") && (idx = availableArchs.indexOf("i386")) < 0 && (idx = availableArchs.indexOf("i586")) < 0) {
                idx = availableArchs.indexOf("i686");
            }
            if (idx < 0) {
                idx = 0;
            }
            this.rArchControl.select(idx);
        }
        catch (Exception e) {
            this.rArchControl.setItems(new String[0]);
        }
    }

    private void detectSettings() {
        try {
            this.run(true, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    try {
                        LocalREnvConfigDialog.this.detectSettings(monitor);
                    }
                    catch (CoreException e) {
                        throw new InvocationTargetException(e);
                    }
                }
            });
        }
        catch (InvocationTargetException e) {
            String message = e.getCause() instanceof CoreException ? Messages.REnv_Detail_DetectSettings_error_message : Messages.REnv_Detail_DetectSettings_error_Unexpected_message;
            StatusManager.getManager().handle((IStatus)new Status(4, "org.eclipse.statet.r.ui", -1, message, (Throwable)e), 1);
            StatusManager.getManager().handle((IStatus)new Status(4, "org.eclipse.statet.r.ui", -1, message, e.getCause()), 2);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.rLibrariesButtons.refresh();
        this.rLibrariesViewer.expandAll();
    }

    private void detectSettings(IProgressMonitor monitor) throws CoreException {
        String[] lines;
        monitor.beginTask(Messages.REnv_Detail_DetectSettings_task, 10);
        ProcessBuilder processBuilder = new ProcessBuilder(this.configModel.getExecCommand(IREnvConfiguration.Exec.TERM));
        processBuilder.command().add("--no-save");
        processBuilder.command().add("--slave");
        processBuilder.command().add("-e");
        processBuilder.command().add(DETECT_COMMAND);
        Map<String, String> envp = processBuilder.environment();
        try {
            DefaultLocalConfigurator setup = new DefaultLocalConfigurator((REnvConfiguration)this.configModel);
            LaunchUtils.configureEnvironment(envp, null, (Map)setup.getEnvironmentsVariables(1));
        }
        catch (StatusException e) {
            throw StatusUtils.convert((StatusException)e);
        }
        monitor.worked(1);
        ProcessOutputCollector reader = new ProcessOutputCollector(processBuilder, "'Detect R settings'", monitor);
        String output = reader.collect();
        int start = output.indexOf(DETECT_START);
        if (start >= 0 && (lines = DETECT_ITEM_PATTERN.split(output.substring(start))).length == 12) {
            this.updateLibraries(this.configModel.getRLibGroup("r.default"), lines[3], lines[1]);
            RLibGroupWorkingCopy group = this.configModel.getRLibGroup("r.site");
            this.updateLibraries(group, lines[4], lines[1]);
            if (group.getLibLocations().isEmpty()) {
                group.getLibLocations().add(group.newLibrary("${r_home}/site-library"));
            }
            this.updateLibraries(this.configModel.getRLibGroup("r.common"), lines[5], lines[1]);
            this.updateLibraries(this.configModel.getRLibGroup("r.user"), lines[6], lines[1]);
            this.configModel.setRDocDirectory(this.checkDir(lines[7], lines[1]));
            this.configModel.setRShareDirectory(this.checkDir(lines[8], lines[1]));
            this.configModel.setRIncludeDirectory(this.checkDir(lines[9], lines[1]));
            if (lines[2].length() > 0) {
                this.configModel.setRArch(lines[2]);
            } else if (lines[10].length() > 0 && this.configModel.getRArch() == null) {
                this.configModel.setRArch(lines[10]);
            }
            this.configModel.setROS(lines[11]);
            return;
        }
        throw new CoreException((IStatus)new Status(4, "org.eclipse.statet.r.ui", -1, "Unexpected output:\n" + output, null));
    }

    private void updateLibraries(RLibGroupWorkingCopy group, String var, String rHome) {
        List libraries = group.getLibLocations();
        libraries.clear();
        String[] locations = DETECT_PATH_PATTERN.split(var);
        Path rHomePath = new Path(rHome);
        Path userHomePath = new Path(System.getProperty("user.home"));
        String[] stringArray = locations;
        int n = locations.length;
        int n2 = 0;
        while (n2 < n) {
            String location = stringArray[n2];
            if (!location.isEmpty()) {
                Object path = location.startsWith("~/") ? userHomePath.append(location.substring(2)) : new Path(location);
                String s = rHomePath.isPrefixOf((IPath)path) ? "${r_home}/" + path.makeRelativeTo((IPath)rHomePath).toString() : (userHomePath.isPrefixOf((IPath)path) ? "${user_home}/" + path.makeRelativeTo((IPath)userHomePath).toString() : path.toString());
                libraries.add(group.newLibrary(s));
            }
            ++n2;
        }
    }

    private String checkDir(String dir, String rHome) {
        if (dir != null && dir.length() > 0) {
            Path rHomePath = new Path(rHome);
            Path path = new Path(dir);
            if (rHomePath.isPrefixOf((IPath)path)) {
                dir = "${r_home}/" + path.makeRelativeTo((IPath)rHomePath).toString();
            }
            return dir;
        }
        return null;
    }

    private class RHomeComposite
    extends ResourceInputComposite {
        public RHomeComposite(Composite parent) {
            super(parent, 0, 10, Messages.REnv_Detail_Location_label);
            this.setShowInsertVariable(true, (List)VariableFilterUtils.DEFAULT_NON_ITERACTIVE_FILTERS, null);
        }

        protected void fillMenu(Menu menu) {
            super.fillMenu(menu);
            MenuItem item = new MenuItem(menu, 8);
            item.setText(Messages.REnv_Detail_Location_FindAuto_label);
            item.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    String[] rhome = LocalREnvConfigDialog.this.searchRHOME();
                    if (rhome != null) {
                        RHomeComposite.this.setText(rhome[0]);
                        LocalREnvConfigDialog.this.updateArchs(false);
                        String current = ((RHomeComposite)RHomeComposite.this).LocalREnvConfigDialog.this.nameControl.getText().trim();
                        if ((current.isEmpty() || current.equals("R")) && rhome[1] != null) {
                            ((RHomeComposite)RHomeComposite.this).LocalREnvConfigDialog.this.nameControl.setText(rhome[1]);
                        }
                    } else {
                        String name = Messages.REnv_Detail_Location_label;
                        MessageDialog.openInformation((Shell)RHomeComposite.this.getShell(), (String)MessageUtils.removeMnemonics((String)name), (String)NLS.bind((String)Messages.REnv_Detail_Location_FindAuto_Failed_message, (Object)name));
                    }
                    RHomeComposite.this.getTextControl().setFocus();
                }
            });
        }
    }

    private static class RLibraryContainer {
        private final RLibGroupWorkingCopy parent;
        private RLibLocation library;

        RLibraryContainer(RLibGroupWorkingCopy parent, RLibLocation library) {
            this.parent = parent;
            this.library = library;
        }

        public boolean set(String directory) {
            if (!this.library.getDirectory().equals(directory)) {
                this.library = this.parent.setLibrary(this.library, directory);
                return true;
            }
            return false;
        }

        public int hashCode() {
            return this.library.hashCode();
        }

        public boolean equals(@Nullable Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof RLibraryContainer) {
                RLibraryContainer other = (RLibraryContainer)obj;
                return this.library == other.library;
            }
            return false;
        }
    }
}

