/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.r.debug.ui;

import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.statet.ecommons.runtime.core.util.StatusUtils;
import org.eclipse.statet.ecommons.ts.ui.workbench.WorkbenchToolSessionData;
import org.eclipse.statet.ecommons.ui.util.UIAccess;
import org.eclipse.statet.internal.r.debug.ui.RLaunchingMessages;
import org.eclipse.statet.jcommons.status.Status;
import org.eclipse.statet.jcommons.ts.core.Tool;
import org.eclipse.statet.nico.core.runtime.SubmitType;
import org.eclipse.statet.nico.core.runtime.ToolController;
import org.eclipse.statet.nico.ui.NicoUI;
import org.eclipse.statet.nico.ui.NicoUITools;
import org.eclipse.statet.nico.ui.console.NIConsole;
import org.eclipse.statet.r.launching.IRCodeSubmitConnector;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.texteditor.IEditorStatusLine;

public class RControllerCodeLaunchConnector
implements IRCodeSubmitConnector {
    public static final String ID = "org.eclipse.statet.r.rCodeLaunchConnector.RNewConsoleConnector";

    @Override
    public boolean submit(final List<String> lines, boolean gotoConsole) throws CoreException {
        return this.submit(new CommandsCreator(){

            @Override
            public Status submitTo(ToolController controller) {
                return controller.submit(lines, SubmitType.EDITOR);
            }
        }, gotoConsole);
    }

    public boolean submit(CommandsCreator rCommands, boolean gotoConsole) throws CoreException {
        WorkbenchToolSessionData session = (WorkbenchToolSessionData)UIAccess.syncExecGet(() -> {
            IWorkbenchPage page = UIAccess.getActiveWorkbenchPage((boolean)true);
            return NicoUI.getToolRegistry().getActiveToolSession(page);
        });
        ToolController controller = NicoUITools.accessController((String)"R", (Tool)session.getTool());
        Status status = rCommands.submitTo(controller);
        if (status.getSeverity() >= 4) {
            throw new CoreException(StatusUtils.convert((Status)status));
        }
        NIConsole console = NicoUITools.getConsole((WorkbenchToolSessionData)session);
        if (console != null) {
            NicoUITools.showConsole((NIConsole)console, (IWorkbenchPage)session.getPage(), (boolean)gotoConsole);
        }
        return true;
    }

    @Override
    public void gotoConsole() throws CoreException {
        IEditorStatusLine statusLine;
        IWorkbenchPage page = UIAccess.getActiveWorkbenchPage((boolean)true);
        WorkbenchToolSessionData session = NicoUI.getToolRegistry().getActiveToolSession(page);
        NIConsole console = NicoUITools.getConsole((WorkbenchToolSessionData)session);
        if (console != null) {
            NicoUITools.showConsole((NIConsole)console, (IWorkbenchPage)page, (boolean)true);
            return;
        }
        IWorkbenchPart part = page.getActivePart();
        if (part != null && (statusLine = (IEditorStatusLine)part.getAdapter(IEditorStatusLine.class)) != null) {
            statusLine.setMessage(true, RLaunchingMessages.SubmitCode_error_NoRSession_message, null);
        }
        Display.getCurrent().beep();
    }

    public static interface CommandsCreator {
        public Status submitTo(ToolController var1);
    }
}

