/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.edb.core;

import java.sql.Connection;
import java.sql.Driver;
import java.sql.SQLException;
import java.util.Properties;
import javax.sql.DataSource;
import org.apache.commons.dbcp2.ConnectionFactory;
import org.apache.commons.dbcp2.DriverConnectionFactory;
import org.apache.commons.dbcp2.PoolableConnectionFactory;
import org.apache.commons.dbcp2.PoolingDataSource;
import org.apache.commons.pool2.ObjectPool;
import org.apache.commons.pool2.PooledObjectFactory;
import org.apache.commons.pool2.impl.GenericObjectPool;
import org.apache.derby.jdbc.EmbeddedDriver;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.statet.internal.ecommons.edb.core.Activator;

public class EmbeddedDB {
    private static final AbstractDB db = new DerbyDB();

    public static DataSource createConnectionPool(String uri) throws CoreException {
        return db.createConnectionPool(uri);
    }

    public static ConnectionFactory createConnectionFactory(String uri) throws CoreException {
        return db.createConnectionFactory(uri);
    }

    public static void shutdown(String uri) throws CoreException {
        db.shutdown(uri);
    }

    private static abstract class AbstractDB {
        private final String dbLabel;

        public AbstractDB(String dbLabel) {
            this.dbLabel = dbLabel;
        }

        public DataSource createConnectionPool(String uri) throws CoreException {
            ConnectionFactory connectionFactory = this.createConnectionFactory(uri);
            PoolableConnectionFactory poolableFactory = new PoolableConnectionFactory(connectionFactory, null);
            poolableFactory.setDefaultReadOnly(Boolean.valueOf(false));
            poolableFactory.setDefaultAutoCommit(Boolean.valueOf(true));
            GenericObjectPool connectionPool = new GenericObjectPool((PooledObjectFactory)poolableFactory);
            poolableFactory.setPool((ObjectPool)connectionPool);
            return new PoolingDataSource((ObjectPool)connectionPool);
        }

        public abstract ConnectionFactory createConnectionFactory(String var1) throws CoreException;

        public void shutdown(String uri) throws CoreException {
        }

        protected StringBuilder createErrorMessage(String driverName, Driver driver, String uri, String task) {
            StringBuilder message = new StringBuilder("An error occurred when " + task + " embedded DB");
            message.append(" (" + this.dbLabel + " + DBCP)");
            message.append("\n\tDB ConnectionURL=").append(uri);
            message.append("\n\tDriver Name=").append(driverName);
            if (driver != null) {
                message.append(", Version=").append(driver.getMajorVersion()).append('.').append(driver.getMinorVersion());
            }
            return message;
        }

        public String toString() {
            return this.dbLabel;
        }
    }

    private static class DerbyDB
    extends AbstractDB {
        private static String DERBY_HOME_PROP = "derby.system.home";
        private static String DRIVER_NAME = "org.apache.derby.jdbc.EmbeddedDriver";

        public DerbyDB() {
            super("Derby");
        }

        @Override
        public ConnectionFactory createConnectionFactory(String uri) throws CoreException {
            if (System.getProperty(DERBY_HOME_PROP) == null) {
                IPath location = Activator.getInstance().getStateLocation();
                System.setProperty(DERBY_HOME_PROP, location.toOSString());
            }
            String driverName = DRIVER_NAME;
            String dbUrl = "jdbc:derby:" + uri;
            Properties info = new Properties();
            info.setProperty("create", "true");
            EmbeddedDriver driver = null;
            try {
                driver = new EmbeddedDriver();
                Connection connection = driver.connect(dbUrl, info);
                connection.close();
                return new DriverConnectionFactory((Driver)driver, "jdbc:derby:" + uri, null);
            }
            catch (Exception e) {
                StringBuilder message = this.createErrorMessage(driverName, (Driver)driver, uri, "loading");
                throw new CoreException((IStatus)new Status(4, "org.eclipse.statet.ecommons.edb.core", -1, message.toString(), (Throwable)e));
            }
        }

        @Override
        public void shutdown(String uri) throws CoreException {
            if (System.getProperty(DERBY_HOME_PROP) == null) {
                return;
            }
            String driverName = DRIVER_NAME;
            String dbUrl = "jdbc:derby:" + uri + ";shutdown=true";
            EmbeddedDriver driver = null;
            try {
                driver = new EmbeddedDriver();
                Connection connection = driver.connect(dbUrl, null);
                connection.close();
            }
            catch (Exception e) {
                if (e instanceof SQLException && "08006".equals(((SQLException)e).getSQLState())) {
                    return;
                }
                StringBuilder message = this.createErrorMessage(driverName, (Driver)driver, uri, "closing");
                throw new CoreException((IStatus)new Status(4, "org.eclipse.statet.ecommons.edb.core", -1, message.toString(), (Throwable)e));
            }
        }
    }
}

