/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.redocs.wikitext.r.textile.core;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.statet.docmlet.wikitext.core.WikitextProblemReporter;
import org.eclipse.statet.docmlet.wikitext.core.model.WikidocSourceUnitModelInfo;
import org.eclipse.statet.docmlet.wikitext.core.model.WikitextSourceUnit;
import org.eclipse.statet.internal.redocs.wikitext.r.textile.Messages;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.text.core.TextLineInformation;
import org.eclipse.statet.ltk.core.SourceContent;
import org.eclipse.statet.ltk.issues.core.BasicProblem;
import org.eclipse.statet.ltk.issues.core.Problem;
import org.eclipse.statet.ltk.issues.core.ProblemRequestor;

@NonNullByDefault
public class TextileValidator
extends WikitextProblemReporter {
    private static final Pattern BLOCK_START_PATTERN = Pattern.compile("\\A((?:bc|bq|pre|table|p)\\.\\.?+)(.)?");

    public void run(WikitextSourceUnit su, SourceContent sourceContent, WikidocSourceUnitModelInfo model, ProblemRequestor requestor, int level, IProgressMonitor monitor) {
        if (sourceContent.getStartOffset() != 0) {
            throw new UnsupportedOperationException();
        }
        Matcher matcher = BLOCK_START_PATTERN.matcher(sourceContent.getString());
        TextLineInformation lines = sourceContent.getStringLines();
        int startOffset = 0;
        int line = 0;
        while (line < lines.getNumberOfLines()) {
            String followingCharacter;
            int endOffset = lines.getEndOffset(line);
            matcher.region(startOffset, endOffset);
            if (matcher.find() && ((followingCharacter = matcher.group(2)) == null || !followingCharacter.equals(" "))) {
                String matched = matcher.group(1);
                requestor.acceptProblems((Problem)new BasicProblem("Wikidoc", 1, 0, NLS.bind((String)Messages.Validation_BlockWhitespace_message, (Object)matched), line, startOffset, matcher.end(1)));
            }
            startOffset = endOffset;
            ++line;
        }
    }
}

