/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ltk.ui.sourceediting;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.information.IInformationProvider;
import org.eclipse.jface.text.information.IInformationProviderExtension;
import org.eclipse.jface.text.information.IInformationProviderExtension2;
import org.eclipse.statet.ecommons.text.core.JFaceTextRegion;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.text.core.TextRegion;
import org.eclipse.statet.ltk.model.core.LtkModelUtils;
import org.eclipse.statet.ltk.model.core.element.SourceStructElement;
import org.eclipse.statet.ltk.model.core.element.SourceUnit;
import org.eclipse.statet.ltk.model.core.element.SourceUnitModelInfo;
import org.eclipse.statet.ltk.ui.sourceediting.SourceEditor;

@NonNullByDefault
public abstract class QuickInformationProvider
implements IInformationProvider,
IInformationProviderExtension,
IInformationProviderExtension2 {
    private final SourceEditor editor;
    private final String modelTypeId;
    private final String commandId;
    private @Nullable IInformationControlCreator creator;

    private static String textOperation2commandId(int operation) {
        switch (operation) {
            case 51: {
                return "org.eclipse.statet.ltk.commands.ShowQuickSourceOutline";
            }
            case 52: {
                return "org.eclipse.statet.ltk.commands.ShowQuickElementOutline";
            }
            case 53: {
                return "org.eclipse.statet.ltk.commands.ShowQuickElementHierarchy";
            }
        }
        throw new UnsupportedOperationException(Integer.toString(operation));
    }

    public QuickInformationProvider(SourceEditor editor, String modelType, int textOperation) {
        this(editor, modelType, QuickInformationProvider.textOperation2commandId(textOperation));
    }

    public QuickInformationProvider(SourceEditor editor, String modelType, String commandId) {
        this.editor = editor;
        this.modelTypeId = modelType;
        this.commandId = commandId;
    }

    public SourceEditor getEditor() {
        return this.editor;
    }

    public final String getCommandId() {
        return this.commandId;
    }

    public final String getModelTypeId() {
        return this.modelTypeId;
    }

    public IRegion getSubject(ITextViewer textViewer, int offset) {
        return new Region(offset, 0);
    }

    public @Nullable String getInformation(ITextViewer textViewer, IRegion subject) {
        return null;
    }

    public @Nullable Object getInformation2(ITextViewer textViewer, IRegion subject) {
        SourceUnit su = this.editor.getSourceUnit();
        if (su == null) {
            return null;
        }
        SourceUnitModelInfo modelInfo = su.getModelInfo(this.getModelTypeId(), 2, (IProgressMonitor)new NullProgressMonitor());
        if (modelInfo == null) {
            return null;
        }
        return LtkModelUtils.getCoveringSourceElement((SourceStructElement)modelInfo.getSourceElement(), (TextRegion)JFaceTextRegion.toTextRegion((IRegion)subject));
    }

    public IInformationControlCreator getInformationPresenterControlCreator() {
        IInformationControlCreator creator = this.creator;
        if (creator == null) {
            this.creator = creator = this.createInformationPresenterControlCreator();
        }
        return creator;
    }

    protected abstract IInformationControlCreator createInformationPresenterControlCreator();
}

