/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.text.ui.settings;

import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.statet.ecommons.text.ui.settings.TextStyleManager;
import org.eclipse.swt.graphics.RGB;

public class CssTextStyleManager
extends TextStyleManager {
    private final String defaultRootKey;

    private static void appendCssColor(StringBuilder sb, RGB color) {
        sb.append('#');
        String s = Integer.toHexString(color.red);
        if (s.length() == 1) {
            sb.append('0');
        }
        sb.append(s);
        s = Integer.toHexString(color.green);
        if (s.length() == 1) {
            sb.append('0');
        }
        sb.append(s);
        s = Integer.toHexString(color.blue);
        if (s.length() == 1) {
            sb.append('0');
        }
        sb.append(s);
    }

    public CssTextStyleManager(IPreferenceStore preferenceStore, String stylesGroupId, String defaultRootKey) {
        super(preferenceStore, stylesGroupId);
        this.defaultRootKey = defaultRootKey;
    }

    @Override
    protected Object createTextAttribute(String key) {
        if (key != null) {
            if ((key = this.resolveUsedKey(key)).equals(this.defaultRootKey)) {
                return null;
            }
        } else {
            key = this.defaultRootKey;
        }
        StringBuilder sb = new StringBuilder(32);
        RGB rgb = PreferenceConverter.getColor((IPreferenceStore)this.preferenceStore, (String)(String.valueOf(key) + ".color"));
        sb.append("color: ");
        CssTextStyleManager.appendCssColor(sb, rgb);
        sb.append("; ");
        if (this.preferenceStore.getBoolean(String.valueOf(key) + ".bold")) {
            sb.append("font-weight: bold; ");
        }
        if (this.preferenceStore.getBoolean(String.valueOf(key) + ".italic")) {
            sb.append("font-style: italic; ");
        }
        boolean strikethrough = this.preferenceStore.getBoolean(String.valueOf(key) + ".strikethrough");
        boolean underline = this.preferenceStore.getBoolean(String.valueOf(key) + ".underline");
        if (strikethrough || underline) {
            sb.append("text-decoration:");
            if (strikethrough) {
                sb.append(" line-through");
            }
            if (underline) {
                sb.append(" underline");
            }
            sb.append("; ");
        }
        return sb.substring(0, sb.length() - 1);
    }
}

