/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.text.ui;

import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.statet.ecommons.ui.util.UIAccess;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Control;

@NonNullByDefault
public class TextViewerEditorColorUpdater {
    protected final ISourceViewer viewer;
    protected final IPreferenceStore preferenceStore;
    private @Nullable IPropertyChangeListener listener;

    public TextViewerEditorColorUpdater(SourceViewer viewer, IPreferenceStore preferenceStore) {
        assert (viewer != null);
        assert (preferenceStore != null);
        this.viewer = viewer;
        this.preferenceStore = preferenceStore;
        viewer.getTextWidget().addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                TextViewerEditorColorUpdater.this.dispose();
            }
        });
        this.listener = new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                if ("AbstractTextEditor.Color.Foreground".equals(event.getProperty()) || "AbstractTextEditor.Color.Foreground.SystemDefault".equals(event.getProperty()) || "AbstractTextEditor.Color.Background".equals(event.getProperty()) || "AbstractTextEditor.Color.Background.SystemDefault".equals(event.getProperty()) || "AbstractTextEditor.Color.SelectionForeground".equals(event.getProperty()) || "AbstractTextEditor.Color.SelectionForeground.SystemDefault".equals(event.getProperty()) || "AbstractTextEditor.Color.SelectionBackground".equals(event.getProperty()) || "AbstractTextEditor.Color.SelectionBackground.SystemDefault".equals(event.getProperty())) {
                    TextViewerEditorColorUpdater.this.updateColors();
                }
            }
        };
        this.preferenceStore.addPropertyChangeListener(this.listener);
        this.updateColors();
    }

    protected void updateColors() {
        ISourceViewer viewer = this.viewer;
        StyledText styledText = viewer.getTextWidget();
        if (styledText != null && !styledText.isDisposed()) {
            this.update(viewer, styledText);
        }
    }

    protected void update(ISourceViewer viewer, StyledText styledText) {
        Color color = this.preferenceStore.getBoolean("AbstractTextEditor.Color.Foreground.SystemDefault") ? null : this.createColor(this.preferenceStore, "AbstractTextEditor.Color.Foreground");
        styledText.setForeground(color);
        color = this.preferenceStore.getBoolean("AbstractTextEditor.Color.Background.SystemDefault") ? null : this.createColor(this.preferenceStore, "AbstractTextEditor.Color.Background");
        styledText.setBackground(color);
        color = this.preferenceStore.getBoolean("AbstractTextEditor.Color.SelectionForeground.SystemDefault") ? null : this.createColor(this.preferenceStore, "AbstractTextEditor.Color.SelectionForeground");
        styledText.setSelectionForeground(color);
        color = this.preferenceStore.getBoolean("AbstractTextEditor.Color.SelectionBackground.SystemDefault") ? null : this.createColor(this.preferenceStore, "AbstractTextEditor.Color.SelectionBackground");
        styledText.setSelectionBackground(color);
    }

    protected @Nullable Color createColor(IPreferenceStore store, String key) {
        RGB rgb = PreferenceConverter.getColor((IPreferenceStore)store, (String)key);
        return rgb != null ? new Color(rgb) : null;
    }

    protected void dispose() {
        StyledText styledText;
        IPropertyChangeListener listener = this.listener;
        if (listener != null) {
            this.listener = null;
            this.preferenceStore.removePropertyChangeListener(listener);
        }
        if (UIAccess.isOkToUse((Control)(styledText = this.viewer.getTextWidget()))) {
            styledText.setForeground(null);
            styledText.setBackground(null);
            styledText.setSelectionForeground(null);
            styledText.setSelectionBackground(null);
        }
    }
}

