/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.docmlet.tex.ui.editors;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentCommand;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.statet.jcommons.util.StringUtils;
import org.eclipse.ui.statushandlers.StatusManager;

class TexEditorTools {
    static void log(String message, Throwable e) {
        StatusManager.getManager().handle((IStatus)new Status(4, "org.eclipse.statet.docmlet.tex.ui", message, e));
    }

    public static int getLineLength(IDocument document, DocumentCommand command, boolean delim, int target) {
        int line;
        int length;
        block7: {
            block6: {
                length = 0;
                line = document.getLineOfOffset(command.offset) + target;
                if (line >= 0 && line < document.getNumberOfLines()) break block6;
                return 0;
            }
            length = document.getLineLength(line);
            if (length != 0) break block7;
            return 0;
        }
        try {
            if (!delim) {
                String txt = document.get(document.getLineOffset(line), document.getLineLength(line));
                String[] del = document.getLegalLineDelimiters();
                int cnt = TextUtilities.endsWith((String[])del, (String)txt);
                if (!delim && cnt > -1) {
                    length -= del[cnt].length();
                }
            }
        }
        catch (BadLocationException e) {
            TexEditorTools.log("TexEditorTools.getLineLength:", e);
        }
        return length;
    }

    public static String getStringAt(IDocument document, DocumentCommand command, boolean delim, int lineDif) {
        String line = "";
        try {
            int lineLength = delim ? TexEditorTools.getLineLength(document, command, true, lineDif) : TexEditorTools.getLineLength(document, command, false, lineDif);
            if (lineLength > 0) {
                int lineBegin = document.getLineOffset(document.getLineOfOffset(command.offset) + lineDif);
                line = document.get(lineBegin, lineLength);
            }
        }
        catch (BadLocationException e) {
            TexEditorTools.log("TexEditorTools.getStringAt", e);
        }
        return line;
    }

    public static boolean isLineCommentLine(String text) {
        return text.startsWith("%", StringUtils.firstIndexOfNonTrim((String)text));
    }

    public static int getIndexOfComment(String line) {
        int p = 0;
        int n = line.length();
        while (p < n) {
            char c = line.charAt(p);
            if (c == '%') {
                return p;
            }
            if (c == '\\') {
                ++p;
            }
            ++p;
        }
        return -1;
    }

    public static String getIndentationWithComment(String text) {
        StringBuffer indentation = new StringBuffer();
        char[] array = text.toCharArray();
        if (array.length == 0) {
            return indentation.toString();
        }
        int i = 0;
        while (i < array.length && (array[i] == ' ' || array[i] == '\t')) {
            indentation.append(array[i]);
            ++i;
        }
        if (i < array.length && array[i] == '%') {
            indentation.append("% ");
        }
        return indentation.toString();
    }

    public static String getIndentation(String text) {
        StringBuffer indentation = new StringBuffer();
        char[] array = text.toCharArray();
        int i = 0;
        while (i < array.length && (array[i] == ' ' || array[i] == '\t')) {
            indentation.append(array[i]);
            ++i;
        }
        return indentation.toString();
    }
}

