/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.jcommons.collections;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.RandomAccess;
import java.util.Set;
import java.util.Spliterator;
import org.eclipse.statet.internal.jcommons.collections.AbstractImList;
import org.eclipse.statet.internal.jcommons.collections.ImSingletonIdentityList;
import org.eclipse.statet.internal.jcommons.collections.ImSingletonList;
import org.eclipse.statet.internal.jcommons.collections.ImSingletonSpliterator;
import org.eclipse.statet.jcommons.collections.IdentitySet;
import org.eclipse.statet.jcommons.collections.ImIdentityList;
import org.eclipse.statet.jcommons.collections.ImIdentitySet;
import org.eclipse.statet.jcommons.collections.ImList;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;

@NonNullByDefault
public final class ImSingletonIdentitySet<E>
extends AbstractImList<E>
implements ImIdentitySet<E>,
RandomAccess {
    private final E e;

    public ImSingletonIdentitySet(E e) {
        this.e = e;
    }

    @Override
    public int size() {
        return 1;
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public boolean contains(@Nullable Object o) {
        return this.e == o;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        Iterator<?> e = c.iterator();
        while (e.hasNext()) {
            if (this.contains(e.next())) continue;
            return false;
        }
        return true;
    }

    @Override
    public E get(int index) {
        if (index != 0) {
            throw new IndexOutOfBoundsException("index= " + index);
        }
        return this.e;
    }

    @Override
    public int indexOf(@Nullable Object o) {
        return this.e == o ? 0 : -1;
    }

    @Override
    public int lastIndexOf(@Nullable Object o) {
        return this.e == o ? 0 : -1;
    }

    @Override
    public Iterator<E> iterator() {
        return new Iter(0);
    }

    @Override
    public Spliterator<E> spliterator() {
        return new ImSingletonSpliterator<E>(this.e);
    }

    @Override
    public Object[] toArray() {
        return new Object[]{this.e};
    }

    @Override
    public <T> T[] toArray(T[] dest) {
        if (dest.length < 1) {
            dest = (Object[])Array.newInstance(dest.getClass().getComponentType(), 1);
        }
        dest[0] = this.e;
        if (dest.length > 1) {
            dest[1] = null;
        }
        return dest;
    }

    @Override
    public void copyTo(Object[] dest, int destPos) {
        dest[destPos] = this.e;
    }

    @Override
    public void copyTo(int srcPos, Object[] dest, int destPos, int length) {
        assert (length == 1);
        dest[destPos] = this.e;
    }

    @Override
    public ImList<E> toImList() {
        return new ImSingletonList<E>(this.e);
    }

    @Override
    public ImIdentityList<E> toImIdentityList() {
        return new ImSingletonIdentityList<E>(this.e);
    }

    @Override
    public int hashCode() {
        return Objects.hashCode(this.e);
    }

    @Override
    public boolean equals(@Nullable Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof IdentitySet) {
            Set other = (Set)obj;
            return 1 == other.size() && this.contains(other.iterator().next());
        }
        return false;
    }

    public String toString() {
        return String.valueOf('[') + String.valueOf(this.e) + ']';
    }

    private class Iter
    extends AbstractImList.AbstractImListIter<E> {
        private int cursor;

        Iter(int index) {
            this.cursor = index;
        }

        @Override
        public boolean hasNext() {
            return this.cursor < 1;
        }

        @Override
        public int nextIndex() {
            return this.cursor;
        }

        @Override
        public E next() {
            if (this.cursor >= 1) {
                throw new NoSuchElementException();
            }
            ++this.cursor;
            return ImSingletonIdentitySet.this.e;
        }

        @Override
        public boolean hasPrevious() {
            return this.cursor > 0;
        }

        @Override
        public int previousIndex() {
            return this.cursor - 1;
        }

        @Override
        public E previous() {
            if (this.cursor <= 0) {
                throw new NoSuchElementException();
            }
            --this.cursor;
            return ImSingletonIdentitySet.this.e;
        }
    }
}

