/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.rtm.base.ui.rexpr;

import com.ibm.icu.text.DecimalFormat;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.statet.ecommons.graphics.core.ColorAlphaDef;
import org.eclipse.statet.ecommons.graphics.core.ColorDef;
import org.eclipse.statet.ecommons.graphics.core.HSVColorDef;
import org.eclipse.statet.ecommons.graphics.core.NamedColorDef;
import org.eclipse.statet.ecommons.graphics.core.NumberedRefColorDef;
import org.eclipse.statet.ecommons.ui.components.DoubleText;
import org.eclipse.statet.ecommons.ui.components.ObjValueEvent;
import org.eclipse.statet.jcommons.text.core.input.StringParserInput;
import org.eclipse.statet.jcommons.text.core.input.TextParserInput;
import org.eclipse.statet.r.core.model.RGraphicFunctions;
import org.eclipse.statet.r.core.rsource.ast.RParser;
import org.eclipse.statet.r.ui.graphics.RAlphaChooser;
import org.eclipse.statet.r.ui.graphics.RColorChooser;
import org.eclipse.statet.rtm.base.ui.rexpr.RExprTypeUIAdapter;
import org.eclipse.statet.rtm.base.ui.rexpr.RExprWidget;
import org.eclipse.statet.rtm.rtdata.types.RTypedExpr;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.statushandlers.StatusManager;

public class ColorType
extends RExprWidget.TypeDef
implements PaintListener,
Listener {
    private Button detail;
    private ColorDef currentValue;
    private Color currentSWTColor;
    private RColorChooser colorChooser;
    private final RGraphicFunctions rGraphicFunctions = RGraphicFunctions.DEFAULT;

    public ColorType(RExprTypeUIAdapter type) {
        super(type);
    }

    @Override
    public boolean hasDetail() {
        return true;
    }

    @Override
    protected Control createDetailControl(Composite parent) {
        this.detail = new Button(parent, 0);
        this.detail.addPaintListener((PaintListener)this);
        this.detail.addListener(13, (Listener)this);
        this.detail.addListener(12, (Listener)this);
        return this.detail;
    }

    @Override
    public void valueAboutToChange(ObjValueEvent<RTypedExpr> event) {
        RTypedExpr newExpr = (RTypedExpr)event.newValue;
        ColorDef newValue = null;
        if (newExpr != null && newExpr.getTypeKey() == "r") {
            try {
                RParser rParser = RExprWidget.getDisplayRParser();
                newValue = this.rGraphicFunctions.parseColorDef(rParser.scanExpr((TextParserInput)new StringParserInput(newExpr.getExpr()).init()));
            }
            catch (Exception e) {
                StatusManager.getManager().handle((IStatus)new Status(4, "org.eclipse.statet.rtm.base.ui", "An error occurred when parsing the R color value expression.", (Throwable)e));
            }
        }
        this.doSetValue(newValue);
        this.detail.redraw();
    }

    public void paintControl(PaintEvent e) {
        GC gc = e.gc;
        Point size = this.detail.getSize();
        gc.setForeground(gc.getDevice().getSystemColor(16));
        gc.drawRectangle(4, 4, size.x - 9, size.y - 9);
        if (this.currentValue != null) {
            if (this.currentValue instanceof ColorAlphaDef) {
                if (this.currentSWTColor == null) {
                    this.currentSWTColor = RAlphaChooser.createPreviewColor((ColorAlphaDef)((ColorAlphaDef)this.currentValue));
                }
                RAlphaChooser.drawPreview((GC)gc, (int)5, (int)5, (int)(size.x - 10), (int)(size.y - 10), (Color)this.currentSWTColor);
            } else {
                if (this.currentSWTColor == null) {
                    this.currentSWTColor = RColorChooser.createPreviewColor((ColorDef)this.currentValue);
                }
                RColorChooser.drawPreview((GC)gc, (int)5, (int)5, (int)(size.x - 11), (int)(size.y - 11), (Color)this.currentSWTColor);
            }
        }
    }

    public void handleEvent(Event event) {
        switch (event.type) {
            case 13: {
                this.showColorChooser();
                return;
            }
            case 12: {
                if (this.colorChooser != null) {
                    this.colorChooser.dispose();
                }
                return;
            }
        }
    }

    private void showColorChooser() {
        if (this.colorChooser == null) {
            this.colorChooser = new RColorChooser(){

                protected void onOK() {
                    ColorType.this.setValue(this.getValue());
                }
            };
        }
        if (this.colorChooser.isActive()) {
            this.colorChooser.close();
            return;
        }
        Rectangle bounds = this.detail.getBounds();
        Point location = this.detail.getParent().toDisplay(new Point(bounds.x, bounds.y));
        bounds.x = location.x;
        bounds.y = location.y;
        this.colorChooser.open(this.detail.getShell(), bounds, this.currentValue);
    }

    private void setValue(ColorDef value) {
        if (value == null) {
            this.setExpr("");
            return;
        }
        StringBuilder sb = new StringBuilder();
        ColorAlphaDef alpha = null;
        ColorDef color = value;
        if (value instanceof ColorAlphaDef) {
            alpha = (ColorAlphaDef)value;
            color = alpha.getRef();
            if (alpha.getAlpha() == 1.0f) {
                alpha = null;
            }
        }
        if (color instanceof NamedColorDef) {
            if (alpha != null) {
                sb.append("adjustcolor(");
            }
            sb.append('\"');
            sb.append(((NamedColorDef)color).getName());
            sb.append('\"');
            if (alpha != null) {
                DecimalFormat format = DoubleText.createFormat((int)3);
                sb.append(", ");
                sb.append(format.format((double)alpha.getAlpha()));
                sb.append(')');
            }
        } else if (color instanceof NumberedRefColorDef) {
            if (alpha != null) {
                sb.append("adjustcolor(");
            }
            sb.append(((NumberedRefColorDef)color).getNumber());
            if (alpha != null) {
                DecimalFormat format = DoubleText.createFormat((int)3);
                sb.append(", ");
                sb.append(format.format((double)alpha.getAlpha()));
                sb.append(')');
            }
        } else if (color instanceof HSVColorDef) {
            HSVColorDef hsvColor = (HSVColorDef)color;
            sb.append("hsv(");
            DecimalFormat format = DoubleText.createFormat((int)3);
            sb.append(format.format((double)hsvColor.getHue()));
            sb.append(", ");
            sb.append(format.format((double)hsvColor.getSaturation()));
            sb.append(", ");
            sb.append(format.format((double)hsvColor.getValue()));
            if (alpha != null) {
                sb.append(", ");
                sb.append(format.format((double)alpha.getAlpha()));
            }
            sb.append(')');
        } else {
            sb.append('\"');
            sb.append('#');
            if (alpha != null) {
                alpha.printRGBAHex(sb);
            } else {
                value.printRGBHex(sb);
            }
            sb.append('\"');
        }
        this.doSetValue(value);
        this.detail.redraw();
        this.setExpr(sb.toString());
    }

    private void doSetValue(ColorDef value) {
        if (this.currentSWTColor != null && !this.currentValue.equals((Object)value)) {
            this.currentSWTColor = null;
        }
        this.currentValue = value;
    }
}

