/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ltk.issues.core.impl;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.lang.ObjectUtils;
import org.eclipse.statet.ltk.core.SourceContent;
import org.eclipse.statet.ltk.issues.core.TaskPriority;
import org.eclipse.statet.ltk.issues.core.TaskTag;

@NonNullByDefault
public class TaskMarkerHandler {
    private final String markerId;
    private @Nullable Pattern taskTagPattern;
    private final Map<String, TaskPriority> taskTagMap = new HashMap<String, TaskPriority>();
    private SourceContent sourceContent;
    private IResource resource;
    private @Nullable Matcher taskTagMatcher;

    public TaskMarkerHandler(String markerId) {
        this.markerId = markerId;
    }

    protected void initTaskPattern(List<TaskTag> taskTags) {
        this.taskTagPattern = null;
        this.taskTagMap.clear();
        if (taskTags.isEmpty()) {
            return;
        }
        String separatorRegex = "[^\\p{L}\\p{N}]";
        StringBuilder regex = new StringBuilder("[^\\p{L}\\p{N}]");
        regex.append('(');
        for (TaskTag taskTag : taskTags) {
            regex.append(Pattern.quote(taskTag.getKeyword()));
            regex.append('|');
            this.taskTagMap.put(taskTag.getKeyword(), taskTag.getPriority());
        }
        regex.setCharAt(regex.length() - 1, ')');
        regex.append("(?:\\z|").append("[^\\p{L}\\p{N}]").append(")");
        this.taskTagPattern = Pattern.compile(regex.toString());
    }

    public void setup(SourceContent sourceContent, IResource resource) {
        this.sourceContent = sourceContent;
        this.resource = resource;
        Pattern taskTagPattern = this.taskTagPattern;
        this.taskTagMatcher = taskTagPattern != null && sourceContent.getStartOffset() == 0 ? taskTagPattern.matcher(sourceContent.getString()) : null;
    }

    public void addTaskMarker(String message, int offset, int lineNumber, String match) throws CoreException {
        TaskPriority prio = this.taskTagMap.get(match);
        if (prio == null) {
            return;
        }
        HashMap<String, Object> attributes = new HashMap<String, Object>();
        attributes.put("message", message);
        attributes.put("priority", prio.getMarkerPriority());
        attributes.put("lineNumber", lineNumber > 0 ? lineNumber : 1);
        if (offset != -1) {
            attributes.put("charStart", offset);
            attributes.put("charEnd", offset + message.length());
        }
        attributes.put("userEditable", false);
        this.resource.createMarker(this.markerId, attributes);
    }

    public void removeTaskMarkers() throws CoreException {
        this.resource.deleteMarkers(this.markerId, false, 2);
    }

    public void checkForTasks(int startOffset, int endOffset) throws CoreException, BadLocationException {
        Matcher matcher = this.taskTagMatcher;
        if (matcher == null) {
            return;
        }
        if (matcher.region(startOffset, endOffset).find()) {
            int taskStartOffset = matcher.start(1);
            String text = this.sourceContent.getString(taskStartOffset, endOffset);
            this.addTaskMarker(text, taskStartOffset, this.sourceContent.getStringLines().getLineOfOffset(taskStartOffset) + 1, (String)ObjectUtils.nonNullAssert((Object)matcher.group(1)));
        }
    }
}

