/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.text;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.text.AbstractDocument;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.BadPartitioningException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.Region;
import org.eclipse.statet.ecommons.text.core.PartitionConstraint;

public class TextUtil {
    public static final Pattern LINE_DELIMITER_PATTERN = Pattern.compile("\\r[\\n]?|\\n");
    private static final IScopeContext PLATFORM_SCOPE = InstanceScope.INSTANCE;
    public static final Comparator<Position> POSITION_COMPARATOR = new PositionComparator();

    public static final String getPlatformLineDelimiter() {
        String lineDelimiter = Platform.getPreferencesService().getString("org.eclipse.core.runtime", "line.separator", null, new IScopeContext[]{PLATFORM_SCOPE});
        if (lineDelimiter != null) {
            return lineDelimiter;
        }
        return System.lineSeparator();
    }

    public static String getLineDelimiter(IProject project) {
        String lineSeparator;
        if (project != null && (lineSeparator = Platform.getPreferencesService().getString("org.eclipse.core.runtime", "line.separator", null, new IScopeContext[]{new ProjectScope(project.getProject()), PLATFORM_SCOPE})) != null) {
            return lineSeparator;
        }
        return TextUtil.getPlatformLineDelimiter();
    }

    public static final int overlaps(int reg1Start, int reg1End, int reg2Start, int reg2End) {
        if (reg1Start <= reg2Start) {
            if (reg2End < reg1End) {
                return reg2End - reg2Start;
            }
            return reg1End - reg2Start;
        }
        if (reg1End < reg2End) {
            return reg1End - reg1Start;
        }
        return reg2End - reg1Start;
    }

    public static ArrayList<String> toLines(String text) {
        ArrayList<String> lines = new ArrayList<String>(2 + text.length() / 30);
        TextUtil.addLines(text, lines);
        return lines;
    }

    public static void addLines(String text, List<String> lines) {
        int n = text.length();
        int i = 0;
        int lineStart = 0;
        while (i < n) {
            switch (text.charAt(i)) {
                case '\r': {
                    lines.add(text.substring(lineStart, i));
                    if (++i >= n || text.charAt(i) == '\n') {
                        // empty if block
                    }
                    lineStart = ++i;
                    break;
                }
                case '\n': {
                    lines.add(text.substring(lineStart, i));
                    if (++i >= n || text.charAt(i) == '\r') {
                        // empty if block
                    }
                    lineStart = ++i;
                    break;
                }
                default: {
                    ++i;
                }
            }
        }
        if (lineStart < n) {
            lines.add(text.substring(lineStart, n));
        }
    }

    public static final void addLines(IDocument document, int offset, int length, ArrayList<String> lines) throws BadLocationException {
        int startLine = document.getLineOfOffset(offset);
        int endLine = document.getLineOfOffset(offset + length);
        lines.ensureCapacity(lines.size() + endLine - startLine + 1);
        if (startLine > endLine) {
            throw new IllegalArgumentException();
        }
        if (startLine == endLine) {
            IRegion lineInfo = document.getLineInformation(endLine);
            lines.add(document.get(offset, length));
            return;
        }
        IRegion lineInfo = document.getLineInformation(startLine);
        lines.add(document.get(offset, Math.max(0, lineInfo.getOffset() + lineInfo.getLength() - offset)));
        int line = startLine + 1;
        while (line < endLine) {
            lineInfo = document.getLineInformation(line);
            lines.add(document.get(lineInfo.getOffset(), lineInfo.getLength()));
            ++line;
        }
        lineInfo = document.getLineInformation(endLine);
        if (offset + length > lineInfo.getOffset()) {
            lines.add(document.get(lineInfo.getOffset(), offset + length - lineInfo.getOffset()));
        }
    }

    public static final IRegion getBlock(IDocument document, int position1, int position2) throws BadLocationException {
        int line2;
        int line1 = document.getLineOfOffset(position1);
        if (line1 < (line2 = document.getLineOfOffset(position2)) && document.getLineOffset(line2) == position2) {
            --line2;
        }
        int start = document.getLineOffset(line1);
        int length = document.getLineOffset(line2) + document.getLineLength(line2) - start;
        return new Region(start, length);
    }

    public static final int getColumn(IDocument document, int offset, int line, int tabWidth) throws BadLocationException {
        if (offset > document.getLength()) {
            return -1;
        }
        if (line < 0) {
            line = document.getLineOfOffset(offset);
        }
        if (tabWidth <= 0) {
            tabWidth = 8;
        }
        int currentColumn = 0;
        int currentOffset = document.getLineOffset(line);
        while (currentOffset < offset) {
            char c = document.getChar(currentOffset++);
            switch (c) {
                case '\n': 
                case '\r': {
                    return -1;
                }
                case '\t': {
                    currentColumn += tabWidth - currentColumn % tabWidth;
                    break;
                }
                default: {
                    ++currentColumn;
                }
            }
        }
        return currentColumn;
    }

    public static final int getColumn(String text, int offset, int tabWidth) {
        if (offset > text.length()) {
            return -1;
        }
        if (tabWidth <= 0) {
            tabWidth = 8;
        }
        int currentColumn = 0;
        int currentOffset = 0;
        while (currentOffset < offset) {
            char c = text.charAt(currentOffset++);
            switch (c) {
                case '\n': 
                case '\r': {
                    return -1;
                }
                case '\t': {
                    currentColumn += tabWidth - currentColumn % tabWidth;
                    break;
                }
                default: {
                    ++currentColumn;
                }
            }
        }
        return currentColumn;
    }

    public static final int countBackward(IDocument document, int offset, char c) throws BadLocationException {
        int count = 0;
        while (offset > 0 && document.getChar(--offset) == c) {
            ++count;
        }
        return count;
    }

    public static final int countForward(IDocument document, int offset, char c) throws BadLocationException {
        int count = 0;
        int length = document.getLength();
        while (offset < length && document.getChar(offset++) == c) {
            ++count;
        }
        return count;
    }

    public static List<IRegion> getMatchingRegions(AbstractDocument document, String partitioning, PartitionConstraint contraint, IRegion region, boolean extend) throws BadLocationException, BadPartitioningException {
        ITypedRegion partition;
        ArrayList<IRegion> regions = new ArrayList<IRegion>();
        int regionEnd = region.getOffset() + region.getLength();
        int validBegin = -1;
        int offset = region.getOffset();
        if (extend && offset > 0) {
            partition = document.getPartition(partitioning, offset - 1, false);
            if (contraint.matches(partition.getType())) {
                ITypedRegion prevPartition;
                offset = partition.getOffset();
                while (contraint.matches((prevPartition = document.getPartition(partitioning, offset - 1, false)).getType()) && (offset = prevPartition.getOffset()) > 0) {
                }
                validBegin = offset;
            }
            offset = partition.getOffset() + partition.getLength();
        }
        do {
            partition = document.getPartition(partitioning, offset, false);
            if (validBegin < 0) {
                if (!contraint.matches(partition.getType())) continue;
                validBegin = partition.getOffset();
                continue;
            }
            if (contraint.matches(partition.getType())) continue;
            regions.add((IRegion)new Region(validBegin, offset - validBegin));
            validBegin = -1;
        } while ((offset = partition.getOffset() + partition.getLength()) < regionEnd);
        if (validBegin >= 0) {
            if (extend) {
                while (contraint.matches((partition = document.getPartition(partitioning, offset, false)).getType()) && (offset = partition.getOffset() + partition.getLength()) < document.getLength()) {
                }
            }
            regions.add((IRegion)new Region(validBegin, offset - validBegin));
        }
        return regions;
    }

    private static class PositionComparator
    implements Comparator<Position> {
        private PositionComparator() {
        }

        @Override
        public int compare(Position o1, Position o2) {
            int diff = o1.offset - o2.offset;
            if (diff != 0) {
                return diff;
            }
            return o1.length - o2.length;
        }
    }
}

