/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.waltable.painter.layer;

import org.eclipse.statet.ecommons.waltable.config.IConfigRegistry;
import org.eclipse.statet.ecommons.waltable.coordinate.LRectangle;
import org.eclipse.statet.ecommons.waltable.coordinate.Orientation;
import org.eclipse.statet.ecommons.waltable.layer.ILayer;
import org.eclipse.statet.ecommons.waltable.layer.ILayerDim;
import org.eclipse.statet.ecommons.waltable.painter.cell.GraphicsUtils;
import org.eclipse.statet.ecommons.waltable.painter.layer.CellLayerPainter;
import org.eclipse.statet.ecommons.waltable.util.GUIHelper;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;

public class GridLineCellLayerPainter
extends CellLayerPainter {
    private final Color gridColor;

    public GridLineCellLayerPainter(Color gridColor) {
        this.gridColor = gridColor;
    }

    public GridLineCellLayerPainter() {
        this.gridColor = GUIHelper.COLOR_GRAY;
    }

    public Color getGridColor() {
        return this.gridColor;
    }

    @Override
    public void paintLayer(ILayer natLayer, GC gc, int xOffset, int yOffset, Rectangle pixelRectangle, IConfigRegistry configRegistry) {
        this.drawGridLines(natLayer, gc, pixelRectangle);
        super.paintLayer(natLayer, gc, xOffset, yOffset, pixelRectangle, configRegistry);
    }

    @Override
    public LRectangle adjustCellBounds(long columnPosition, long rowPosition, LRectangle bounds) {
        return new LRectangle(bounds.x, bounds.y, Math.max(bounds.width - 1L, 0L), Math.max(bounds.height - 1L, 0L));
    }

    protected void drawGridLines(ILayer natLayer, GC gc, Rectangle rectangle) {
        gc.setForeground(this.gridColor);
        this.drawHorizontalLines(natLayer, gc, rectangle);
        this.drawVerticalLines(natLayer, gc, rectangle);
    }

    private void drawHorizontalLines(ILayer natLayer, GC gc, Rectangle rectangle) {
        int startX = GraphicsUtils.safe(rectangle.x);
        int endX = GraphicsUtils.safe((long)rectangle.x + Math.min(natLayer.getWidth() - 1L, (long)rectangle.width));
        ILayerDim dim = natLayer.getDim(Orientation.VERTICAL);
        long endPosition = Math.min(dim.getPositionCount(), dim.getPositionByPixel(rectangle.y + rectangle.height - 1) + 1L);
        long position = dim.getPositionByPixel(rectangle.y);
        while (position < endPosition) {
            int size = dim.getPositionSize(position);
            if (size > 0) {
                int y = GraphicsUtils.safe(dim.getPositionStart(position) + (long)size - 1L);
                gc.drawLine(startX, y, endX, y);
            }
            ++position;
        }
    }

    private void drawVerticalLines(ILayer natLayer, GC gc, Rectangle rectangle) {
        int startY = GraphicsUtils.safe(rectangle.y);
        int endY = GraphicsUtils.safe((long)rectangle.y + Math.min(natLayer.getHeight() - 1L, (long)rectangle.height));
        ILayerDim dim = natLayer.getDim(Orientation.HORIZONTAL);
        long endPosition = Math.min(dim.getPositionCount(), dim.getPositionByPixel(rectangle.x + rectangle.width - 1) + 1L);
        long position = dim.getPositionByPixel(rectangle.x);
        while (position < endPosition) {
            long size = dim.getPositionSize(position);
            if (size > 0L) {
                int x = GraphicsUtils.safe(dim.getPositionStart(position) + size - 1L);
                gc.drawLine(x, startY, x, endY);
            }
            ++position;
        }
    }
}

