/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.r.debug.core.sourcelookup;

import java.net.URI;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.debug.core.sourcelookup.ISourceContainer;
import org.eclipse.debug.core.sourcelookup.ISourceContainerType;
import org.eclipse.debug.core.sourcelookup.containers.CompositeSourceContainer;
import org.eclipse.statet.r.debug.core.sourcelookup.IRSourceContainer;

public class RProjectSourceContainer
extends CompositeSourceContainer
implements IRSourceContainer {
    public static final String TYPE_ID = "org.eclipse.statet.r.debugSourceContainers.RProjectType";
    private final IProject fProject;
    private boolean fReferenced;

    public RProjectSourceContainer(IProject project, boolean referenced) {
        this.fProject = project;
    }

    public ISourceContainerType getType() {
        return this.getSourceContainerType(TYPE_ID);
    }

    public String getName() {
        return this.fProject.getName();
    }

    public boolean isComposite() {
        return this.fReferenced;
    }

    public IProject getProject() {
        return this.fProject;
    }

    protected ISourceContainer[] createSourceContainers() throws CoreException {
        return new ISourceContainer[0];
    }

    public Object[] findSourceElements(String name) throws CoreException {
        return null;
    }

    public IFile findSourceElement(URI fileUri, IFile[] fileInWorkspace) {
        if (this.fProject.isOpen() && this.fProject.exists()) {
            IFile[] iFileArray = fileInWorkspace;
            int n = fileInWorkspace.length;
            int n2 = 0;
            while (n2 < n) {
                IFile workspaceFile = iFileArray[n2];
                if (this.fProject.equals((Object)workspaceFile.getProject()) && workspaceFile.exists()) {
                    return workspaceFile;
                }
                ++n2;
            }
        }
        return null;
    }

    @Override
    public void findSourceElement(IPath path, List<Object> elements) {
        IFile file;
        if (this.fProject.isOpen() && this.fProject.exists() && (file = this.fProject.getFile(path)).exists()) {
            elements.add(file);
        }
    }

    public int hashCode() {
        return this.fProject.hashCode();
    }

    public boolean equals(Object obj) {
        return obj instanceof RProjectSourceContainer && this.fProject.equals((Object)((RProjectSourceContainer)obj).fProject);
    }
}

