/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.waltable.layer;

import java.util.Collection;
import java.util.List;
import org.eclipse.statet.ecommons.waltable.coordinate.LRange;
import org.eclipse.statet.ecommons.waltable.coordinate.Orientation;
import org.eclipse.statet.ecommons.waltable.coordinate.PixelOutOfBoundsException;
import org.eclipse.statet.ecommons.waltable.coordinate.PositionOutOfBoundsException;
import org.eclipse.statet.ecommons.waltable.layer.AbstractLayerDim;
import org.eclipse.statet.ecommons.waltable.layer.ILayer;
import org.eclipse.statet.ecommons.waltable.layer.ILayerDim;

public abstract class DataDim<TLayer extends ILayer>
extends AbstractLayerDim<TLayer> {
    private final long idCat;

    public DataDim(TLayer layer, Orientation orientation, long idCat) {
        super(layer, orientation);
        this.idCat = idCat;
    }

    @Override
    public long getPositionId(long refPosition, long position) {
        if (position < 0L || position >= this.getPositionCount()) {
            throw PositionOutOfBoundsException.position(position, this.getOrientation());
        }
        return this.idCat | position;
    }

    @Override
    public long getPositionById(long id) {
        long position;
        if ((id & 0x7FF0000000000000L) == this.idCat && (position = id & 0xFFFFFFFFFFFFFL) < this.getPositionCount()) {
            return position;
        }
        return Long.MIN_VALUE;
    }

    @Override
    public long localToUnderlyingPosition(long refPosition, long position) {
        return position;
    }

    @Override
    public long underlyingToLocalPosition(ILayerDim sourceUnderlyingDim, long underlyingPosition) {
        return underlyingPosition;
    }

    @Override
    public List<LRange> underlyingToLocalPositions(ILayerDim sourceUnderlyingDim, Collection<LRange> underlyingPositions) {
        return null;
    }

    @Override
    public List<ILayerDim> getUnderlyingDimsByPosition(long position) {
        return null;
    }

    @Override
    public long getPreferredSize() {
        return this.getSize();
    }

    @Override
    public long getPositionByPixel(long pixel) {
        long position;
        long startPixel = 0L;
        long endPixel = this.getSize();
        if (pixel < startPixel || pixel >= endPixel) {
            throw PixelOutOfBoundsException.pixel(pixel, this.getOrientation());
        }
        long startPosition = 0L;
        long endPosition = this.getPositionCount();
        while (true) {
            double size = (double)(endPixel - startPixel) / (double)(endPosition - startPosition);
            position = startPosition + (long)((double)(pixel - startPixel) / size);
            long start = this.getPositionStart(position);
            long end = start + (long)this.getPositionSize(position);
            if (pixel < start) {
                endPosition = position;
                endPixel = start;
                continue;
            }
            if (pixel < end) break;
            startPosition = position + 1L;
            startPixel = end;
        }
        return position;
    }

    @Override
    public long getPositionStart(long refPosition, long position) {
        return this.getPositionStart(position);
    }

    @Override
    public int getPositionSize(long refPosition, long position) {
        return this.getPositionSize(position);
    }
}

