/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.r.debug.ui.actions;

import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.statet.internal.r.debug.ui.RDebugUIUtils;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.status.ProgressMonitor;
import org.eclipse.statet.jcommons.status.StatusException;
import org.eclipse.statet.ltk.ui.sourceediting.assist.AssistInvocationContext;
import org.eclipse.statet.ltk.ui.sourceediting.assist.InfoHover;
import org.eclipse.statet.nico.core.runtime.ToolProcess;
import org.eclipse.statet.nico.core.runtime.ToolStatus;
import org.eclipse.statet.r.console.core.IRDataAdapter;
import org.eclipse.statet.r.console.core.RProcess;
import org.eclipse.statet.r.core.model.RElementName;
import org.eclipse.statet.r.debug.core.IRStackFrame;
import org.eclipse.statet.r.ui.rtool.RElementInfoHoverCreator;
import org.eclipse.statet.r.ui.rtool.RElementInfoTask;
import org.eclipse.statet.r.ui.sourceediting.RAssistInvocationContext;
import org.eclipse.statet.rj.ts.core.RTool;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IWorkbenchPart;

@NonNullByDefault
public class RDebugHover
implements InfoHover {
    private final int mode;
    private @Nullable IInformationControlCreator controlCreator;

    public RDebugHover() {
        this.mode = 1;
    }

    public @Nullable Object getHoverInfo(AssistInvocationContext context, ProgressMonitor m) {
        RElementInfoTask info;
        m.beginSubTask("Looking up element info from R console...");
        final IWorkbenchPart workbenchPart = context.getEditor().getWorkbenchPart();
        final RProcess process = RDebugUIUtils.getRProcess(workbenchPart);
        if (process == null || !(context instanceof RAssistInvocationContext)) {
            return null;
        }
        RElementName name = ((RAssistInvocationContext)context).getNameSelection();
        if (name != null && (info = new RElementInfoTask(name){

            protected int getFramePosition(IRDataAdapter r, ProgressMonitor m) throws StatusException {
                IRStackFrame frame;
                if (process.getToolStatus() == ToolStatus.STARTED_SUSPENDED && (frame = RDebugUIUtils.getFrame(workbenchPart, (ToolProcess)process)) != null && frame.getPosition() > 0) {
                    return frame.getPosition();
                }
                return 0;
            }
        }).preCheck()) {
            return info.load((RTool)process, (Control)context.getSourceViewer().getTextWidget(), workbenchPart);
        }
        return null;
    }

    public @Nullable IInformationControlCreator getHoverControlCreator() {
        if (this.controlCreator == null) {
            this.controlCreator = new RElementInfoHoverCreator(this.mode);
        }
        return this.controlCreator;
    }
}

