/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.ui.components;

import org.eclipse.statet.ecommons.collections.FastList;
import org.eclipse.statet.ecommons.graphics.core.ColorDef;
import org.eclipse.statet.ecommons.graphics.core.HSVColorDef;
import org.eclipse.statet.ecommons.ui.SharedUIResources;
import org.eclipse.statet.ecommons.ui.components.IObjValueListener;
import org.eclipse.statet.ecommons.ui.components.IObjValueWidget;
import org.eclipse.statet.ecommons.ui.components.ObjValueEvent;
import org.eclipse.statet.ecommons.ui.util.LayoutUtils;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;

public class RGBSelector
extends Canvas
implements IObjValueWidget<ColorDef> {
    private static final byte RED = 0;
    private static final byte GREEN = 1;
    private static final byte BLUE = 2;
    private static final ColorDef DEFAULT_VALUE = new HSVColorDef(1.0f, 0.0f, 0.0f);
    private static final Color G_BACKGROUND = SharedUIResources.getColors().getColor("graphics.background");
    private int fSize = 8 + LayoutUtils.defaultHSpacing() * 30;
    private ColorDef fValue = DEFAULT_VALUE;
    private byte fCurrentPrim;
    private byte fCurrentRectX;
    private byte fCurrentRectY;
    private final FastList<IObjValueListener<ColorDef>> fValueListeners = new FastList(IObjValueListener.class);

    public RGBSelector(Composite parent) {
        super(parent, 0x20000000);
        this.setPrimary(0);
        SWTListener listener = new SWTListener();
        this.addPaintListener(listener);
        this.addListener(3, listener);
        this.addListener(4, listener);
        this.addListener(5, listener);
        this.addListener(12, listener);
    }

    public void setSize(int size) {
        this.fSize = size;
    }

    private int getComponent(byte c) {
        switch (c) {
            case 0: {
                return this.fValue.getRed();
            }
            case 1: {
                return this.fValue.getGreen();
            }
            case 2: {
                return this.fValue.getBlue();
            }
        }
        throw new IllegalArgumentException();
    }

    private ColorDef createColor(byte color, int value) {
        int[] rgb = new int[]{this.fValue.getRed(), this.fValue.getGreen(), this.fValue.getBlue()};
        rgb[color] = value;
        return new ColorDef(rgb[0], rgb[1], rgb[2]);
    }

    private ColorDef createColor(byte change1, int value1, byte change2, int value2) {
        int[] rgb = new int[]{this.fValue.getRed(), this.fValue.getGreen(), this.fValue.getBlue()};
        rgb[change1] = value1;
        rgb[change2] = value2;
        return new ColorDef(rgb[0], rgb[1], rgb[2]);
    }

    private boolean doSetValue(ColorDef newValue, int time, int flags) {
        if (this.fValue.equals((Object)newValue) && flags == 0 && this.fValue != DEFAULT_VALUE) {
            return false;
        }
        IObjValueListener[] listeners = (IObjValueListener[])this.fValueListeners.toArray();
        ObjValueEvent<ColorDef> event = new ObjValueEvent<ColorDef>(this, time, 0, this.fValue, newValue, flags);
        this.fValue = newValue;
        int i = 0;
        while (i < listeners.length) {
            event.newValue = newValue;
            listeners[i].valueChanged(event);
            ++i;
        }
        if (!this.isDisposed()) {
            this.redraw();
        }
        return true;
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        int width = 2 + Math.round((float)this.fSize * 1.15f) + LayoutUtils.defaultHSpacing();
        int height = 2 + this.fSize;
        int border = this.getBorderWidth();
        return new Point(width += border * 2, height += border * 2);
    }

    @Override
    public Control getControl() {
        return this;
    }

    @Override
    public Class<ColorDef> getValueType() {
        return ColorDef.class;
    }

    @Override
    public void addValueListener(IObjValueListener<ColorDef> listener) {
        this.fValueListeners.add(listener);
    }

    @Override
    public void removeValueListener(IObjValueListener<ColorDef> listener) {
        this.fValueListeners.remove(listener);
    }

    @Override
    public ColorDef getValue(int idx) {
        if (idx != 0) {
            throw new IllegalArgumentException("idx: " + idx);
        }
        return this.fValue;
    }

    @Override
    public void setValue(int idx, ColorDef value) {
        if (idx != 0) {
            throw new IllegalArgumentException("idx: " + idx);
        }
        if (value.getType() == "rgb") {
            this.doSetValue(value, 0, 0);
        } else {
            this.doSetValue(new ColorDef(value), 0, 0);
        }
    }

    public void setPrimary(int color) {
        switch (color) {
            case 0: {
                this.fCurrentPrim = 0;
                this.fCurrentRectX = 1;
                this.fCurrentRectY = (byte)2;
                break;
            }
            case 1: {
                this.fCurrentPrim = 1;
                this.fCurrentRectX = (byte)2;
                this.fCurrentRectY = 0;
                break;
            }
            case 2: {
                this.fCurrentPrim = (byte)2;
                this.fCurrentRectX = 0;
                this.fCurrentRectY = 1;
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        this.redraw();
    }

    private static final class Data {
        private final int size;
        private final float factor;
        private final int primX0;
        private final int primX1;
        private final int rectX0;
        private final int rectX1;
        private final int y0;
        private final int y1;

        public Data(int size) {
            this.size = size;
            this.factor = size - 1;
            this.primX0 = 1;
            this.primX1 = this.primX0 + Math.round((float)size * 0.15f);
            this.rectX0 = this.primX1 + LayoutUtils.defaultHSpacing();
            this.rectX1 = this.rectX0 + size;
            this.y0 = 1;
            this.y1 = this.y0 + size;
        }

        public int prim_y_255(int y) {
            int v = 255 - Math.round((float)(y - this.y0) / this.factor * 255.0f);
            if (v <= 0) {
                return 0;
            }
            if (v >= 255) {
                return 255;
            }
            return v;
        }

        public int rect_x_255(int x) {
            int v = Math.round((float)(x - this.rectX0) / this.factor * 255.0f);
            if (v <= 0) {
                return 0;
            }
            if (v >= 255) {
                return 255;
            }
            return v;
        }

        public int rect_y_255(int y) {
            int v = 255 - Math.round((float)(y - this.y0) / this.factor * 255.0f);
            if (v <= 0) {
                return 0;
            }
            if (v >= 255) {
                return 255;
            }
            return v;
        }

        public int prim_255_y(int v) {
            return this.y0 + Math.round((float)(255 - v) / 255.0f * this.factor);
        }

        public int rect_255_x(int v) {
            return this.rectX0 + Math.round((float)v / 255.0f * this.factor);
        }

        public int rect_255_y(int v) {
            return this.y0 + Math.round((float)(255 - v) / 255.0f * this.factor);
        }

        public Image createImage(Display display, byte primColor, int primValue, byte xColor, byte yColor) {
            Color color;
            Image image = new Image((Device)display, this.rectX1 + 1, this.y1 + 1);
            GC gc = new GC((Drawable)image);
            gc.setAdvanced(false);
            gc.setBackground(G_BACKGROUND);
            gc.fillRectangle(0, 0, image.getImageData().width, image.getImageData().height);
            int[] rgb = new int[3];
            int x1 = this.primX1 - 1;
            int y = this.y0;
            while (y < this.y1) {
                rgb[primColor] = this.prim_y_255(y);
                color = new Color((Device)display, rgb[0], rgb[1], rgb[2]);
                gc.setForeground(color);
                gc.drawLine(this.primX0, y, x1, y);
                color.dispose();
                ++y;
            }
            rgb[primColor] = primValue;
            int y2 = this.y0;
            while (y2 < this.y1) {
                rgb[yColor] = this.rect_y_255(y2);
                int x = this.rectX0;
                while (x < this.rectX1) {
                    rgb[xColor] = this.rect_x_255(x);
                    color = new Color((Device)display, rgb[0], rgb[1], rgb[2]);
                    gc.setForeground(color);
                    gc.drawPoint(x, y2);
                    color.dispose();
                    ++x;
                }
                ++y2;
            }
            gc.dispose();
            return image;
        }
    }

    private class SWTListener
    implements PaintListener,
    Listener {
        private static final int TRACK_PRIM = 1;
        private static final int TRACK_RECT = 2;
        private Data fData;
        private Image fImage;
        private int fImagePrim;
        private int fImagePrimValue;
        private int fMouseState;

        private SWTListener() {
        }

        public void handleEvent(Event event) {
            Data data = this.fData;
            switch (event.type) {
                case 3: {
                    if (data != null && event.y >= data.y0 && event.y < data.y1) {
                        if (event.x >= data.primX0 && event.x < data.primX1) {
                            RGBSelector.this.doSetValue(RGBSelector.this.createColor(RGBSelector.this.fCurrentPrim, data.prim_y_255(event.y)), event.time, 0);
                            this.fMouseState = 1;
                        } else if (event.x >= data.rectX0 && event.x < data.rectX1) {
                            RGBSelector.this.doSetValue(RGBSelector.this.createColor(RGBSelector.this.fCurrentRectX, data.rect_x_255(event.x), RGBSelector.this.fCurrentRectY, data.rect_y_255(event.y)), event.time, 0);
                            this.fMouseState = 2;
                        }
                    }
                    return;
                }
                case 4: {
                    this.fMouseState = 0;
                    return;
                }
                case 5: {
                    if (data != null) {
                        switch (this.fMouseState) {
                            case 1: {
                                RGBSelector.this.doSetValue(RGBSelector.this.createColor(RGBSelector.this.fCurrentPrim, data.prim_y_255(event.y)), event.time, 0);
                                break;
                            }
                            case 2: {
                                RGBSelector.this.doSetValue(RGBSelector.this.createColor(RGBSelector.this.fCurrentRectX, data.rect_x_255(event.x), RGBSelector.this.fCurrentRectY, data.rect_y_255(event.y)), event.time, 0);
                            }
                        }
                    }
                    return;
                }
                case 12: {
                    if (this.fImage == null) break;
                    this.fImage.dispose();
                    this.fImage = null;
                }
            }
        }

        private int computeSize(int width, int height) {
            width -= LayoutUtils.defaultHSpacing();
            width = Math.round((float)width / 1.15f);
            return Math.min(width - 2, height - 2);
        }

        public void paintControl(PaintEvent e) {
            Rectangle clientArea = RGBSelector.this.getClientArea();
            int size = this.computeSize(clientArea.width, clientArea.height);
            if (RGBSelector.this.fSize > 0 && RGBSelector.this.fSize < size) {
                size = RGBSelector.this.fSize;
            }
            if (this.fData == null || this.fData.size != size) {
                this.fData = new Data(size);
            }
            GC gc = e.gc;
            gc.setAdvanced(true);
            gc.setAntialias(0);
            int currentAlpha = 255;
            gc.setAlpha(255);
            gc.setBackground(G_BACKGROUND);
            gc.fillRectangle(clientArea);
            int primValue = RGBSelector.this.getComponent(RGBSelector.this.fCurrentPrim);
            if (this.fImage == null || this.fImagePrim != RGBSelector.this.fCurrentPrim || this.fImagePrimValue != primValue) {
                if (this.fImage != null) {
                    this.fImage.dispose();
                }
                this.fImage = this.fData.createImage(e.display, RGBSelector.this.fCurrentPrim, primValue, RGBSelector.this.fCurrentRectX, RGBSelector.this.fCurrentRectY);
                this.fImagePrim = RGBSelector.this.fCurrentPrim;
                this.fImagePrimValue = primValue;
            }
            gc.drawImage(this.fImage, 0, 0);
            gc.setLineWidth(1);
            gc.setAdvanced(true);
            gc.setAntialias(1);
            int y = this.fData.prim_255_y(primValue);
            gc.setForeground(e.display.getSystemColor(2));
            gc.drawLine(this.fData.primX0 - 1, y, this.fData.primX1, y);
            if (primValue < 127) {
                gc.setForeground(e.display.getSystemColor(1));
                gc.drawLine(this.fData.primX0, y, this.fData.primX1 - 1, y);
            }
            int x = this.fData.rect_255_x(RGBSelector.this.getComponent(RGBSelector.this.fCurrentRectX));
            int y2 = this.fData.rect_255_y(RGBSelector.this.getComponent(RGBSelector.this.fCurrentRectY));
            gc.setForeground(e.display.getSystemColor(Math.max(Math.max(RGBSelector.this.fValue.getRed(), RGBSelector.this.fValue.getGreen()), RGBSelector.this.fValue.getBlue()) < 127 ? 1 : 2));
            gc.drawOval(x - 1, y2 - 1, 3, 3);
        }
    }
}

