/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.rtm.base.ui.actions;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.osgi.util.NLS;
import org.eclipse.statet.internal.rtm.base.ui.actions.Messages;
import org.eclipse.statet.rtm.base.ui.IRtDescriptor;
import org.eclipse.statet.rtm.base.ui.actions.PerspectiveUtil;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.dialogs.WizardNewFileCreationPage;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.part.ISetSelectionTarget;
import org.eclipse.ui.statushandlers.StatusManager;

public abstract class AbstractNewRTaskFileWizard
extends Wizard
implements INewWizard {
    protected final IRtDescriptor rtDescriptor;
    protected ModelWizardNewFileCreationPage newFileCreationPage;
    protected IStructuredSelection selection;
    protected IWorkbench workbench;

    protected AbstractNewRTaskFileWizard(IRtDescriptor descriptor) {
        this.rtDescriptor = descriptor;
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.workbench = workbench;
        this.selection = selection;
        this.setWindowTitle(NLS.bind((String)Messages.NewRTaskWizard_title, (Object)this.rtDescriptor.getName()));
    }

    protected EObject createInitialModel() {
        return this.rtDescriptor.createInitialModelObject();
    }

    public boolean performFinish() {
        try {
            final IFile modelFile = this.getModelFile();
            WorkspaceModifyOperation operation = new WorkspaceModifyOperation(){

                protected void execute(IProgressMonitor progressMonitor) throws InvocationTargetException {
                    try {
                        try {
                            ResourceSetImpl resourceSet = new ResourceSetImpl();
                            URI fileURI = URI.createPlatformResourceURI((String)modelFile.getFullPath().toString(), (boolean)true);
                            Resource resource = resourceSet.createResource(fileURI, AbstractNewRTaskFileWizard.this.rtDescriptor.getDefaultContentTypeID());
                            EObject rootObject = AbstractNewRTaskFileWizard.this.createInitialModel();
                            if (rootObject != null) {
                                resource.getContents().add((Object)rootObject);
                            }
                            HashMap<String, String> options = new HashMap<String, String>();
                            options.put("ENCODING", "UTF-8");
                            resource.save(options);
                        }
                        catch (IOException e) {
                            throw new InvocationTargetException(e);
                        }
                    }
                    finally {
                        progressMonitor.done();
                    }
                }
            };
            this.getContainer().run(false, false, (IRunnableWithProgress)operation);
            PerspectiveUtil perspectiveUtil = new PerspectiveUtil();
            perspectiveUtil.updatePerspective(this.rtDescriptor.getAssociatedPerspectiveId());
            IWorkbenchWindow workbenchWindow = this.workbench.getActiveWorkbenchWindow();
            IWorkbenchPage page = workbenchWindow.getActivePage();
            final IWorkbenchPart activePart = page.getActivePart();
            if (activePart instanceof ISetSelectionTarget) {
                StructuredSelection targetSelection = new StructuredSelection((Object)modelFile);
                this.getShell().getDisplay().asyncExec(new Runnable((ISelection)targetSelection){
                    private final /* synthetic */ ISelection val$targetSelection;
                    {
                        this.val$targetSelection = iSelection;
                    }

                    @Override
                    public void run() {
                        ((ISetSelectionTarget)activePart).selectReveal(this.val$targetSelection);
                    }
                });
            }
            try {
                page.openEditor((IEditorInput)new FileEditorInput(modelFile), this.workbench.getEditorRegistry().getDefaultEditor(modelFile.getFullPath().toString(), Platform.getContentTypeManager().getContentType(this.rtDescriptor.getDefaultContentTypeID())).getId());
            }
            catch (PartInitException e) {
                StatusManager.getManager().handle((IStatus)new Status(4, "org.eclipse.statet.rtm.base.ui", 0, NLS.bind((String)Messages.NewRTaskWizard_error_OpenEditor_message, (Object)this.rtDescriptor.getName()), (Throwable)e), 3);
                return false;
            }
            return true;
        }
        catch (Exception e) {
            StatusManager.getManager().handle((IStatus)new Status(4, "org.eclipse.statet.rtm.base.ui", 0, NLS.bind((String)Messages.NewRTaskWizard_error_CreateFile_message, (Object)this.rtDescriptor.getName()), (Throwable)e), 3);
            return false;
        }
    }

    public void addPages() {
        Object selectedElement;
        this.newFileCreationPage = new ModelWizardNewFileCreationPage("NewRTask.NewFile", this.selection);
        this.newFileCreationPage.setTitle(NLS.bind((String)Messages.NewRTaskWizard_NewFile_title, (Object)this.rtDescriptor.getName()));
        this.newFileCreationPage.setDescription(NLS.bind((String)Messages.NewRTaskWizard_NewFile_description, (Object)this.rtDescriptor.getName()));
        this.addPage((IWizardPage)this.newFileCreationPage);
        if (this.selection != null && !this.selection.isEmpty() && (selectedElement = this.selection.iterator().next()) instanceof IResource) {
            IResource selectedResource = (IResource)selectedElement;
            if (selectedResource.getType() == 1) {
                selectedResource = selectedResource.getParent();
            }
            if (selectedResource instanceof IFolder || selectedResource instanceof IProject) {
                this.newFileCreationPage.setContainerFullPath(selectedResource.getFullPath());
            }
        }
    }

    public IFile getModelFile() {
        return this.newFileCreationPage.getModelFile();
    }

    public class ModelWizardNewFileCreationPage
    extends WizardNewFileCreationPage {
        public ModelWizardNewFileCreationPage(String pageId, IStructuredSelection selection) {
            super(pageId, selection);
            this.setFileExtension(AbstractNewRTaskFileWizard.this.rtDescriptor.getDefaultFileExtension());
        }

        public IFile getModelFile() {
            return ResourcesPlugin.getWorkspace().getRoot().getFile(this.getContainerFullPath().append(this.getFileName()));
        }
    }
}

