/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.rhelp.core.http;

import org.eclipse.statet.internal.rhelp.core.http.MediaType;
import org.eclipse.statet.jcommons.collections.ImList;
import org.eclipse.statet.jcommons.collections.ImMapEntry;
import org.eclipse.statet.jcommons.lang.Immutable;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;

@NonNullByDefault
public class BasicMediaType
implements MediaType,
Immutable {
    private final String type;
    private final String subtype;
    private final ImList<? extends ImMapEntry<String, String>> parameters;

    private static String check(String t) {
        if (t.length() == 1 && t.charAt(0) == '*') {
            return "*";
        }
        return t;
    }

    protected static final int compare(String t1, String t2) {
        if (t1 == "*") {
            if (t2 == "*") {
                return 0;
            }
            return 1;
        }
        if (t2 == "*") {
            return -1;
        }
        return t1.compareTo(t2);
    }

    public BasicMediaType(String type, String subtype, ImList<? extends ImMapEntry<String, String>> parameters) {
        this.type = BasicMediaType.check(type);
        this.subtype = BasicMediaType.check(subtype);
        this.parameters = parameters;
    }

    @Override
    public final String getType() {
        return this.type;
    }

    @Override
    public final String getSubtype() {
        return this.subtype;
    }

    public ImList<? extends ImMapEntry<String, String>> getParameters() {
        return this.parameters;
    }

    public int hashCode() {
        return this.type.hashCode() + this.subtype.hashCode() * 31;
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof MediaType) {
            MediaType other = (MediaType)obj;
            return this.type.equals(other.getType()) && this.subtype.equals(other.getSubtype()) && this.getParameters().equals(other.getParameters());
        }
        return false;
    }
}

