/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.rj.renv.core;

import java.util.Arrays;
import java.util.Iterator;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;

@NonNullByDefault
public final class RNumVersion {
    public static final RNumVersion NONE = new RNumVersion("");
    private static final int OP_UNSUPPORTED = -2;
    private static final int OP_NONE = -1;
    private static final int OP_GE = 2;
    private final String string;
    private volatile int @Nullable [] numeric;

    static {
        RNumVersion.NONE.numeric = new int[]{-1};
    }

    public static RNumVersion create(String s) {
        if (s == null || s.isEmpty()) {
            return NONE;
        }
        return new RNumVersion(s);
    }

    private static final int[] parseVersion(String s) {
        int[] v = new int[(3 + s.length()) / 2];
        int idx = 1;
        int i = 0;
        if (s.startsWith(">=")) {
            v[0] = 2;
            i = 2;
        }
        int start = -3;
        while (i < s.length()) {
            char c = s.charAt(i);
            if (start != -3 || c != ' ') {
                if (c >= '0' && c <= '9') {
                    if (start < 0) {
                        start = i;
                    }
                } else {
                    if (start < 0) break;
                    v[idx++] = Integer.parseInt(s.substring(start, i));
                    start = -1;
                    if (c != '.' && c != '-') break;
                }
            }
            ++i;
        }
        if (start >= 0) {
            v[idx++] = Integer.parseInt(s.substring(start, s.length()));
        }
        if (idx <= 2) {
            v[0] = -2;
            idx = 1;
        }
        return v.length == idx ? v : Arrays.copyOf(v, idx);
    }

    private RNumVersion(String s) {
        this.string = s;
    }

    public boolean isGreaterEqualThan(RNumVersion pkgVersion2) {
        return this.isGreaterEqualThan(this.getNumericVersion(), pkgVersion2.getNumericVersion());
    }

    private boolean isGreaterEqualThan(int[] v1, int[] v2) {
        int l = Math.max(v1.length, v2.length);
        int i = 1;
        while (i < l) {
            int diff = (i < v1.length ? v1[i] : 0) - (i < v2.length ? v2[i] : 0);
            if (diff > 0) {
                return true;
            }
            if (diff < 0) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean isGreaterThan(RNumVersion pkgVersion2) {
        return this.isGreaterThan(this.getNumericVersion(), pkgVersion2.getNumericVersion());
    }

    private boolean isGreaterThan(int[] v1, int[] v2) {
        int l = Math.max(v1.length, v2.length);
        int i = 1;
        while (i < l) {
            int diff = (i < v1.length ? v1[i] : 0) - (i < v2.length ? v2[i] : 0);
            if (diff > 0) {
                return true;
            }
            if (diff < 0) {
                return false;
            }
            ++i;
        }
        return false;
    }

    public boolean isSmallerThan(RNumVersion pkgVersion2) {
        return this.isSmallerThan(this.getNumericVersion(), pkgVersion2.getNumericVersion());
    }

    private boolean isSmallerThan(int[] v1, int[] v2) {
        int l = Math.max(v1.length, v2.length);
        int i = 1;
        while (i < l) {
            int diff = (i < v1.length ? v1[i] : 0) - (i < v2.length ? v2[i] : 0);
            if (diff < 0) {
                return true;
            }
            if (diff > 0) {
                return false;
            }
            ++i;
        }
        return false;
    }

    public boolean isSatisfiedBy(RNumVersion pkgVersion2) {
        int[] v1 = this.getNumericVersion();
        switch (v1[0]) {
            case 2: {
                return this.isGreaterEqualThan(pkgVersion2.getNumericVersion(), v1);
            }
        }
        return true;
    }

    public boolean isSatisfiedByAny(Iterator<RNumVersion> pkgVersion2) {
        int[] v1 = this.getNumericVersion();
        switch (v1[0]) {
            case 2: {
                while (pkgVersion2.hasNext()) {
                    if (!this.isGreaterEqualThan(pkgVersion2.next().getNumericVersion(), v1)) continue;
                    return true;
                }
                return false;
            }
        }
        return pkgVersion2.hasNext();
    }

    private int[] getNumericVersion() {
        if (this.numeric == null) {
            this.numeric = RNumVersion.parseVersion(this.string);
        }
        return this.numeric;
    }

    public int hashCode() {
        return this.string.hashCode();
    }

    public boolean equals(@Nullable Object obj) {
        return this == obj || obj instanceof RNumVersion && this.string.equals(((RNumVersion)obj).string);
    }

    public String toString() {
        return this.string;
    }
}

