/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.preferences.core.util;

import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.statet.ecommons.preferences.core.Preference;
import org.eclipse.statet.ecommons.preferences.core.PreferenceAccess;
import org.eclipse.statet.ecommons.preferences.core.PreferenceSetService;
import org.eclipse.statet.internal.ecommons.preferences.core.ECommonsPreferencesCorePlugin;
import org.eclipse.statet.jcommons.collections.ImCollections;
import org.eclipse.statet.jcommons.collections.ImList;
import org.eclipse.statet.jcommons.collections.ImSet;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;

@NonNullByDefault
public final class PreferenceUtils {
    private static final DefaultImpl DEFAULT_PREFS = new DefaultImpl(ImCollections.newList((Object)DefaultScope.INSTANCE));
    private static final DefaultImpl INSTANCE_PREFS = new DefaultImpl(ImCollections.newList((Object[])new IScopeContext[]{InstanceScope.INSTANCE, DefaultScope.INSTANCE}));
    public static final int FLUSH_SYNC = 1;
    public static final int FLUSH_ASYNC = 2;

    public static final PreferenceAccess getInstancePrefs() {
        return INSTANCE_PREFS;
    }

    public static final PreferenceAccess getDefaultPrefs() {
        return DEFAULT_PREFS;
    }

    public static PreferenceAccess createAccess(Map<Preference<?>, Object> preferencesMap) {
        return new MapImpl(preferencesMap);
    }

    public static PreferenceAccess createAccess(List<IScopeContext> contexts) {
        return new DefaultImpl(ImCollections.toList(contexts));
    }

    public static <T> T getPrefValue(List<IScopeContext> contexts, Preference<T> pref) {
        String storeValue = null;
        int i = 0;
        while (i < contexts.size() && storeValue == null) {
            try {
                storeValue = contexts.get(i).getNode(pref.getQualifier()).get(pref.getKey(), null);
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
            ++i;
        }
        return pref.store2Usage(storeValue);
    }

    public static <T> T getPrefValue(IScopeContext context, Preference<T> pref) {
        IEclipsePreferences node = context.getNode(pref.getQualifier());
        return PreferenceUtils.getPrefValue(node, pref);
    }

    public static <T> T getPrefValue(IEclipsePreferences node, Preference<T> pref) {
        String storeValue = node.get(pref.getKey(), null);
        return pref.store2Usage(storeValue);
    }

    public static <T> void setPrefValue(IScopeContext context, Preference<T> pref, T value) {
        IEclipsePreferences node = context.getNode(pref.getQualifier());
        PreferenceUtils.setPrefValue(node, pref, value);
    }

    public static <T> void setPrefValue(IScopeContext context, Preference<T> pref, T value, int flags) {
        final IEclipsePreferences node = context.getNode(pref.getQualifier());
        PreferenceUtils.setPrefValue(node, pref, value);
        if ((flags & 1) != 0) {
            PreferenceUtils.flush((Preferences)node);
        } else if ((flags & 2) != 0) {
            Job job = new Job("Save Preferences"){

                protected IStatus run(IProgressMonitor monitor) {
                    PreferenceUtils.flush((Preferences)node);
                    return Status.OK_STATUS;
                }
            };
            job.setSystem(true);
            job.setUser(false);
            job.setPriority(20);
            job.schedule();
        }
    }

    private static void flush(Preferences node) {
        try {
            node.flush();
        }
        catch (BackingStoreException e) {
            ECommonsPreferencesCorePlugin.log((IStatus)new Status(4, "org.eclipse.statet.ecommons.preferences.core", "An error occurred when saving preferences.", (Throwable)e));
        }
    }

    public static void setPrefValues(IScopeContext context, Map<Preference<?>, Object> preferencesMap) {
        for (Map.Entry<Preference<?>, Object> pref : preferencesMap.entrySet()) {
            PreferenceUtils.setPrefValue(context, pref.getKey(), pref.getValue());
        }
    }

    public static <T> void setPrefValue(IEclipsePreferences node, Preference<T> pref, T value) {
        String storeValue;
        if (value == null || (storeValue = pref.usage2Store(value)) == null) {
            node.remove(pref.getKey());
            return;
        }
        node.put(pref.getKey(), storeValue);
    }

    public static PreferenceSetService getPreferenceSetService() {
        ECommonsPreferencesCorePlugin plugin = ECommonsPreferencesCorePlugin.getInstance();
        if (plugin != null) {
            return plugin.getPreferenceSetService();
        }
        return null;
    }

    private static class DefaultImpl
    implements PreferenceAccess {
        private final ImList<IScopeContext> contexts;

        private DefaultImpl(ImList<IScopeContext> contexts) {
            this.contexts = contexts;
        }

        @Override
        public ImList<IScopeContext> getPreferenceContexts() {
            return this.contexts;
        }

        @Override
        public <T> T getPreferenceValue(Preference<T> pref) {
            return PreferenceUtils.getPrefValue(this.contexts, pref);
        }

        @Override
        public void addPreferenceNodeListener(String nodeQualifier, IEclipsePreferences.IPreferenceChangeListener listener) {
            int i = 0;
            while (i < this.contexts.size()) {
                IEclipsePreferences node;
                IScopeContext context = (IScopeContext)this.contexts.get(i);
                if (!(context instanceof DefaultScope) && (node = context.getNode(nodeQualifier)) != null) {
                    node.addPreferenceChangeListener(listener);
                }
                ++i;
            }
        }

        @Override
        public void removePreferenceNodeListener(String nodeQualifier, IEclipsePreferences.IPreferenceChangeListener listener) {
            int i = 0;
            while (i < this.contexts.size()) {
                IEclipsePreferences node;
                IScopeContext context = (IScopeContext)this.contexts.get(i);
                if (!(context instanceof DefaultScope) && (node = context.getNode(nodeQualifier)) != null) {
                    node.removePreferenceChangeListener(listener);
                }
                ++i;
            }
        }

        @Override
        public void addPreferenceSetListener(PreferenceSetService.ChangeListener listener, ImSet<String> qualifiers) {
            PreferenceUtils.getPreferenceSetService().addChangeListener(listener, this.getPreferenceContexts(), qualifiers);
        }

        @Override
        public void removePreferenceSetListener(PreferenceSetService.ChangeListener listener) {
            PreferenceSetService service = PreferenceUtils.getPreferenceSetService();
            if (service != null) {
                service.removeChangeListener(listener);
            }
        }
    }

    private static class MapImpl
    implements PreferenceAccess {
        private final Map<Preference<?>, Object> preferencesMap;

        MapImpl(Map<Preference<?>, Object> preferencesMap) {
            this.preferencesMap = preferencesMap;
        }

        @Override
        public ImList<IScopeContext> getPreferenceContexts() {
            return ImCollections.emptyList();
        }

        @Override
        public <T> T getPreferenceValue(Preference<T> pref) {
            return (T)this.preferencesMap.get(pref);
        }

        @Override
        public void addPreferenceNodeListener(String nodeQualifier, IEclipsePreferences.IPreferenceChangeListener listener) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void removePreferenceNodeListener(String nodeQualifier, IEclipsePreferences.IPreferenceChangeListener listener) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void addPreferenceSetListener(PreferenceSetService.ChangeListener listener, ImSet<String> qualifiers) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void removePreferenceSetListener(PreferenceSetService.ChangeListener listener) {
            throw new UnsupportedOperationException();
        }
    }
}

