/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.nico.core.runtime;

import java.util.Map;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.IStreamsProxy;
import org.eclipse.debug.core.model.RuntimeProcess;
import org.eclipse.statet.nico.core.runtime.ILogOutput;
import org.eclipse.statet.nico.core.runtime.RuntimeProcessOutput;
import org.eclipse.statet.nico.core.runtime.ToolRunner;

public class LogRuntimeProcess
extends RuntimeProcess {
    private boolean fLogOnly;
    private RuntimeProcessOutput fLog;

    public LogRuntimeProcess(ILaunch launch, Process process, String name, Map<String, String> attributes) {
        super(launch, process, name, attributes);
    }

    protected IStreamsProxy createStreamsProxy() {
        this.fLogOnly = ToolRunner.captureLogOnly(this.getLaunch().getLaunchConfiguration());
        IStreamsProxy proxy = super.createStreamsProxy();
        if (this.fLogOnly) {
            this.fLog = new RuntimeProcessOutput(proxy, this.fLogOnly);
        }
        return proxy;
    }

    public IStreamsProxy getStreamsProxy() {
        if (!this.fLogOnly) {
            return super.getStreamsProxy();
        }
        return null;
    }

    public <T> T getAdapter(Class<T> adapterType) {
        if (adapterType == ILogOutput.class) {
            return (T)this.fLog;
        }
        return (T)super.getAdapter(adapterType);
    }
}

