/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.r.ui.text.r;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.text.rules.ICharacterScanner;
import org.eclipse.jface.text.rules.IRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.statet.r.core.rlang.RTokens;

public class RInfixOperatorRule
implements IRule {
    private final IToken fDefaultOpToken;
    private final IToken fPredefinedOpToken;
    private final IToken fInvalidOpToken;
    private final StringBuilder fBuffer;
    private final Map<String, IToken> fSpecialOperators;

    public RInfixOperatorRule(IToken userDefinedOpToken, IToken invalidOpToken, IToken predefinedOpToken) {
        this.fDefaultOpToken = userDefinedOpToken;
        this.fPredefinedOpToken = predefinedOpToken;
        this.fInvalidOpToken = invalidOpToken;
        this.fBuffer = new StringBuilder();
        this.fSpecialOperators = new HashMap<String, IToken>();
        String[] stringArray = RTokens.PREDIFINED_INFIX_OPERATORS;
        int n = RTokens.PREDIFINED_INFIX_OPERATORS.length;
        int n2 = 0;
        while (n2 < n) {
            String op = stringArray[n2];
            this.fSpecialOperators.put(op, this.fPredefinedOpToken);
            ++n2;
        }
    }

    public IToken evaluate(ICharacterScanner scanner) {
        int c = scanner.read();
        if (c == 37) {
            this.fBuffer.append('%');
            while (true) {
                c = scanner.read();
                switch (c) {
                    case 37: {
                        this.fBuffer.append('%');
                        return this.succeed();
                    }
                    case -1: 
                    case 10: 
                    case 13: {
                        scanner.unread();
                        this.fBuffer.setLength(0);
                        return this.fInvalidOpToken;
                    }
                }
                this.fBuffer.append((char)c);
            }
        }
        scanner.unread();
        return Token.UNDEFINED;
    }

    private IToken succeed() {
        IToken token = this.fSpecialOperators.get(this.fBuffer.toString());
        this.fBuffer.setLength(0);
        return token != null ? token : this.fDefaultOpToken;
    }
}

