/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.yaml.snakeyaml.scanner;

import java.util.Arrays;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.text.core.input.TextParserInput;

@NonNullByDefault
public final class StreamReader {
    public static final int EOF = 0;
    private final TextParserInput input;
    private int[] codePointsWindow = new int[0];
    private int dataLength = 0;
    private int pointer = 0;
    private boolean eof;
    private int index = 0;
    private int line = 0;
    private int column = 0;
    private final int bufferSize;

    public StreamReader(TextParserInput input, int bufferSize) {
        this.input = input;
        this.eof = false;
        this.index = input.getStartIndex();
        this.bufferSize = bufferSize;
    }

    public static final boolean isPrintable(String data) {
        int length = data.length();
        int offset = 0;
        while (offset < length) {
            int codePoint = data.codePointAt(offset);
            if (!StreamReader.isPrintable(codePoint)) {
                return false;
            }
            offset += Character.charCount(codePoint);
        }
        return true;
    }

    public static boolean isPrintable(int c) {
        return c >= 32 && c <= 126 || c == 9 || c == 10 || c == 13 || c == 133 || c >= 160 && c <= 55295 || c >= 57344 && c <= 65533 || c >= 65536 && c <= 0x10FFFF;
    }

    public int getMark() {
        return this.index;
    }

    public void forward() {
        this.forward(1);
    }

    public void forward(int length) {
        int i = 0;
        while (i < length && this.ensureEnoughData()) {
            int c = this.codePointsWindow[this.pointer++];
            ++this.index;
            if (c == 10 || c == 13 && this.ensureEnoughData() && this.codePointsWindow[this.pointer] != 10) {
                ++this.line;
                this.column = 0;
            } else if (c != 65279) {
                ++this.column;
            }
            ++i;
        }
    }

    public int peek() {
        return this.ensureEnoughData() ? this.codePointsWindow[this.pointer] : 0;
    }

    public int peek(int index) {
        return this.ensureEnoughData(index) ? this.codePointsWindow[this.pointer + index] : 0;
    }

    public String prefix(int length) {
        if (length == 0) {
            return "";
        }
        if (this.ensureEnoughData(length)) {
            return new String(this.codePointsWindow, this.pointer, length);
        }
        return new String(this.codePointsWindow, this.pointer, Math.min(length, this.dataLength - this.pointer));
    }

    public String prefixForward(int length) {
        String prefix = this.prefix(length);
        this.pointer += length;
        this.index += length;
        this.column += length;
        return prefix;
    }

    private boolean ensureEnoughData() {
        return this.ensureEnoughData(0);
    }

    private boolean ensureEnoughData(int size) {
        if (!this.eof && this.pointer + size >= this.dataLength) {
            this.update();
        }
        return this.pointer + size < this.dataLength;
    }

    private void update() {
        int c = this.input.get(0);
        if (c != -1) {
            int cpIndex = this.dataLength - this.pointer;
            this.codePointsWindow = Arrays.copyOfRange(this.codePointsWindow, this.pointer, this.dataLength + this.bufferSize);
            while (cpIndex < this.codePointsWindow.length) {
                if (c != -1) {
                    char c0 = (char)c;
                    c = this.input.get(1);
                    if (c != -1 && Character.isHighSurrogate(c0) && Character.isLowSurrogate((char)c)) {
                        this.codePointsWindow[cpIndex++] = Character.toCodePoint(c0, (char)c);
                        this.input.consume(2);
                        c = this.input.get(0);
                        continue;
                    }
                    this.codePointsWindow[cpIndex++] = c0;
                    this.input.consume(1);
                    continue;
                }
                this.eof = true;
                break;
            }
            this.dataLength = cpIndex;
            this.pointer = 0;
        } else {
            this.eof = true;
        }
    }

    public int getColumn() {
        return this.column;
    }

    public int getIndex() {
        return this.index;
    }

    public int getLine() {
        return this.line;
    }
}

