/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.yaml.snakeyaml.scanner;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.statet.internal.yaml.snakeyaml.scanner.CharConstants;
import org.eclipse.statet.internal.yaml.snakeyaml.scanner.SimpleKey;
import org.eclipse.statet.internal.yaml.snakeyaml.scanner.StreamReader;
import org.eclipse.statet.internal.yaml.snakeyaml.scanner.SyntaxProblem;
import org.eclipse.statet.internal.yaml.snakeyaml.tokens.AliasToken;
import org.eclipse.statet.internal.yaml.snakeyaml.tokens.AnchorToken;
import org.eclipse.statet.internal.yaml.snakeyaml.tokens.BlockEndToken;
import org.eclipse.statet.internal.yaml.snakeyaml.tokens.BlockEntryToken;
import org.eclipse.statet.internal.yaml.snakeyaml.tokens.BlockMappingStartToken;
import org.eclipse.statet.internal.yaml.snakeyaml.tokens.BlockSequenceStartToken;
import org.eclipse.statet.internal.yaml.snakeyaml.tokens.CommentType;
import org.eclipse.statet.internal.yaml.snakeyaml.tokens.DirectiveToken;
import org.eclipse.statet.internal.yaml.snakeyaml.tokens.DocumentEndToken;
import org.eclipse.statet.internal.yaml.snakeyaml.tokens.DocumentStartToken;
import org.eclipse.statet.internal.yaml.snakeyaml.tokens.Dummy;
import org.eclipse.statet.internal.yaml.snakeyaml.tokens.FlowEntryToken;
import org.eclipse.statet.internal.yaml.snakeyaml.tokens.FlowMappingEndToken;
import org.eclipse.statet.internal.yaml.snakeyaml.tokens.FlowMappingStartToken;
import org.eclipse.statet.internal.yaml.snakeyaml.tokens.FlowSequenceEndToken;
import org.eclipse.statet.internal.yaml.snakeyaml.tokens.FlowSequenceStartToken;
import org.eclipse.statet.internal.yaml.snakeyaml.tokens.KeyToken;
import org.eclipse.statet.internal.yaml.snakeyaml.tokens.ScalarStyle;
import org.eclipse.statet.internal.yaml.snakeyaml.tokens.ScalarToken;
import org.eclipse.statet.internal.yaml.snakeyaml.tokens.StreamEndToken;
import org.eclipse.statet.internal.yaml.snakeyaml.tokens.StreamStartToken;
import org.eclipse.statet.internal.yaml.snakeyaml.tokens.TagToken;
import org.eclipse.statet.internal.yaml.snakeyaml.tokens.TagTuple;
import org.eclipse.statet.internal.yaml.snakeyaml.tokens.Token;
import org.eclipse.statet.internal.yaml.snakeyaml.tokens.ValueToken;
import org.eclipse.statet.jcommons.collections.IntArrayList;
import org.eclipse.statet.jcommons.collections.IntList;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.text.core.input.TextParserInput;
import org.eclipse.statet.ltk.core.source.StatusDetail;

@NonNullByDefault
public class ScannerImpl {
    private static final byte CHOMPING_STRIP = 0;
    private static final byte CHOMPING_CLIP = 1;
    private static final byte CHOMPING_KEEP = 2;
    private StreamReader reader;
    private boolean done = false;
    private final List<Token> tokens = new ArrayList<Token>(64);
    private Token lastToken;
    private int flowLevel = 0;
    private int tokensTaken = 0;
    private int indent = -1;
    private final IntList indents = new IntArrayList(16);
    private final StringBuilder tmpSB = new StringBuilder(256);
    private final StringBuilder tmpSB2 = new StringBuilder();
    private int tmpInt;
    private boolean scanOK;
    private @Nullable SyntaxProblem scanProblem;
    private boolean createAnchorText;
    private boolean createContentText;
    private boolean parseComments;
    private boolean allowSimpleKey = true;
    private final Map<Integer, SimpleKey> possibleSimpleKeys = new LinkedHashMap<Integer, SimpleKey>();

    public ScannerImpl(boolean createRefText, boolean createContentText, boolean parseComments) {
        this.createAnchorText = createRefText;
        this.createContentText = createContentText;
        this.parseComments = parseComments;
    }

    public boolean getCreateAnchorText() {
        return this.createAnchorText;
    }

    public void setCreateAnchorText(boolean enable) {
        this.createAnchorText = enable;
    }

    public boolean getCreateContentText() {
        return this.createContentText;
    }

    public void setCreateContentText(boolean enable) {
        this.createContentText = enable;
    }

    public boolean getParseComments() {
        return this.parseComments;
    }

    public void setParseComments(boolean enable) {
        this.parseComments = enable;
    }

    public void reset(StreamReader in) {
        this.reader = in;
        this.done = false;
        this.tokens.clear();
        this.tokensTaken = 0;
        this.resetToRoot();
        this.fetchStreamStart();
    }

    public void reset(TextParserInput input) {
        this.reset(new StreamReader(input, 2048));
    }

    public void resetToRoot() {
        this.flowLevel = 0;
        this.indent = -1;
        this.indents.clear();
        this.allowSimpleKey = true;
    }

    public @Nullable Token nextToken() {
        while (this.needMoreTokens()) {
            this.fetchMoreTokens();
        }
        if (!this.tokens.isEmpty()) {
            ++this.tokensTaken;
            return this.tokens.remove(0);
        }
        return null;
    }

    private void addToken(Token token) {
        this.lastToken = token;
        this.tokens.add(token);
    }

    private void addToken(int index, Token token) {
        if (index == this.tokens.size()) {
            this.lastToken = token;
        }
        this.tokens.add(index, token);
    }

    private boolean isBlockContext() {
        return this.flowLevel == 0;
    }

    private boolean isFlowContext() {
        return this.flowLevel != 0;
    }

    private boolean needMoreTokens() {
        if (this.done) {
            return false;
        }
        if (this.tokens.isEmpty()) {
            return true;
        }
        this.stalePossibleSimpleKeys();
        return this.nextPossibleSimpleKey() == this.tokensTaken;
    }

    private void fetchMoreTokens() {
        this.scanToNextToken();
        this.stalePossibleSimpleKeys();
        this.unwindIndent(this.reader.getColumn());
        int c = this.reader.peek();
        switch (c) {
            case 0: {
                this.fetchStreamEnd();
                return;
            }
            case 37: {
                if (!this.checkDirective()) break;
                this.fetchDirective();
                return;
            }
            case 45: {
                if (this.checkDocumentStart()) {
                    this.fetchDocumentIndicator(Token.ID.DocumentStart);
                    return;
                }
                if (!this.checkBlockEntry()) break;
                this.fetchBlockEntry();
                return;
            }
            case 46: {
                if (!this.checkDocumentEnd()) break;
                this.fetchDocumentIndicator(Token.ID.DocumentEnd);
                return;
            }
            case 91: {
                this.fetchFlowSequenceStart();
                return;
            }
            case 123: {
                this.fetchFlowMappingStart();
                return;
            }
            case 93: {
                this.fetchFlowSequenceEnd();
                return;
            }
            case 125: {
                this.fetchFlowMappingEnd();
                return;
            }
            case 44: {
                this.fetchFlowEntry();
                return;
            }
            case 63: {
                if (!this.checkKey()) break;
                this.fetchKey();
                return;
            }
            case 58: {
                if (!this.checkValue()) break;
                this.fetchValue();
                return;
            }
            case 42: {
                this.fetchAlias();
                return;
            }
            case 38: {
                this.fetchAnchor();
                return;
            }
            case 33: {
                this.fetchTag();
                return;
            }
            case 124: {
                if (!this.isBlockContext()) break;
                this.fetchLiteral();
                return;
            }
            case 62: {
                if (!this.isBlockContext()) break;
                this.fetchFolded();
                return;
            }
            case 39: {
                this.fetchFlowScalar((byte)12);
                return;
            }
            case 34: {
                this.fetchFlowScalar((byte)13);
                return;
            }
        }
        if (this.checkPlain()) {
            this.fetchPlain();
            return;
        }
        int startMark = this.reader.getMark();
        this.clearProblems();
        this.reader.forward(1);
        this.newScannerException((byte)1, startMark, 4194608, startMark, this.reader.getMark(), Character.toString(c));
        this.addToken(new Dummy(startMark, this.reader.getMark(), this.scanProblem));
    }

    private int nextPossibleSimpleKey() {
        if (!this.possibleSimpleKeys.isEmpty()) {
            return this.possibleSimpleKeys.values().iterator().next().getTokenNumber();
        }
        return -1;
    }

    private void stalePossibleSimpleKeys() {
        if (!this.possibleSimpleKeys.isEmpty()) {
            Iterator<SimpleKey> iterator = this.possibleSimpleKeys.values().iterator();
            while (iterator.hasNext()) {
                SimpleKey key = iterator.next();
                if (key.getLine() == this.reader.getLine() && this.reader.getIndex() - key.getIndex() <= 1024) continue;
                if (key.isRequired()) {
                    this.newScannerException((byte)7, key.getMark(), 4477744, this.reader.getMark());
                }
                iterator.remove();
            }
        }
    }

    private void savePossibleSimpleKey() {
        boolean required;
        boolean bl = required = this.isBlockContext() && this.indent == this.reader.getColumn();
        if (!this.allowSimpleKey && required) {
            throw new RuntimeException("A simple key is required only if it is the first token in the current line");
        }
        if (this.allowSimpleKey) {
            int mark = this.reader.getMark();
            this.removePossibleSimpleKey(mark);
            int tokenNumber = this.tokensTaken + this.tokens.size();
            SimpleKey key = new SimpleKey(tokenNumber, required, this.reader.getIndex(), this.reader.getLine(), this.reader.getColumn(), mark);
            this.possibleSimpleKeys.put(this.flowLevel, key);
        }
    }

    private void removePossibleSimpleKey(int mark) {
        SimpleKey key = this.possibleSimpleKeys.remove(this.flowLevel);
        if (key != null && key.isRequired()) {
            this.newScannerException((byte)7, key.getMark(), 4477744, mark);
        }
    }

    /*
     * Unable to fully structure code
     */
    private void unwindIndent(int col) {
        if (!this.isFlowContext()) ** GOTO lbl6
        return;
lbl-1000:
        // 1 sources

        {
            mark = this.reader.getMark();
            this.indent = this.indents.removeAt(this.indents.size() - 1);
            this.addToken(new BlockEndToken(mark, mark, null));
lbl6:
            // 2 sources

            ** while (this.indent > col)
        }
lbl7:
        // 1 sources

    }

    private boolean addIndent(int column) {
        if (this.indent < column) {
            this.indents.add(this.indent);
            this.indent = column;
            return true;
        }
        return false;
    }

    private void fetchStreamStart() {
        int mark = this.reader.getMark();
        StreamStartToken token = new StreamStartToken(mark, mark, null);
        this.addToken(token);
    }

    private void fetchStreamEnd() {
        this.unwindIndent(-1);
        int mark = this.reader.getMark();
        this.clearProblems();
        this.removePossibleSimpleKey(mark);
        this.allowSimpleKey = false;
        this.possibleSimpleKeys.clear();
        StreamEndToken token = new StreamEndToken(mark, mark, null);
        this.addToken(token);
        this.done = true;
    }

    private void fetchDirective() {
        this.unwindIndent(-1);
        int startMark = this.reader.getMark();
        this.clearProblems();
        this.removePossibleSimpleKey(startMark);
        this.allowSimpleKey = false;
        Token token = this.scanDirective(startMark);
        this.addToken(token);
    }

    private void fetchDocumentIndicator(Token.ID type) {
        this.unwindIndent(-1);
        int startMark = this.reader.getMark();
        this.clearProblems();
        this.removePossibleSimpleKey(startMark);
        this.allowSimpleKey = false;
        this.reader.forward(3);
        if (type == Token.ID.DocumentEnd) {
            this.scanIgnoredLineTail((byte)0, startMark);
            this.resetToRoot();
        }
        int endMark = this.reader.getMark();
        this.addToken(switch (type) {
            case Token.ID.DocumentStart -> new DocumentStartToken(startMark, endMark, this.scanProblem);
            case Token.ID.DocumentEnd -> new DocumentEndToken(startMark, endMark, this.scanProblem);
            default -> throw new IllegalArgumentException();
        });
    }

    private void fetchFlowSequenceStart() {
        this.fetchFlowCollectionStart(false);
    }

    private void fetchFlowMappingStart() {
        this.fetchFlowCollectionStart(true);
    }

    private void fetchFlowCollectionStart(boolean isMappingStart) {
        this.clearProblems();
        this.savePossibleSimpleKey();
        ++this.flowLevel;
        this.allowSimpleKey = true;
        int startMark = this.reader.getMark();
        this.reader.forward(1);
        int endMark = this.reader.getMark();
        Token token = isMappingStart ? new FlowMappingStartToken(startMark, endMark, this.scanProblem) : new FlowSequenceStartToken(startMark, endMark, this.scanProblem);
        this.addToken(token);
    }

    private void fetchFlowSequenceEnd() {
        this.fetchFlowCollectionEnd(false);
    }

    private void fetchFlowMappingEnd() {
        this.fetchFlowCollectionEnd(true);
    }

    private void fetchFlowCollectionEnd(boolean isMappingEnd) {
        int startMark = this.reader.getMark();
        this.clearProblems();
        this.removePossibleSimpleKey(startMark);
        --this.flowLevel;
        this.allowSimpleKey = false;
        this.reader.forward();
        int endMark = this.reader.getMark();
        Token token = isMappingEnd ? new FlowMappingEndToken(startMark, endMark, this.scanProblem) : new FlowSequenceEndToken(startMark, endMark, this.scanProblem);
        this.addToken(token);
    }

    private void fetchFlowEntry() {
        int startMark = this.reader.getMark();
        this.clearProblems();
        this.allowSimpleKey = true;
        this.removePossibleSimpleKey(startMark);
        this.reader.forward();
        int endMark = this.reader.getMark();
        FlowEntryToken token = new FlowEntryToken(startMark, endMark, this.scanProblem);
        this.addToken(token);
    }

    private void fetchBlockEntry() {
        int startMark = this.reader.getMark();
        this.clearProblems();
        if (this.isBlockContext()) {
            if (!this.allowSimpleKey) {
                this.newScannerException((byte)0, startMark, 0x400200, startMark);
            }
            if (this.addIndent(this.reader.getColumn())) {
                this.addToken(new BlockSequenceStartToken(startMark, startMark, this.scanProblem));
            }
        }
        this.allowSimpleKey = true;
        this.removePossibleSimpleKey(startMark);
        this.reader.forward();
        int endMark = this.reader.getMark();
        BlockEntryToken token = new BlockEntryToken(startMark, endMark, this.scanProblem);
        this.addToken(token);
    }

    private void fetchKey() {
        int startMark = this.reader.getMark();
        this.clearProblems();
        if (this.isBlockContext()) {
            if (!this.allowSimpleKey) {
                this.newScannerException((byte)0, startMark, 0x400200, startMark);
            }
            if (this.addIndent(this.reader.getColumn())) {
                int mark = this.reader.getMark();
                this.addToken(new BlockMappingStartToken(mark, mark, this.scanProblem));
            }
        }
        this.allowSimpleKey = this.isBlockContext();
        this.removePossibleSimpleKey(startMark);
        this.reader.forward();
        int endMark = this.reader.getMark();
        KeyToken token = new KeyToken(startMark, endMark, this.scanProblem);
        this.addToken(token);
    }

    private void fetchValue() {
        int startMark = this.reader.getMark();
        this.clearProblems();
        SimpleKey key = this.possibleSimpleKeys.remove(this.flowLevel);
        if (key != null) {
            this.addToken(key.getTokenNumber() - this.tokensTaken, new KeyToken(key.getMark(), key.getMark(), null));
            if (this.isBlockContext() && this.addIndent(key.getColumn())) {
                this.addToken(key.getTokenNumber() - this.tokensTaken, new BlockMappingStartToken(key.getMark(), key.getMark(), null));
            }
            this.allowSimpleKey = false;
        } else {
            if (this.isBlockContext() && !this.allowSimpleKey) {
                this.newScannerException((byte)0, startMark, 0x400200, startMark);
            }
            if (this.isBlockContext() && this.addIndent(this.reader.getColumn())) {
                int mark = this.reader.getMark();
                this.addToken(new BlockMappingStartToken(mark, mark, null));
            }
            this.allowSimpleKey = this.isBlockContext();
            this.removePossibleSimpleKey(startMark);
        }
        this.reader.forward();
        int endMark = this.reader.getMark();
        ValueToken token = new ValueToken(startMark, endMark, this.scanProblem);
        this.addToken(token);
    }

    private void fetchAlias() {
        this.clearProblems();
        this.savePossibleSimpleKey();
        this.allowSimpleKey = false;
        Token token = this.scanAnchor((byte)9);
        this.addToken(token);
    }

    private void fetchAnchor() {
        this.clearProblems();
        this.savePossibleSimpleKey();
        this.allowSimpleKey = false;
        Token token = this.scanAnchor((byte)8);
        this.addToken(token);
    }

    private void fetchTag() {
        this.clearProblems();
        this.savePossibleSimpleKey();
        this.allowSimpleKey = false;
        Token token = this.scanTag();
        this.addToken(token);
    }

    private void fetchLiteral() {
        this.fetchBlockScalar(ScalarStyle.LITERAL);
    }

    private void fetchFolded() {
        this.fetchBlockScalar(ScalarStyle.FOLDED);
    }

    private void fetchBlockScalar(ScalarStyle style) {
        int startMark = this.reader.getMark();
        this.clearProblems();
        this.allowSimpleKey = true;
        this.removePossibleSimpleKey(startMark);
        Token token = this.scanBlockScalar(style, startMark);
        this.addToken(token);
    }

    private void fetchFlowScalar(byte context) {
        this.clearProblems();
        this.savePossibleSimpleKey();
        this.allowSimpleKey = false;
        Token token = this.scanFlowScalar(context);
        this.addToken(token);
    }

    private void fetchPlain() {
        this.clearProblems();
        this.savePossibleSimpleKey();
        this.allowSimpleKey = false;
        Token token = this.scanPlain();
        this.addToken(token);
    }

    private boolean checkDirective() {
        return this.reader.getColumn() == 0;
    }

    private boolean checkDocumentStart() {
        if (this.reader.getColumn() == 0) {
            return "---".equals(this.reader.prefix(3)) && CharConstants.isWhiteSpaceOrEol(this.reader.peek(3));
        }
        return false;
    }

    private boolean checkDocumentEnd() {
        if (this.reader.getColumn() == 0) {
            return "...".equals(this.reader.prefix(3)) && CharConstants.isWhiteSpaceOrEol(this.reader.peek(3));
        }
        return false;
    }

    private boolean checkBlockEntry() {
        return CharConstants.isWhiteSpaceOrEol(this.reader.peek(1));
    }

    private boolean checkKey() {
        return CharConstants.isWhiteSpaceOrEol(this.reader.peek(1));
    }

    private boolean checkValue() {
        if (this.isFlowContext()) {
            return true;
        }
        return CharConstants.isWhiteSpaceOrEol(this.reader.peek(1));
    }

    private boolean checkPlain() {
        int c = this.reader.peek();
        if (!CharConstants.isWhiteSpaceOrEol(c) && "-?:,[]{}#&*!|>'\"@`".indexOf(c) == -1) {
            return true;
        }
        if (this.isBlockContext()) {
            return CharConstants.isOr(c, '-', '?', ':') && !CharConstants.isWhiteSpaceOrEol(this.reader.peek(1));
        }
        return CharConstants.isOr(c, '-', '?') && !CharConstants.isWhiteSpaceOrEolOr(this.reader.peek(1), ',', ']');
    }

    private void scanToNextToken() {
        if (this.reader.getIndex() == 0 && this.reader.peek() == 65279) {
            this.reader.forward();
        }
        boolean found = false;
        int inlineStartColumn = -1;
        while (!found) {
            int startMark = this.reader.getMark();
            int startColumn = this.reader.getColumn();
            boolean commentSeen = false;
            int ff = 0;
            while (this.reader.peek(ff) == 32) {
                ++ff;
            }
            if (ff > 0) {
                this.reader.forward(ff);
            }
            if (this.reader.peek() == 35) {
                CommentType type;
                commentSeen = true;
                if (startColumn != 0 && (this.lastToken == null || this.lastToken.getTokenId() != Token.ID.BlockEntry)) {
                    type = CommentType.IN_LINE;
                    inlineStartColumn = this.reader.getColumn();
                } else if (inlineStartColumn == this.reader.getColumn()) {
                    type = CommentType.IN_LINE;
                } else {
                    inlineStartColumn = -1;
                    type = CommentType.BLOCK;
                }
                this.scanComment(type);
            }
            if (this.scanLineBreak()) {
                if (!this.isBlockContext()) continue;
                this.allowSimpleKey = true;
                continue;
            }
            found = true;
        }
    }

    private void forwardToLineEnd() {
        int c;
        while (!CharConstants.isEol(c = this.reader.peek())) {
            if (c == 35) {
                this.scanComment(CommentType.IN_LINE);
                break;
            }
            this.reader.forward();
        }
    }

    private void scanComment(CommentType type) {
        int startMark = this.reader.getMark();
        this.reader.forward();
        while (!CharConstants.isEol(this.reader.peek())) {
            this.reader.forward();
        }
        if (this.getParseComments()) {
            this.handleComment(type, startMark, this.reader.getMark());
        }
    }

    private Token scanDirective(int startMark) {
        int endMark;
        List<Object> value;
        this.reader.forward();
        String name = this.scanDirectiveName(startMark);
        if ("YAML".equals(name)) {
            value = this.scanYamlDirectiveValue(startMark);
            endMark = this.reader.getMark();
            this.scanIgnoredLineTail((byte)3, startMark);
        } else if ("TAG".equals(name)) {
            value = this.scanTagDirectiveValue(startMark);
            endMark = this.reader.getMark();
            this.scanIgnoredLineTail((byte)3, startMark);
        } else {
            value = null;
            endMark = this.reader.getMark();
            this.forwardToLineEnd();
        }
        return new DirectiveToken<Integer>(name, value, startMark, endMark, this.scanProblem);
    }

    private String scanDirectiveName(int startMark) {
        int c;
        int length = 0;
        while (CharConstants.ALPHA.has(c = this.reader.peek(length))) {
            ++length;
        }
        if (length == 0) {
            this.newScannerException((byte)3, startMark, 4194673, this.reader.getMark());
            return "";
        }
        if (!CharConstants.isWhiteSpaceOrEol(c)) {
            this.newScannerException((byte)3, startMark, 4194675, this.reader.getMark());
        }
        return this.reader.prefixForward(length);
    }

    private List<@Nullable Integer> scanYamlDirectiveValue(int startMark) {
        Integer minor = null;
        while (CharConstants.isWhiteSpace(this.reader.peek())) {
            this.reader.forward();
        }
        int startOffset = this.reader.getMark();
        Integer major = this.scanYamlDirectiveNumber(startMark);
        if (major == null) {
            this.newScannerException((byte)4, startMark, 4194689, startOffset);
        }
        if (this.reader.peek() != 46) {
            this.newScannerException((byte)4, startMark, 4194690, startOffset, this.reader.getMark() + 1, null);
        } else {
            this.reader.forward();
            minor = this.scanYamlDirectiveNumber(startMark);
            if (minor == null) {
                this.newScannerException((byte)4, startMark, 4194690, startOffset, this.reader.getMark() + 1, null);
            }
        }
        if (!this.scanOK) {
            this.forwardToLineEnd();
        }
        ArrayList<Integer> result = new ArrayList<Integer>(2);
        result.add(major);
        result.add(minor);
        return result;
    }

    private @Nullable Integer scanYamlDirectiveNumber(int startMark) {
        int c;
        int length = 0;
        while ((c = this.reader.peek(length)) >= 48 && c <= 57) {
            ++length;
        }
        if (length == 0 || length > 3) {
            return null;
        }
        return Integer.valueOf(this.reader.prefixForward(length));
    }

    private List<@Nullable String> scanTagDirectiveValue(int startMark) {
        String prefix = null;
        while (this.reader.peek() == 32) {
            this.reader.forward();
        }
        String handle = this.scanTagHandle((byte)5, startMark);
        if (this.scanOK) {
            if (this.reader.peek() != 32) {
                this.newScannerException((byte)5, startMark, 4194723, this.reader.getMark(), this.reader.getMark() + 1, null);
            } else {
                do {
                    this.reader.forward();
                } while (this.reader.peek() == 32);
                prefix = this.scanTagUri((byte)5, startMark);
            }
        }
        ArrayList<String> result = new ArrayList<String>(2);
        result.add(handle);
        result.add(prefix);
        return result;
    }

    private void scanIgnoredLineTail(byte context, int startMark) {
        int c;
        int length = 0;
        while ((c = this.reader.peek(length)) == 32) {
            ++length;
        }
        this.reader.forward(length);
        if (c == 35) {
            if (length == 0) {
                this.newScannerException(context, startMark, 4194609, this.reader.getMark());
            }
            this.scanComment(CommentType.IN_LINE);
        }
        if (!this.scanLineBreak() && (c = this.reader.peek()) != 0) {
            this.newScannerException(context, startMark, 4194610, this.reader.getMark(), this.reader.getMark() + 1, null);
            this.forwardToLineEnd();
        }
    }

    private Token scanAnchor(byte context) {
        int c;
        int startMark = this.reader.getMark();
        this.reader.forward();
        int length = 0;
        while (CharConstants.NULL_BL_T_LINEBR.hasNo(c = this.reader.peek(length), ",[]{}/.&")) {
            ++length;
        }
        String value = null;
        if (length == 0) {
            this.newScannerException(context, startMark, 4194673, this.reader.getMark());
        } else if (this.createAnchorText) {
            value = this.reader.prefixForward(length);
        } else {
            this.reader.forward(length);
        }
        if (this.scanOK && CharConstants.NULL_BL_T_LINEBR.hasNo(c = this.reader.peek(), "?:,]}%@`")) {
            this.newScannerException(context, startMark, 4194608, this.reader.getMark(), this.reader.getMark() + 1, Character.toString(c));
        }
        int endMark = this.reader.getMark();
        Token tok = context == 9 ? new AliasToken(value, startMark, endMark, this.scanProblem) : new AnchorToken(value, startMark, endMark, this.scanProblem);
        return tok;
    }

    private Token scanTag() {
        String suffix;
        String handle;
        int startMark = this.reader.getMark();
        int c = this.reader.peek(1);
        if (c == 60) {
            handle = null;
            this.reader.forward(2);
            suffix = this.scanTagUri((byte)10, startMark);
            c = this.reader.peek();
            if (c != 62) {
                this.newScannerException((byte)10, startMark, 4919568);
            } else {
                this.reader.forward();
            }
        } else if (CharConstants.isWhiteSpaceOrEol(c)) {
            handle = null;
            suffix = "!";
            this.reader.forward();
        } else {
            int length = 1;
            boolean useHandle = false;
            while (!CharConstants.isWhiteSpaceOrEol(c)) {
                if (c == 33) {
                    useHandle = true;
                    break;
                }
                c = this.reader.peek(++length);
            }
            if (useHandle) {
                handle = this.scanTagHandle((byte)10, startMark);
            } else {
                handle = "!";
                this.reader.forward();
            }
            suffix = this.scanTagSuffix((byte)10, startMark);
        }
        if (this.scanOK && !CharConstants.isWhiteSpaceOrEol(c = this.reader.peek()) && (this.isBlockContext() || !CharConstants.isFlowCollectionEntryEndControl(c))) {
            this.newScannerException((byte)10, startMark, 4194610, this.reader.getMark());
        }
        int endMark = this.reader.getMark();
        TagTuple value = new TagTuple(handle, suffix);
        return new TagToken(value, startMark, endMark, this.scanProblem);
    }

    private Token scanBlockScalar(ScalarStyle style, int startMark) {
        int endMark;
        int blockIndent;
        StringBuilder text = this.getScalarSB();
        this.reader.forward();
        Chomping chomping = this.scanBlockScalarIndicators(startMark);
        this.scanIgnoredLineTail((byte)11, startMark);
        int minIndent = this.indent + 1;
        if (chomping.increment >= 0) {
            blockIndent = minIndent + chomping.increment - 1;
            endMark = this.scanBlockScalarBreaks(blockIndent);
        } else {
            endMark = this.scanBlockScalarIndentation();
            int maxIndent = this.tmpInt;
            blockIndent = Math.max(minIndent, maxIndent);
        }
        boolean lineBreak = false;
        if (this.reader.getColumn() < blockIndent && this.indent != this.reader.getColumn()) {
            this.newScannerException((byte)11, startMark, 4194768, this.reader.getMark());
            text = null;
            this.forwardToLineEnd();
            endMark = this.reader.getMark();
        } else {
            boolean wasLeadingNonSpace = false;
            while (this.reader.getColumn() == blockIndent) {
                boolean leadingNonSpace;
                boolean bl = leadingNonSpace = !CharConstants.isWhiteSpace(this.reader.peek());
                if (text != null) {
                    String breaks = this.getBreaks();
                    if (lineBreak) {
                        if (style == ScalarStyle.FOLDED && leadingNonSpace && wasLeadingNonSpace) {
                            if (breaks.isEmpty()) {
                                text.append(' ');
                            }
                        } else {
                            text.append('\n');
                        }
                    }
                    text.append(breaks);
                }
                wasLeadingNonSpace = leadingNonSpace;
                int length = 0;
                while (!CharConstants.isEol(this.reader.peek(length))) {
                    ++length;
                }
                if (length == 3 && this.reader.prefix(length).equals("...")) {
                    lineBreak = false;
                    break;
                }
                if (text != null) {
                    text.append(this.reader.prefix(length));
                }
                this.reader.forward(length);
                lineBreak = this.scanLineBreak();
                endMark = this.scanBlockScalarBreaks(blockIndent);
                if (this.reader.peek() != 0) continue;
                lineBreak = true;
                break;
            }
            if (text != null) {
                switch (chomping.method) {
                    case 1: {
                        if (!lineBreak) break;
                        text.append('\n');
                        break;
                    }
                    case 2: {
                        if (lineBreak) {
                            text.append('\n');
                        }
                        text.append(this.getBreaks());
                        break;
                    }
                }
            }
        }
        return new ScalarToken(text != null ? text.toString() : null, style, startMark, endMark, this.scanProblem);
    }

    private Chomping scanBlockScalarIndicators(int startMark) {
        int chomping = 1;
        int increment = -1;
        int c = this.reader.peek();
        while (c == 45 || c == 43) {
            if (chomping == 1) {
                chomping = c == 43 ? 2 : 0;
            } else {
                this.newScannerException((byte)11, startMark, 4194659, this.reader.getIndex(), this.reader.getIndex() + 1, null);
            }
            this.reader.forward();
            c = this.reader.peek();
        }
        if (c >= 48 && c <= 57) {
            int startOffset = this.reader.getMark();
            increment = c - 48;
            int length = 1;
            while ((c = this.reader.peek(length)) >= 48 && c <= 57) {
                ++length;
            }
            if (length > 1 || increment == 0) {
                this.newScannerException((byte)11, startMark, 4194657, startOffset, this.reader.getMark() + length, this.reader.prefix(length));
                increment = -1;
            }
            this.reader.forward(length);
            while (c == 45 || c == 43) {
                if (chomping == 1) {
                    chomping = c == 43 ? 2 : 0;
                } else {
                    this.newScannerException((byte)11, startMark, 4194659, this.reader.getIndex(), this.reader.getIndex() + 1, null);
                }
                this.reader.forward();
                c = this.reader.peek();
            }
        }
        return new Chomping((byte)chomping, increment);
    }

    private int scanBlockScalarIndentation() {
        int c;
        StringBuilder breaks = this.getBreaksSB();
        int maxIndent = 0;
        int endMark = this.reader.getMark();
        while ((c = this.reader.peek()) != 0) {
            if (c == 32) {
                this.reader.forward();
                if (this.reader.getColumn() <= maxIndent) continue;
                maxIndent = this.reader.getColumn();
                continue;
            }
            if (!CharConstants.isEol(c) || !this.scanLineBreak()) break;
            breaks.append('\n');
            endMark = this.reader.getMark();
        }
        this.tmpInt = maxIndent;
        return endMark;
    }

    private int scanBlockScalarBreaks(int indent) {
        StringBuilder breaks = this.getBreaksSB();
        int endMark = this.reader.getMark();
        int col = this.reader.getColumn();
        while (col < indent && this.reader.peek() == 32) {
            this.reader.forward();
            ++col;
        }
        while (this.scanLineBreak()) {
            breaks.append('\n');
            endMark = this.reader.getMark();
            col = this.reader.getColumn();
            while (col < indent && this.reader.peek() == 32) {
                this.reader.forward();
                ++col;
            }
        }
        return endMark;
    }

    private Token scanFlowScalar(byte context) {
        StringBuilder text;
        ScalarStyle style;
        int startMark;
        block7: {
            startMark = this.reader.getMark();
            int quote = switch (context) {
                case 13 -> {
                    style = ScalarStyle.DOUBLE_QUOTED;
                    yield 34;
                }
                case 12 -> {
                    style = ScalarStyle.SINGLE_QUOTED;
                    yield 39;
                }
                default -> throw new IllegalStateException(Integer.toString(context));
            };
            if (this.reader.peek() != quote) {
                throw new IllegalStateException(new String(Character.toChars(this.reader.peek())));
            }
            this.reader.forward();
            text = this.getScalarSB();
            do {
                this.scanFlowScalarNonSpaces(context, startMark, text);
                if (this.reader.peek() != quote) continue;
                this.reader.forward();
                break block7;
            } while (this.scanFlowScalarSpaces(context, startMark, text));
            this.newScannerException(context, startMark, 4751632);
        }
        int endMark = this.reader.getMark();
        if (this.reader.peek() == 35) {
            this.newScannerException(context, startMark, 4194609, this.reader.getMark());
            text = null;
        }
        return new ScalarToken(text != null ? text.toString() : null, style, startMark, endMark, this.scanProblem);
    }

    private void scanFlowScalarNonSpaces(byte context, int startMark, @Nullable StringBuilder textBuilder) {
        while (true) {
            int expLength;
            Character ch;
            Character bmp;
            int length = 0;
            while (CharConstants.NULL_BL_T_LINEBR.hasNo(this.reader.peek(length), "'\"\\")) {
                ++length;
            }
            if (length != 0) {
                if (textBuilder != null) {
                    textBuilder.append(this.reader.prefix(length));
                }
                this.reader.forward(length);
            }
            int c = this.reader.peek();
            if (context == 12 && c == 39 && this.reader.peek(1) == 39) {
                if (textBuilder != null) {
                    textBuilder.append("'");
                }
                this.reader.forward(2);
                continue;
            }
            if (context == 13 && c == 39 || context == 12 && (c == 34 || c == 92)) {
                if (textBuilder != null) {
                    textBuilder.appendCodePoint(c);
                }
                this.reader.forward();
                continue;
            }
            if (context != 13 || c != 92) break;
            int startOffset = this.reader.getMark();
            this.reader.forward();
            c = this.reader.peek();
            Character c2 = bmp = Character.isBmpCodePoint(c) ? Character.valueOf((char)c) : null;
            if (bmp != null && (ch = CharConstants.getEscapeReplacement(bmp)) != null) {
                this.reader.forward();
                if (textBuilder == null) continue;
                textBuilder.append(ch);
                continue;
            }
            if (bmp != null && (expLength = CharConstants.getEscapeCodeBytes(bmp.charValue())) > 0) {
                this.reader.forward();
                length = 0;
                while (length < expLength) {
                    c = this.reader.peek(length);
                    if (!CharConstants.isHexDigit(c)) break;
                    ++length;
                }
                if (length != expLength) {
                    this.newScannerException(context, startMark, 4751648, startOffset, this.reader.getMark() + length, "\\" + String.valueOf(bmp) + this.reader.prefix(length));
                    textBuilder = null;
                } else {
                    int codePoint = Integer.parseInt(this.reader.prefix(length), 16);
                    if (!Character.isValidCodePoint(codePoint)) {
                        this.newScannerException(context, startMark, 4751648, startOffset, this.reader.getMark() + length, "\\" + String.valueOf(bmp) + this.reader.prefix(length));
                        textBuilder = null;
                    } else if (textBuilder != null) {
                        textBuilder.appendCodePoint(codePoint);
                    }
                }
                this.reader.forward(length);
                continue;
            }
            if (this.scanLineBreak()) {
                this.scanFlowScalarBreaks(context, startMark);
                if (textBuilder == null) continue;
                textBuilder.append(this.getBreaks());
                continue;
            }
            this.newScannerException(context, startMark, 4751648, startOffset, this.reader.getMark() + 1, "\\" + Character.toString(c));
        }
    }

    private boolean scanFlowScalarSpaces(byte context, int startMark, @Nullable StringBuilder chunks) {
        int length = 0;
        while (CharConstants.isWhiteSpace(this.reader.peek(length))) {
            ++length;
        }
        String whitespaces = chunks != null ? this.reader.prefix(length) : null;
        this.reader.forward(length);
        if (this.reader.peek() == 0) {
            return false;
        }
        if (this.scanLineBreak()) {
            if (!this.scanFlowScalarBreaks(context, startMark)) {
                return false;
            }
            if (chunks != null) {
                String breaks = this.getBreaks();
                if (breaks.isEmpty()) {
                    chunks.append(' ');
                }
                chunks.append(breaks);
            }
        } else if (chunks != null) {
            chunks.append(whitespaces);
        }
        return true;
    }

    /*
     * Unable to fully structure code
     */
    private boolean scanFlowScalarBreaks(byte context, int startMark) {
        breaks = this.getBreaksSB();
        while (true) {
            if (!"---".equals(prefix = this.reader.prefix(3)) && !"...".equals(prefix) || !CharConstants.isWhiteSpaceOrEol(this.reader.peek(3))) ** GOTO lbl6
            return false;
lbl-1000:
            // 1 sources

            {
                this.reader.forward();
lbl6:
                // 2 sources

                ** while (CharConstants.isWhiteSpace((int)this.reader.peek()))
            }
lbl7:
            // 1 sources

            if (!this.scanLineBreak()) break;
            breaks.append('\n');
        }
        return true;
    }

    private Token scanPlain() {
        int startMark = this.reader.getMark();
        StringBuilder text = this.getScalarSB();
        int endMark = startMark;
        int plainIndent = this.indent + 1;
        String spaces = "";
        do {
            int length = 0;
            if (this.reader.peek() == 35) break;
            while (true) {
                int c = this.reader.peek(length);
                if (this.isFlowContext() ? CharConstants.isWhiteSpaceOrEolOrFlowCollectionControl(c) || c == 58 && CharConstants.isWhiteSpaceOrEolOrFlowCollectionControl(this.reader.peek(length + 1)) : CharConstants.isWhiteSpaceOrEol(c) || c == 58 && CharConstants.isWhiteSpaceOrEol(this.reader.peek(length + 1))) break;
                ++length;
            }
            if (length == 0) break;
            this.allowSimpleKey = false;
            if (text != null) {
                text.append(spaces);
                text.append(this.reader.prefix(length));
            }
            this.reader.forward(length);
            endMark = this.reader.getMark();
        } while ((spaces = this.scanPlainSpaces()).length() != 0 && this.reader.peek() != 35 && (!this.isBlockContext() || this.reader.getColumn() >= plainIndent));
        return new ScalarToken(text != null ? text.toString() : null, ScalarStyle.PLAIN, startMark, endMark, this.scanProblem);
    }

    private boolean atEndOfPlain() {
        int c;
        int wsLength = 0;
        int wsColumn = this.reader.getColumn();
        while ((c = this.reader.peek(wsLength)) != 0 && CharConstants.isWhiteSpaceOrEol(c)) {
            if (CharConstants.isWhiteSpace(c)) {
                ++wsLength;
                continue;
            }
            if (!CharConstants.isEol(c)) break;
            ++wsLength;
            wsColumn = 0;
        }
        if (this.reader.peek(wsLength) == 35 || this.reader.peek(wsLength + 1) == 0 || this.isBlockContext() && wsColumn < this.indent) {
            return true;
        }
        if (this.isBlockContext()) {
            int extra = 1;
            while ((c = this.reader.peek(wsLength + extra)) != 0) {
                if (CharConstants.isWhiteSpaceOrEol(c)) break;
                if (c == 58 && CharConstants.isWhiteSpaceOrEol(this.reader.peek(wsLength + extra + 1))) {
                    return true;
                }
                ++extra;
            }
        }
        return false;
    }

    private String scanPlainSpaces() {
        int length = 0;
        while (CharConstants.isWhiteSpace(this.reader.peek(length))) {
            ++length;
        }
        String whitespaces = this.reader.prefixForward(length);
        if (this.scanLineBreak()) {
            StringBuilder breaks;
            block7: {
                this.allowSimpleKey = true;
                String prefix = this.reader.prefix(3);
                if (("---".equals(prefix) || "...".equals(prefix)) && CharConstants.isWhiteSpaceOrEol(this.reader.peek(3))) {
                    return "";
                }
                if (this.getParseComments() && this.atEndOfPlain()) {
                    return "";
                }
                breaks = this.getBreaksSB();
                while (true) {
                    if (CharConstants.isWhiteSpace(this.reader.peek())) {
                        this.reader.forward();
                        continue;
                    }
                    if (!this.scanLineBreak()) break block7;
                    breaks.append('\n');
                    prefix = this.reader.prefix(3);
                    if (("---".equals(prefix) || "...".equals(prefix)) && CharConstants.isWhiteSpaceOrEol(this.reader.peek(3))) break;
                }
                return "";
            }
            if (breaks.isEmpty()) {
                return " ";
            }
            return breaks.toString();
        }
        return whitespaces;
    }

    private @Nullable String scanTagHandle(byte context, int startMark) {
        String value = null;
        int c = this.reader.peek();
        if (c != 33) {
            this.newScannerException(context, startMark, 4194721, this.reader.getMark());
            return null;
        }
        int length = 1;
        c = this.reader.peek(length);
        if (c != 32) {
            while (CharConstants.isIdentifierChar(c)) {
                c = this.reader.peek(++length);
            }
            if (c == 33) {
                ++length;
            } else {
                this.newScannerException(context, startMark, 4194722, this.reader.getMark());
            }
        }
        if (this.createAnchorText) {
            value = this.reader.prefix(length);
        }
        this.reader.forward(length);
        return value;
    }

    private String scanTagUri(byte context, int startMark) {
        int length = 0;
        while (CharConstants.isUriChar(this.reader.peek(length))) {
            ++length;
        }
        if (length == 0) {
            this.newScannerException(context, startMark, 4194705, this.reader.getMark());
        }
        return this.reader.prefixForward(length);
    }

    private String scanTagSuffix(byte context, int startMark) {
        int length = 0;
        while (CharConstants.isTagChar(this.reader.peek(length))) {
            ++length;
        }
        if (length == 0) {
            this.newScannerException(context, startMark, 4194725, this.reader.getMark());
        }
        return this.reader.prefixForward(length);
    }

    private boolean scanLineBreak() {
        switch (this.reader.peek()) {
            case 10: 
            case 133: {
                this.reader.forward();
                return true;
            }
            case 13: {
                if (10 == this.reader.peek(1)) {
                    this.reader.forward(2);
                } else {
                    this.reader.forward();
                }
                return true;
            }
        }
        return false;
    }

    private @Nullable StringBuilder getScalarSB() {
        if (this.createContentText) {
            this.tmpSB.setLength(0);
            return this.tmpSB;
        }
        return null;
    }

    private StringBuilder getBreaksSB() {
        this.tmpSB2.setLength(0);
        return this.tmpSB2;
    }

    private String getBreaks() {
        return this.tmpSB2.toString();
    }

    private void newScannerException(byte context, int contextMark, int statusCode) {
        if (this.scanOK) {
            this.scanOK = false;
            this.handleSyntaxProblem(context, contextMark, statusCode, null);
        }
    }

    private void newScannerException(byte context, int contextMark, int statusCode, int offset) {
        if (this.scanOK) {
            this.scanOK = false;
            this.handleSyntaxProblem(context, contextMark, statusCode, new StatusDetail(offset, offset, null));
        }
    }

    private void newScannerException(byte context, int contextMark, int statusCode, int startOffset, int endOffset, @Nullable String problemArg1) {
        if (this.scanOK) {
            this.scanOK = false;
            this.handleSyntaxProblem(context, contextMark, statusCode, new StatusDetail(startOffset, endOffset, problemArg1));
        }
    }

    protected void clearProblems() {
        this.scanOK = true;
        this.scanProblem = null;
    }

    protected void handleSyntaxProblem(byte context, int contextIndex, int statusCode, @Nullable StatusDetail statusDetail) {
        this.scanProblem = new SyntaxProblem(context, statusCode, statusDetail);
    }

    protected void handleComment(CommentType type, int startIndex, int endIndex) {
    }

    private static class Chomping {
        final byte method;
        final int increment;

        public Chomping(byte method, int increment) {
            this.method = method;
            this.increment = increment;
        }
    }
}

