/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.rj.server.srv;

import java.io.StreamCorruptedException;
import java.lang.reflect.Constructor;
import java.net.MalformedURLException;
import java.net.UnknownHostException;
import java.rmi.AlreadyBoundException;
import java.rmi.NoSuchObjectException;
import java.rmi.NotBoundException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.UnmarshalException;
import java.rmi.server.RMIClientSocketFactory;
import java.rmi.server.RMIServerSocketFactory;
import java.rmi.server.UnicastRemoteObject;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.rmi.RMIAddress;
import org.eclipse.statet.jcommons.rmi.RMIRegistry;
import org.eclipse.statet.rj.RjException;
import org.eclipse.statet.rj.RjInvalidConfigurationException;
import org.eclipse.statet.rj.server.RjsComConfig;
import org.eclipse.statet.rj.server.Server;
import org.eclipse.statet.rj.server.srv.ServerControl;
import org.eclipse.statet.rj.server.srv.engine.SrvEngineServer;
import org.eclipse.statet.rj.server.srvext.ServerAuthMethod;
import org.eclipse.statet.rj.server.srvext.ServerRuntimePlugin;
import org.eclipse.statet.rj.server.util.ServerUtils;

@NonNullByDefault
public class RMIServerControl
extends ServerControl {
    public static final int EXIT_REGISTRY_PROBLEM = 150;
    public static final int EXIT_REGISTRY_INVALID_ADDRESS = 151;
    public static final int EXIT_REGISTRY_CONNECTING_ERROR = 151;
    public static final int EXIT_REGISTRY_SERVER_STILL_ACTIVE = 152;
    public static final int EXIT_REGISTRY_ALREADY_BOUND = 153;
    public static final int EXIT_REGISTRY_CLEAN_FAILED = 155;
    public static final int EXIT_REGISTRY_BIND_FAILED = 156;
    public static final int EXIT_START_RENGINE_ERROR = 161;
    protected final String logPrefix;
    private final RMIAddress rmiAddress;
    private final @Nullable RMIClientSocketFactory rmiCsf;
    private final @Nullable RMIServerSocketFactory rmiSsf;
    private @Nullable Server mainServer;
    private boolean isPublished;

    public RMIServerControl(String name, Map<String, String> options) {
        super(options);
        int lastSegment = name.lastIndexOf(47);
        this.logPrefix = "[Control:" + (lastSegment >= 0 ? name.substring(lastSegment + 1) : name) + "]";
        try {
            RMIAddress address;
            this.rmiAddress = address = RMIAddress.parse((String)name);
        }
        catch (MalformedURLException | UnknownHostException e) {
            LogRecord record = new LogRecord(Level.SEVERE, "{0} the server address ''{1}'' is invalid.");
            record.setParameters(new Object[]{this.logPrefix, name});
            record.setThrown(e);
            LOGGER.log(record);
            RMIServerControl.exit(151);
            throw new IllegalStateException();
        }
        if (options != null && options.containsKey("verbose")) {
            RMIServerControl.initVerbose();
        }
        this.rmiCsf = RjsComConfig.getRMIServerClientSocketFactory(this.rmiAddress.isSsl());
        this.rmiSsf = RjsComConfig.getRMIServerServerSocketFactory(this.rmiAddress.isSsl());
    }

    public @Nullable RMIClientSocketFactory getRmiClientSocketFactory() {
        return this.rmiCsf;
    }

    public @Nullable RMIServerSocketFactory getRmiServerSocketFactory() {
        return this.rmiSsf;
    }

    public SrvEngineServer initServer() {
        LOGGER.log(Level.INFO, "{0} Initializing R engine server ({1})...", new Object[]{this.logPrefix, this.rmiAddress});
        try {
            String serverType = this.getOptions().get("server");
            if (serverType == null) {
                ServerAuthMethod auth = this.createServerAuth(this.getOptions().remove("auth"));
                return new SrvEngineServer(this, auth);
            }
            Class<?> serverClass = Class.forName(serverType);
            Constructor<?> constructor = serverClass.getConstructor(RMIServerControl.class);
            return (SrvEngineServer)constructor.newInstance(this);
        }
        catch (Exception e) {
            LogRecord record = new LogRecord(Level.SEVERE, "{0} Failed to initialize R engine server.");
            record.setParameters(new Object[]{this.logPrefix});
            record.setThrown(e);
            LOGGER.log(record);
            RMIServerControl.exit(141);
            throw new RuntimeException();
        }
    }

    protected RMIRegistry getRmiRegistry() throws RemoteException {
        return new RMIRegistry(this.rmiAddress.getRegistryAddress(), false);
    }

    public String getName() {
        return this.rmiAddress.getName();
    }

    public Remote exportObject(Remote obj) throws RemoteException {
        return UnicastRemoteObject.exportObject(obj, 0, this.rmiCsf, this.rmiSsf);
    }

    protected void publishServer(SrvEngineServer server) {
        try {
            RMIRegistry rmiRegistry = this.getRmiRegistry();
            Server stub = (Server)this.exportObject(server);
            this.mainServer = server;
            try {
                rmiRegistry.getRegistry().bind(this.getName(), stub);
            }
            catch (AlreadyBoundException boundException) {
                if (server.getConfigUnbindOnStartup() && this.unbindDead() == 0) {
                    rmiRegistry.getRegistry().bind(this.getName(), stub);
                }
                throw boundException;
            }
            catch (RemoteException remoteException) {
                if (!this.rmiAddress.isSsl() && remoteException.getCause() instanceof UnmarshalException && remoteException.getCause().getCause() instanceof StreamCorruptedException && RjsComConfig.getRMIServerClientSocketFactory(false) != null) {
                    stub = null;
                    try {
                        UnicastRemoteObject.unexportObject(server, true);
                        stub = (Server)UnicastRemoteObject.exportObject(server, 0, null, RjsComConfig.getRMIServerServerSocketFactory(false));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (stub != null) {
                        LogRecord record = new LogRecord(Level.SEVERE, "{0} caught StreamCorruptedException \nretrying without socket factory to reveal other potential problems.");
                        record.setParameters(new Object[]{this.logPrefix});
                        record.setThrown(remoteException);
                        LOGGER.log(record);
                        rmiRegistry.getRegistry().bind(this.getName(), stub);
                        rmiRegistry.getRegistry().unbind(this.getName());
                        throw new RjException("No error without socket factory, use the Java property 'org.eclipse.statet.rj.rmi.disableSocketFactory' to disable the factory.");
                    }
                }
                throw remoteException;
            }
            Runtime.getRuntime().addShutdownHook(new Thread(){

                @Override
                public void run() {
                    RMIServerControl.this.checkCleanup();
                }
            });
            this.isPublished = true;
            LOGGER.log(Level.INFO, "{0} server is added to registry - ready.", this.logPrefix);
            return;
        }
        catch (Exception e) {
            LogRecord record = new LogRecord(Level.SEVERE, "{0} init server failed.");
            record.setParameters(new Object[]{this.logPrefix});
            record.setThrown(e);
            LOGGER.log(record);
            if (e instanceof AlreadyBoundException) {
                RMIServerControl.exit(153);
            }
            this.checkCleanup();
            RMIServerControl.exit(156);
            return;
        }
    }

    protected int unbindDead() {
        Remote remote;
        try {
            RMIRegistry registry = this.getRmiRegistry();
            remote = registry.getRegistry().lookup(this.getName());
        }
        catch (NotBoundException lookupException) {
            return 0;
        }
        catch (RemoteException lookupException) {
            return 151;
        }
        if (!(remote instanceof Server)) {
            return 2;
        }
        try {
            ((Server)remote).getInfo();
            return 152;
        }
        catch (RemoteException deadException) {
            try {
                RMIRegistry rmiRegistry = this.getRmiRegistry();
                rmiRegistry.getRegistry().unbind(this.getName());
                LOGGER.log(Level.INFO, "{0} dead server removed from registry.", this.logPrefix);
                return 0;
            }
            catch (Exception unbindException) {
                return 155;
            }
        }
    }

    public void checkCleanup() {
        Server mainServer = this.mainServer;
        if (mainServer == null) {
            return;
        }
        LOGGER.log(Level.INFO, "{0} cleaning up server resources...", this.logPrefix);
        try {
            RMIRegistry rmiRegistry = this.getRmiRegistry();
            rmiRegistry.getRegistry().unbind(this.getName());
        }
        catch (NotBoundException rmiRegistry) {
        }
        catch (Exception e) {
            LogRecord record = new LogRecord(this.isPublished ? Level.SEVERE : Level.INFO, "{0} cleaning up server resources failed.");
            record.setParameters(new Object[]{this.logPrefix});
            record.setThrown(e);
            LOGGER.log(record);
        }
        try {
            UnicastRemoteObject.unexportObject(mainServer, true);
        }
        catch (NoSuchObjectException noSuchObjectException) {
            // empty catch block
        }
        this.mainServer = null;
        System.gc();
    }

    public ServerAuthMethod createServerAuth(@Nullable String config) throws RjException {
        String authConfig;
        String authType;
        try {
            ServerUtils.ArgKeyValue auth = ServerUtils.getArgSubValue(config);
            switch (auth.getKey()) {
                case "": {
                    throw new RjInvalidConfigurationException("Missing 'auth' configuration");
                }
                case "none": {
                    authType = "org.eclipse.statet.rj.server.srvext.auth.NoAuthMethod";
                    break;
                }
                case "name-pass": {
                    authType = "org.eclipse.statet.rj.server.srvext.auth.SimpleNamePassAuthMethod";
                    break;
                }
                case "fx": {
                    authType = "org.eclipse.statet.rj.server.srvext.auth.FxAuthMethod";
                    break;
                }
                case "local-shaj": {
                    authType = "org.eclipse.statet.rj.server.srvext.auth.LocalShajAuthMethod";
                    break;
                }
                default: {
                    authType = auth.getKey();
                }
            }
            authConfig = auth.getValue();
        }
        catch (Exception e) {
            LogRecord record = new LogRecord(Level.SEVERE, "{0} init authentication method failed.");
            record.setParameters(new Object[]{this.logPrefix});
            record.setThrown(e);
            LOGGER.log(record);
            throw new RjInvalidConfigurationException("Init authentication method failed.", e);
        }
        try {
            Class<?> authClass = Class.forName(authType);
            Constructor<?> constructor = authClass.getConstructor(new Class[0]);
            ServerAuthMethod authMethod = (ServerAuthMethod)constructor.newInstance(new Object[0]);
            authMethod.init(authConfig);
            return authMethod;
        }
        catch (Exception e) {
            LogRecord record = new LogRecord(Level.SEVERE, "{0} init authentication method ''{1}'' failed.");
            record.setParameters(new Object[]{this.logPrefix, authType});
            record.setThrown(e);
            LOGGER.log(record);
            throw new RjException(String.format("Init authentication method failed '%1$s'.", authType), e);
        }
    }

    public void start(SrvEngineServer server) {
        try {
            server.start(new ServerRuntimePlugin(){

                @Override
                public String getSymbolicName() {
                    return "rmi";
                }

                @Override
                public void rjIdle() throws Exception {
                }

                @Override
                public void rjStop(int state) throws Exception {
                    if (state == 0) {
                        try {
                            Thread.sleep(1000L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                    RMIServerControl.this.checkCleanup();
                }
            });
        }
        catch (Exception e) {
            LogRecord record = new LogRecord(Level.SEVERE, "{0} starting R engine server failed.");
            record.setParameters(new Object[]{this.logPrefix});
            record.setThrown(e);
            LOGGER.log(record);
            RMIServerControl.exit(141);
        }
        this.publishServer(server);
    }

    public void clean() {
        int dead = this.unbindDead();
        if (dead == 0) {
            RMIServerControl.exit(0);
            return;
        }
        if (dead == 152 && !this.getOptions().containsKey("force")) {
            RMIServerControl.exit(152);
        }
        try {
            RMIRegistry rmiRegistry = this.getRmiRegistry();
            rmiRegistry.getRegistry().unbind(this.getName());
            LOGGER.log(Level.INFO, "{0} server removed from registry.", this.logPrefix);
        }
        catch (NotBoundException e) {
            RMIServerControl.exit(0);
        }
        catch (RemoteException e) {
            LogRecord record = new LogRecord(Level.SEVERE, "{0} removing server from registry failed.");
            record.setParameters(new Object[]{this.logPrefix});
            record.setThrown(e);
            LOGGER.log(record);
            RMIServerControl.exit(151);
        }
    }
}

